<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package larson
 */

?>

<?php

//options
$blog_excerpt = get_field( 'blog_excerpt', 'option' );

//content
$image = get_the_post_thumbnail_url( get_the_ID(), 'larson_900xAuto' );

?>

<div class="latest-news__item col-12 col-lg-4">
  <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	  <div class="preview-card" tabindex="0" data-aos="fade">
	  	<?php if ( $image ) : ?>
	    <div class="preview-card__image">
	      <img src="<?php echo esc_url( $image ); ?>" width="350" height="352" alt="<?php echo esc_attr( get_the_title() ); ?>" />
	    </div>
	    <?php endif; ?>
	    <div class="preview-card__content">
	      <div class="preview-card__date"><?php echo esc_html( get_the_date() ); ?></div>
	      <h3 class="preview-card__heading"><a href="<?php echo esc_url( get_permalink() ); ?>"><?php the_title(); ?></a></h3>
	      <?php if ( ! $blog_excerpt ) : ?>
	      <div class="preview-card__text">
	      	<?php the_excerpt(); ?>
	      </div>
	      <?php endif; ?>
	      <a class="preview-card__btn" href="<?php echo esc_url( get_permalink() ); ?>">
	      	<?php echo esc_html__( 'Learn more', 'larson' ); ?>
	        <svg width="20" height="20">
	          <use xlink:href="#chevron-right"></use>
	        </svg>
	      </a>
	    </div>
	  </div>
  </div><!-- #post-<?php the_ID(); ?> -->
</div>