<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package larson
 */

?>

<?php

/* post content */
$current_categories = get_the_terms( get_the_ID(), 'portfolio_categories' );
$categories_slugs_string = '';
if ( $current_categories && ! is_wp_error( $current_categories ) ) {
	foreach ( $current_categories as $key => $value ) {
		$categories_slugs_string .= '__js_' . $value->slug . ' ';
	}
}

$image = get_the_post_thumbnail_url( get_the_ID(), 'larson_900xAuto' );
$title = get_the_title();
$href = get_the_permalink();
$short = get_field( 'short' );

?>

<a class="card swiper-slide <?php echo esc_attr( $categories_slugs_string ); ?>" href="<?php echo esc_url( $href ); ?>">
	<?php if ( $image ) : ?>
	<div class="card__image">
	  <img src="<?php echo esc_url( $image ); ?>" width="430" height="573" alt="<?php echo esc_attr( $title ); ?>" />
	</div>
	<?php endif; ?>
	<div class="card__content">
	  <?php if ( $title ) : ?>
	  <h3 class="card__heading">
	  	<?php echo esc_html( $title ); ?>
	  </h3>
	  <?php endif; ?>
	  <div class="card__text">
	  	<?php echo wp_kses_post( $short ); ?>
	  </div>
	  <div class="card__bottom">
	    <span class="card__link">
	      <?php echo esc_html__( 'See project', 'larson' ); ?>
	      <svg width="20" height="20">
	        <use xlink:href="#chevron-right"></use>
	      </svg>
	    </span>
	  </div>
	</div>
</a>