<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package larson
 */

?>

<?php

/* post content */
$image = get_the_post_thumbnail_url( get_the_ID(), 'larson_900x900' );
$title = get_the_title();
$href = get_the_permalink();
$short = get_field( 'short' );

?>

<a class="projects-carousel__item card card--carousel swiper-slide" href="<?php echo esc_url( $href ); ?>">
    <?php if ( $image ) : ?>
    <div class="card__image">
      <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $title ); ?>" />
    </div>
    <?php endif; ?>
    <div class="card__content">
      <?php if ( $title ) : ?>
      <h3 class="card__heading">
      	<?php echo esc_html( $title ); ?>
      </h3>
      <?php endif; ?>
      <?php if ( $short ) : ?>
      <div class="card__text">
      	<?php echo wp_kses_post( $short ); ?>
      </div>
      <?php endif; ?>
      <div class="card__bottom">
        <span class="card__link">
          <?php echo esc_html__( 'See project', 'larson' ); ?>
          <svg width="20" height="20">
            <use xlink:href="#chevron-right"></use>
          </svg>
        </span>
      </div>
    </div>
</a>