<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package larson
 */

?>

<?php

/* post content */
$current_categories = get_the_terms( get_the_ID(), 'portfolio_categories' );
$categories_string = '';
if ( $current_categories && ! is_wp_error( $current_categories ) ) {
	foreach ( $current_categories as $key => $value ) {
		$categories_string .= $value->name . esc_html__( ', ', 'larson' );
	}
}

$image = get_the_post_thumbnail_url( get_the_ID(), 'larson_1920xAuto' );
$title = get_the_title();
$href = get_the_permalink();
$short = get_field( 'short' );

?>

<li class="projects-grid__item col-md-6 col-lg-4 col-xl-3">
  <a class="card card--transparent __js_home-grid-card card--active" href="<?php echo esc_url( $href ); ?>"<?php if ( $image ) : ?> data-bg="<?php echo esc_url( $image ); ?>"<?php endif; ?>>
    <div class="card__content">
      <?php if ( $categories_string ) : ?>
      <div class="card__tag"><?php echo esc_html( $categories_string ); ?></div>
      <?php endif; ?>
      <?php if ( $title ) : ?>
      <h3 class="card__heading"><?php echo esc_html( $title ); ?></h3>
      <?php endif; ?>
      <?php if ( $short ) : ?>
      <div class="card__text"><?php echo wp_kses_post( $short ); ?></div>
      <?php endif; ?>
    </div>
  </a>
</li>