# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.0.1] - 2025-09-26

### Added
- **Product Form Enhancements**
  - Added missing fields from Product model to creation and editing forms
  - Added `license_type`, `renewal_price`, `renewal_period`, `duration_days` fields
  - Added `tax_rate`, `extended_support_price`, `extended_support_days` fields
  - Added `renewal_reminder_days`, `is_popular`, `auto_renewal` fields
  - Added `slug`, `integration_file_path`, `status`, `stock` fields
  - Added `supported_until`, `extended_supported_until` fields
  - Removed KB-related fields (`kb_category_id`) from product forms

- **Automatic Date Calculations**
  - Implemented JavaScript for automatic date calculations in product forms
  - `Supported Until` field now auto-calculates based on `support_days`
  - `Extended Supported Until` field now auto-calculates based on `renewal_period`
  - Added support for all renewal periods: monthly, quarterly, semi-annual, annual, three-years, lifetime

- **License System Overhaul**
  - **Product Data Inheritance**: Licenses now automatically inherit data from selected products
  - **Smart Domain Calculation**: Max domains automatically calculated based on license type:
    - Single Site: 1 domain
    - Multi Site: 5 domains (customizable)
    - Developer: 10 domains (customizable)
    - Extended: 20 domains (customizable)
  - **Automatic Expiry Dates**: License and support expiry dates calculated from product settings
  - **Enhanced License Types**: Updated from `regular/extended` to `single/multi/developer/extended`

- **Automatic Invoice Generation System**
  - **New Command**: `GenerateRenewalInvoices` for automatic renewal invoice creation
  - **Smart Scheduling**: 
    - Daily at 8:00 AM: Generate invoices for licenses expiring within 7 days
    - Weekly on Sundays: Generate invoices for licenses expiring within 30 days
  - **Intelligent Renewal Logic**: Calculates new expiry dates based on product renewal periods
  - **Duplicate Prevention**: Prevents creating multiple pending renewal invoices for same license

- **Enhanced Email Notifications**
  - Added renewal reminder emails for customers
  - Added admin notifications for renewal reminders
  - Added license creation notifications for admins
  - Enhanced email service with new template support

- **Translation System**
  - Added 35+ new translation keys for all new features
  - Complete Arabic, English, and Hindi translations
  - Added auto-calculation and product inheritance translations
  - Added translation for lifetime renewal explanation text

- **User Interface Improvements**
  - Added visual indicators for auto-calculated fields in product forms
  - Added helpful text explaining lifetime renewal behavior
  - Enhanced form validation with better error messages
  - Improved field descriptions and placeholders
  - Added readonly attributes to auto-calculated date fields

- **JavaScript Enhancements**
  - Enhanced product form calculations with lifetime support
  - Added debugging capabilities for troubleshooting
  - Improved error handling in AJAX requests
  - Added console logging for development debugging
  - Enhanced license form calculations with product data inheritance

### Changed
- **Product Forms**
  - Made `Supported Until` and `Extended Supported Until` fields read-only
  - Added visual indicators for auto-calculated fields
  - Enhanced form validation with new field requirements

- **License Forms**
  - Updated license type options to match new system
  - Made `max_domains` field read-only with auto-calculation
  - Added product data inheritance indicators
  - Enhanced form with real-time preview updates

- **Controller Updates**
  - Updated `LicenseController` to inherit data from products
  - Enhanced `ProductController` with new validation rules
  - Added `getProductData` method for AJAX requests
  - Updated `InvoiceService` with renewal invoice support
  - Added proper handling for lifetime renewal periods in ProductController
  - Enhanced validation rules for date constraints and license types
  - Added debugging capabilities in LicenseController for troubleshooting

### Fixed
- **Email Service**
  - Fixed duplicate `sendAdminLicenseCreated` method causing fatal error
  - Resolved method redeclaration issues

- **Code Organization**
  - Moved inline JavaScript to separate files (`product-form-calculations.js`, `license-form-calculations.js`)
  - Removed CSS/JS from Blade templates (following best practices)
  - Centralized calculation logic in dedicated JavaScript files

- **Validation Issues**
  - Fixed missing validation rules for new product fields
  - Added proper validation for license type inheritance
  - Enhanced form validation with better error handling

- **Database Schema Issues**
  - Fixed `license_type` enum values in licenses table (updated from `regular/extended` to `single/multi/developer/extended`)
  - Added missing `max_domains` field to licenses table
  - Fixed `license_type` validation error in license edit page
  - Resolved "Data truncated for column 'license_type'" MySQL error

- **Lifetime Renewal Period Issues**
  - Fixed invalid datetime format error when using `lifetime` renewal period
  - Updated JavaScript to handle `lifetime` correctly (sets field to empty instead of invalid date)
  - Added proper handling for `lifetime` in ProductController (sets `extended_supported_until` to null)
  - Added validation constraints for date fields (before 2100-01-01)

- **Array Field Display Issues**
  - Fixed `htmlspecialchars()` error with array fields in product edit form
  - Resolved issues with `features`, `requirements`, `tags`, and `installation_guide` fields
  - Added proper handling for array-to-string conversion in Blade templates
  - Fixed display issues when `old()` values contain arrays instead of strings

- **Migration Issues**
  - Created clean migration to fix failed license table structure updates
  - Implemented temporary column approach to safely update enum values
  - Added proper rollback support for all database changes
  - Resolved MySQL enum update limitations

- **Critical Bug Fixes**
  - Fixed "The selected license type is invalid" error in license edit page
  - Resolved "Data truncated for column 'license_type'" MySQL error
  - Fixed "Invalid datetime format" error with lifetime renewal period
  - Resolved "htmlspecialchars(): Argument #1 ($string) must be of type string, array given" error
  - Fixed duplicate method declaration in EmailService
  - Resolved array field display issues in product forms

### Technical Improvements
- **File Structure**
  - Created `public/assets/admin/js/product-form-calculations.js`
  - Created `public/assets/admin/js/license-form-calculations.js`
  - Added AJAX endpoint for product data retrieval

- **Database Integration**
  - Enhanced Product model field support
  - Updated License model validation
  - Improved Invoice model with metadata support

- **Database Migrations**
  - Created `2025_09_26_035515_update_products_license_type_values.php` - Updates products table license_type values
  - Created `2025_09_26_042332_clean_licenses_table_structure.php` - Fixes licenses table enum and adds max_domains field
  - Implemented safe enum value updates using temporary column approach
  - Added proper data migration from old to new license type values

- **Scheduling System**
  - Added automatic renewal invoice generation to Laravel scheduler
  - Implemented intelligent renewal period calculations
  - Added comprehensive error handling and logging

### Security
- **Input Validation**
  - Enhanced validation rules for all new fields
  - Added proper sanitization for auto-calculated values
  - Improved CSRF protection for AJAX requests
  - Added date validation constraints to prevent invalid dates
  - Enhanced array field validation to prevent XSS attacks

### Performance
- **Optimization**
  - Implemented efficient AJAX data loading for product information
  - Added caching for product data requests
  - Optimized JavaScript calculations with event delegation
  - Enhanced form validation performance with better error handling
  - Improved database query efficiency for license type updates

### Documentation
- **Comprehensive Documentation**
  - Created `LICENSE_SYSTEM_README.md` with complete system documentation
  - Added usage examples and configuration guides
  - Documented all new features and API endpoints

### Files Created/Modified
- **New Files Created**
  - `public/assets/admin/js/product-form-calculations.js` - Product form date calculations
  - `public/assets/admin/js/license-form-calculations.js` - License form calculations
  - `database/migrations/2025_09_26_035515_update_products_license_type_values.php` - Products table updates
  - `database/migrations/2025_09_26_042332_clean_licenses_table_structure.php` - Licenses table fixes
  - `app/Console/Commands/GenerateRenewalInvoices.php` - Automatic invoice generation command

- **Files Modified**
  - `app/Http/Controllers/Admin/ProductController.php` - Enhanced validation and AJAX endpoint
  - `app/Http/Controllers/Admin/LicenseController.php` - Product data inheritance and validation
  - `app/Services/EmailService.php` - Fixed duplicate methods and added renewal notifications
  - `app/Services/InvoiceService.php` - Enhanced renewal invoice support
  - `resources/views/admin/products/create.blade.php` - Added new fields and calculations
  - `resources/views/admin/products/edit.blade.php` - Enhanced form with new fields
  - `resources/views/admin/licenses/create.blade.php` - Product data inheritance
  - `resources/views/admin/licenses/edit.blade.php` - Enhanced license editing
  - `resources/lang/*/app.php` - Added 35+ new translation keys
  - `routes/web.php` - Added AJAX endpoint for product data
  - `routes/console.php` - Added scheduled commands

---
