<?php

namespace App\Console\Commands;

use App\Jobs\CreateRenewalInvoices;
use App\Jobs\ProcessOverdueInvoices;
use Illuminate\Console\Command;

class ProcessInvoicesCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'invoices:process {--renewal : Process renewal invoices only} {--overdue : Process overdue invoices only}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Process renewal and overdue invoices';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $renewalOnly = $this->option('renewal');
        $overdueOnly = $this->option('overdue');

        if (!$renewalOnly && !$overdueOnly) {
            // Process both
            $this->info('Processing renewal invoices...');
            CreateRenewalInvoices::dispatch();

            $this->info('Processing overdue invoices...');
            ProcessOverdueInvoices::dispatch();

            $this->info('All invoice processing jobs have been dispatched.');
        } elseif ($renewalOnly) {
            $this->info('Processing renewal invoices...');
            CreateRenewalInvoices::dispatch();
            $this->info('Renewal invoice processing job has been dispatched.');
        } elseif ($overdueOnly) {
            $this->info('Processing overdue invoices...');
            ProcessOverdueInvoices::dispatch();
            $this->info('Overdue invoice processing job has been dispatched.');
        }

        return Command::SUCCESS;
    }
}