<?php

namespace App\Helpers;

use App\Models\Setting;

class EnvatoHelper
{
    /**
     * Check if Envato API settings are configured
     *
     * @return bool
     */
    public static function isEnvatoConfigured()
    {
        $setting = Setting::first();

        return $setting &&
               $setting->envato_personal_token &&
               $setting->envato_client_id &&
               $setting->envato_client_secret;
    }

    /**
     * Get Envato API settings
     *
     * @return array|null
     */
    public static function getEnvatoSettings()
    {
        $setting = Setting::first();

        if (!$setting) {
            return null;
        }

        return [
            'personal_token' => $setting->envato_personal_token,
            'client_id' => $setting->envato_client_id,
            'client_secret' => $setting->envato_client_secret,
        ];
    }
}