<?php

namespace App\Http\Controllers;

use App\Models\Product;
use App\Models\User;
use App\Models\License;
use App\Models\Ticket;
use App\Models\Invoice;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Display the home page.
     */
    public function index()
    {
        $products = Product::where('is_active', true)->latest()->limit(6)->get();

        // Get system statistics
        $stats = [
            'customers' => User::count(),
            'licenses' => License::count(),
            'tickets' => Ticket::count(),
            'invoices' => Invoice::count(),
            'products' => Product::count(),
            'active_licenses' => License::where('status', 'active')->count(),
            'paid_invoices' => Invoice::where('status', 'paid')->count(),
            'open_tickets' => Ticket::whereIn('status', ['open', 'pending'])->count(),
        ];

        return view('welcome', compact('products', 'stats'));
    }
}