<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LicenseController extends Controller
{
    /**
     * Display a listing of the user's licenses.
     */
    public function index(Request $request)
    {
        $user = Auth::user();

        $licenses = $user->licenses()->with('product')->latest()->paginate(10);

        return view('user.licenses.index', compact('licenses'));
    }

    /**
     * Display the specified license.
     */
    public function show($id)
    {
        $user = Auth::user();
        
        $license = $user->licenses()->with(['product', 'domains'])->findOrFail($id);

        return view('user.licenses.show', compact('license'));
    }
}
