<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\Setting;

class CheckMaintenanceMode
{
    /**
     * Handle an incoming request.
     * If maintenance mode is enabled in settings, block non-admin and non-asset routes.
     */
    public function handle(Request $request, Closure $next)
    {
        try {
            $isMaintenance = (bool) Setting::get('maintenance_mode', false);
        } catch (\Throwable $e) {
            // If settings table is not ready, do not block the site
            $isMaintenance = false;
        }

        if ($isMaintenance) {
            // Allow admin area and its assets to function normally
            $isAdminPath = $request->is('admin*') || ($request->route() && str_starts_with((string) ($request->route()->getName() ?? ''), 'admin.'));

            // Allow access to debug/health endpoints
            $isHealth = $request->is('up') || $request->is('health') || $request->is('health/*');

            // Allow access to console/webhook endpoints that may be needed
            $allowlist = [
                'storage/*',
                'assets/*',
                'public/*',
                'favicon.ico',
            ];

            $isAllowlisted = false;
            foreach ($allowlist as $pattern) {
                if ($request->is($pattern)) {
                    $isAllowlisted = true;
                    break;
                }
            }

            if (! $isAdminPath && ! $isHealth && ! $isAllowlisted) {
                // Return a friendly maintenance page (503)
                return response()->view('maintenance', [], 503);
            }
        }

        return $next($request);
    }
}
