<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class IncreasePostSizeLimit
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Increase PHP limits for file uploads
        if (function_exists('ini_set')) {
            ini_set('post_max_size', '200M');
            ini_set('upload_max_filesize', '200M');
            ini_set('max_file_uploads', '50');
            ini_set('max_execution_time', '300');
            ini_set('memory_limit', '512M');
        }
        
        return $next($request);
    }
}
