<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\ProductFile;
use Illuminate\Support\Facades\Log;

class ProductFileSecurityMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        // Rate limiting for file downloads
        $key = 'file_download_' . $request->ip();
        $maxAttempts = 10; // Max 10 downloads per minute per IP
        $decayMinutes = 1;

        if (app('Illuminate\Cache\RateLimiter')->tooManyAttempts($key, $maxAttempts)) {
            Log::warning('File download rate limit exceeded', [
                'ip' => $request->ip(),
                'user_agent' => $request->userAgent(),
                'url' => $request->fullUrl()
            ]);
            
            return response()->json([
                'error' => 'Too many download attempts. Please try again later.'
            ], 429);
        }

        app('Illuminate\Cache\RateLimiter')->hit($key, $decayMinutes * 60);

        // Log file access attempts
        if ($request->route('file')) {
            $file = $request->route('file');
            Log::info('File access attempt', [
                'file_id' => $file->id,
                'product_id' => $file->product_id,
                'user_id' => auth()->id(),
                'ip' => $request->ip(),
                'user_agent' => $request->userAgent()
            ]);
        }

        return $next($request);
    }
}
