<?php

namespace App\Http\ViewComposers;

use App\Models\Setting;
use Illuminate\View\View;

class LayoutComposer
{
    /**
     * Bind data to the view.
     */
    public function compose(View $view): void
    {
        // Site settings
        $siteName = Setting::get('site_name', config('app.Name', 'Laravel'));
        $siteLogo = Setting::get('site_logo', null);

        // SEO settings
        $siteSeoTitle = Setting::get('seo_site_title', null);
        $siteSeoDescription = Setting::get('seo_site_description', null);
        $ogImage = Setting::get('seo_og_image', null);
        
        // KB SEO settings
        $kbSeoTitle = Setting::get('seo_kb_title', null);
        $kbSeoDescription = Setting::get('seo_kb_description', null);
        
        // Tickets SEO settings
        $ticketsSeoTitle = Setting::get('seo_tickets_title', null);
        $ticketsSeoDescription = Setting::get('seo_tickets_description', null);

        $view->with(compact(
            'siteName',
            'siteLogo',
            'siteSeoTitle',
            'siteSeoDescription',
            'ogImage',
            'kbSeoTitle',
            'kbSeoDescription',
            'ticketsSeoTitle',
            'ticketsSeoDescription'
        ));
    }
}