<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Providers\EnvatoSocialiteProvider;
use Illuminate\Support\Facades\View;
use Illuminate\Pagination\Paginator;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->register(EnvatoSocialiteProvider::class);
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Register View Composers
        \Illuminate\Support\Facades\View::composer(
            ['layouts.*', 'welcome'],
            \App\Http\ViewComposers\LayoutComposer::class
        );

        // Set default pagination view
        Paginator::defaultView('pagination::bootstrap-5');
        Paginator::defaultSimpleView('pagination::simple-bootstrap-5');
    }
}
