<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Laravel\Socialite\SocialiteManager;
use App\Services\EnvatoProvider;
use App\Services\EnvatoService;

class EnvatoSocialiteProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        \Laravel\Socialite\Facades\Socialite::extend('envato', function ($app) {
            $envatoService = app('App\Services\EnvatoService');
            $settings = $envatoService->getEnvatoSettings();

            return new EnvatoProvider(
                $app['request'],
                $settings['client_id'] ?? config('services.envato.client_id'),
                $settings['client_secret'] ?? config('services.envato.client_secret'),
                $settings['redirect'] ?? config('services.envato.redirect')
            );
        });
    }
}