<?php

namespace App\View\Components;

use Illuminate\View\Component;

class Dropdown extends Component
{
    public $align;
    public $width;
    public $contentClasses;
    public $alignmentClasses;
    public $widthClass;

    /**
     * Create a new component instance.
     */
    public function __construct($align = 'right', $width = '48', $contentClasses = 'py-1 bg-white dark:bg-gray-700')
    {
        $this->align = $align;
        $this->width = $width;
        $this->contentClasses = $contentClasses;
        $this->alignmentClasses = $this->getAlignmentClasses();
        $this->widthClass = $this->getWidthClass();
    }

    /**
     * Get the alignment CSS classes
     */
    protected function getAlignmentClasses()
    {
        return match ($this->align) {
            'left' => 'ltr:origin-top-left rtl:origin-top-right start-0',
            'top' => 'origin-top',
            default => 'ltr:origin-top-right rtl:origin-top-left end-0',
        };
    }

    /**
     * Get the width CSS class
     */
    protected function getWidthClass()
    {
        return match ($this->width) {
            '48' => 'w-48',
            default => $this->width,
        };
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render()
    {
        return view('components.dropdown');
    }
}