<?php

namespace App\View\Components;

use Illuminate\View\Component;

class Modal extends Component
{
    public $name;
    public $show;
    public $maxWidth;
    public $maxWidthClass;

    /**
     * Create a new component instance.
     */
    public function __construct($name, $show = false, $maxWidth = '2xl')
    {
        $this->name = $name;
        $this->show = $show;
        $this->maxWidth = $maxWidth;
        $this->maxWidthClass = $this->getMaxWidthClass();
    }

    /**
     * Get the max width CSS class
     */
    protected function getMaxWidthClass()
    {
        return [
            'sm' => 'sm:max-w-sm',
            'md' => 'sm:max-w-md',
            'lg' => 'sm:max-w-lg',
            'xl' => 'sm:max-w-xl',
            '2xl' => 'sm:max-w-2xl',
        ][$this->maxWidth] ?? 'sm:max-w-2xl';
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render()
    {
        return view('components.modal');
    }
}