<?php

namespace App\View\Components;

use Illuminate\View\Component;

class NavLink extends Component
{
    public $active;
    public $classes;

    /**
     * Create a new component instance.
     */
    public function __construct($active = false)
    {
        $this->active = $active;
        $this->classes = $this->getClasses();
    }

    /**
     * Get the CSS classes for the link
     */
    protected function getClasses()
    {
        if ($this->active) {
            return 'nav-link-active';
        }

        return 'nav-link';
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render()
    {
        return view('components.nav-link');
    }
}