<?php

return [
    // Welcome Page
    'welcome_title' => 'Welcome to License Management System',
    'welcome_subtitle' => 'Let\'s get your system up and running in just a few steps',
    'welcome_description' => 'This installation wizard will guide you through setting up your License Management System. The process should take about 5-10 minutes.',
    'get_started' => 'Get Started',
    'what_we_will_setup' => 'What we\'ll set up:',
    'select_language' => 'Select Language',
    'what_we_setup' => 'What we\'ll set up:',
    
    // Steps
    'step_requirements' => 'System requirements check',
    'step_requirements_desc' => 'Check system requirements and compatibility',
    'step_database' => 'Database configuration',
    'step_database_desc' => 'Configure database connection settings',
    'step_admin' => 'Admin account creation',
    'step_admin_desc' => 'Create administrator account',
    'step_settings' => 'System settings',
    'step_settings_desc' => 'Configure system preferences',
    'step_install' => 'Database installation',
    'step_install_desc' => 'Install database and run migrations',
    'step_complete' => 'Final setup',
    'step_complete_desc' => 'Finalize installation and setup',
    
    // Requirements Page
    'requirements_title' => 'System Requirements',
    'requirements_subtitle' => 'Let\'s check if your server meets the requirements',
    'requirements_all_passed' => 'All requirements are met! You can proceed with the installation.',
    'requirements_some_failed' => 'Some requirements are not met. Please fix the issues below before continuing.',
    'requirement_passed' => 'Passed',
    'requirement_failed' => 'Failed',
    'continue' => 'Continue',
    'back' => 'Back',
    'fix_requirements_first' => 'Fix Requirements First',
    
    // Database Page
    'database_title' => 'Database Configuration',
    'database_subtitle' => 'Enter your database connection details',
    'database_description' => 'Make sure your database server is running and the database exists. The installer will create the necessary tables.',
    'database_host' => 'Database Host',
    'database_port' => 'Database Port',
    'database_name' => 'Database Name',
    'database_username' => 'Database Username',
    'database_password' => 'Database Password',
    'test_connection' => 'Test Connection',
    'test_connection_continue' => 'Test Connection & Continue',
    'testing' => 'Testing...',
    'processing' => 'Processing...',
    
    // Admin Page
    'admin_title' => 'Admin Account',
    'admin_subtitle' => 'Create your administrator account',
    'admin_description' => 'This account will have full access to the system. Make sure to use a strong password.',
    'admin_name' => 'Full Name',
    'admin_email' => 'Email Address',
    'admin_password' => 'Password',
    'admin_password_confirmation' => 'Confirm Password',
    'password_requirements' => 'Password must be at least 8 characters long and contain a mix of letters, numbers, and symbols.',
    'create_admin_account' => 'Create Admin Account',
    
    // Settings Page
    'settings_title' => 'System Settings',
    'settings_subtitle' => 'Configure your system preferences',
    'settings_description' => 'You can change these settings later from the admin panel.',
    'site_name' => 'Site Name',
    'site_description' => 'Site Description',
    'admin_email' => 'Admin Email',
    'timezone' => 'Timezone',
    'default_language' => 'Default Language',
    'save_settings' => 'Save Settings',
    
    // Installation Page
    'install_title' => 'Installation',
    'install_subtitle' => 'Installing your License Management System',
    'install_description' => 'This process may take a few minutes. Please do not close this window.',
    'start_installation' => 'Start Installation',
    'installing' => 'Installing...',
    'updating_configuration' => 'Updating Configuration',
    'updating_configuration_desc' => 'Updating environment configuration files...',
    'creating_database_tables' => 'Creating Database Tables',
    'creating_database_tables_desc' => 'Running database migrations...',
    'seeding_database' => 'Seeding Database',
    'seeding_database_desc' => 'Adding initial data (tickets, languages, email templates)...',
    'setting_up_roles_permissions' => 'Setting Up Roles & Permissions',
    'setting_up_roles_permissions_desc' => 'Creating user roles and permissions...',
    'creating_admin_account' => 'Creating Admin Account',
    'creating_admin_account_desc' => 'Setting up administrator account...',
    'configuring_system_settings' => 'Configuring System Settings',
    'configuring_system_settings_desc' => 'Applying system configuration...',
    'creating_storage_link' => 'Creating Storage Link',
    'creating_storage_link_desc' => 'Linking storage directory for file access',
    'finalizing_installation' => 'Finalizing Installation',
    'finalizing_installation_desc' => 'Completing installation process...',
    
    // Additional translations
    'step_welcome' => 'Welcome',
    'required' => 'Required',
    'current' => 'Current',
    'requirements_success_message' => 'Your server meets all the requirements to run this application.',
    'requirements_failed_message' => 'Please fix the failed requirements before continuing.',
    'fix_requirements' => 'Fix Requirements First',
    'testing' => 'Testing...',
    'password_hint' => 'Password must be at least 8 characters long',
    'javascript_required_for_email_settings' => 'JavaScript is required for dynamic email settings. Please enable JavaScript or manually configure email settings.',
    'javascript_required_for_language_switching' => 'JavaScript is required for dynamic language switching. Please enable JavaScript or refresh the page after changing language.',
    'javascript_required_for_password_validation' => 'JavaScript is required for real-time password validation. Please enable JavaScript for better user experience.',
    'admin_email_hint' => 'This will be used for system notifications',
    
    // Success Messages
    'installation_complete' => 'Installation Complete!',
    'installation_complete_subtitle' => 'Your License Management System is ready to use.',
    'installation_success' => 'Installation completed successfully! Redirecting to login page...',
    
    // Error Messages
    'validation_errors' => 'Validation Errors',
    'database_connection_failed' => 'Database connection failed',
    'installation_failed' => 'Installation failed',
    'system_already_installed' => 'System is already installed.',
    
    // Form Validation
    'field_required' => 'This field is required',
    'invalid_email' => 'Please enter a valid email address',
    'password_too_short' => 'Password must be at least 8 characters long',
    'passwords_do_not_match' => 'Passwords do not match',
    'invalid_port' => 'Port must be between 1 and 65535',
    
    // Progress
    'step_of' => 'Step :current of :total',
    
    // Timezones
    'timezone_utc' => 'UTC',
    'timezone_america_new_york' => 'America/New_York',
    'timezone_america_chicago' => 'America/Chicago',
    'timezone_america_denver' => 'America/Denver',
    'timezone_america_los_angeles' => 'America/Los_Angeles',
    'timezone_europe_london' => 'Europe/London',
    'timezone_europe_paris' => 'Europe/Paris',
    'timezone_europe_berlin' => 'Europe/Berlin',
    'timezone_asia_tokyo' => 'Asia/Tokyo',
    'timezone_asia_shanghai' => 'Asia/Shanghai',
    'timezone_asia_dubai' => 'Asia/Dubai',
    'timezone_asia_riyadh' => 'Asia/Riyadh',
    
    // Languages
    'language_english' => 'English',
    'language_arabic' => 'العربية',
    
    // Completion Page
    'completion_title' => 'Installation Completed',
    'completion_subtitle' => 'Your system has been successfully installed and configured',
    'installation_completed' => 'Installation Completed Successfully!',
    'installation_success_message' => 'Congratulations! Your License Management System has been installed and configured successfully.',
    'admin_account_created' => 'Administrator Account Created',
    'admin_name' => 'Name',
    'admin_email' => 'Email',
    'account_status' => 'Status',
    'email_verified' => 'Email Verified',
    'system_information' => 'System Information',
    'site_name' => 'Site Name',
    'database_connected' => 'Database',
    'default_language' => 'Default Language',
    'timezone' => 'Timezone',
    'important_notice' => 'Important Security Notice',
    'delete_install_folder_warning' => 'For security reasons, please delete the install folder after completing the installation process.',
    'next_steps' => 'Next Steps',
    'delete_install_folder' => 'Delete Install Folder',
    'delete_install_folder_description' => 'Remove the install directory to prevent unauthorized access to the installation wizard.',
    'configure_system' => 'Configure System',
    'configure_system_description' => 'Access the admin panel to configure your system settings and preferences.',
    'secure_system' => 'Secure Your System',
    'secure_system_description' => 'Review security settings and configure additional security measures.',
    'go_to_admin_panel' => 'Go to Admin Panel',
    'go_to_frontend' => 'Go to Frontend',
    'completion_note' => 'You can always access the admin panel from the frontend by logging in with your administrator account.',
    'database_created' => 'Database Created',
    'system_configured' => 'System Configured',
    // Email Configuration
    'email_configuration' => 'Email Configuration',
    'email_configuration_subtitle' => 'Configure email settings for notifications and system emails (optional)',
    'enable_email_notifications' => 'Enable Email Notifications',
    'enable_email_hint' => 'Check this to configure email settings. You can skip this and configure later from admin panel.',
    'mail_mailer' => 'Mail Driver',
    'mail_host' => 'SMTP Host',
    'mail_port' => 'SMTP Port',
    'mail_encryption' => 'Encryption',
    'mail_username' => 'SMTP Username',
    'mail_password' => 'SMTP Password',
    'mail_password_placeholder' => 'Enter your email password or app password',
    'mail_password_hint' => 'For Gmail, use App Password instead of your regular password',
    'mail_from_address' => 'From Email Address',
    'mail_from_name' => 'From Name',
    'mail_from_name_placeholder' => 'Your Company Name',
    
    'previous' => 'Previous',
    
];