@extends('layouts.admin')
@section('title', 'KB Articles')

@section('admin-content')
<div class="admin-page-header">
    <div class="admin-page-header-content">
        <div class="admin-page-title">
            <h1>{{ trans('app.kb_articles_management') }}</h1>
            <p class="admin-page-subtitle">{{ trans('app.manage_kb_articles') }}</p>
        </div>
        <div class="admin-page-actions">
            <a href="{{ route('admin.kb-articles.create') }}" class="admin-btn admin-btn-info admin-btn-m">
                <i class="fas fa-plus me-2"></i>
                {{ trans('app.new_article') }}
            </a>
        </div>
    </div>
</div>

@if(session('success'))
<div class="admin-alert admin-alert-success mb-6">
    <div class="flex">
        <i class="fas fa-check-circle text-green-500 mt-0.5 mr-3"></i>
        <div>
            <h4 class="font-semibold">{{ trans('app.Success') }}</h4>
            <p class="mt-1">{{ session('success') }}</p>
        </div>
    </div>
</div>
@endif

@if(session('error'))
<div class="admin-alert admin-alert-error mb-6">
    <div class="flex">
        <i class="fas fa-exclamation-triangle text-red-500 mt-0.5 mr-3"></i>
        <div>
            <h4 class="font-semibold">{{ trans('app.Error') }}</h4>
            <p class="mt-1">{{ session('error') }}</p>
        </div>
    </div>
</div>
@endif

<!-- Enhanced Filters Section -->
<div class="card mb-4">
    <div class="card-header bg-light">
        <div class="d-flex align-items-center">
            <i class="fas fa-filter me-3 text-primary"></i>
            <div>
                <h5 class="card-title mb-0">{{ trans('app.Filters') }}</h5>
                <small class="text-muted">{{ trans('app.Filter and search KB articles') }}</small>
            </div>
        </div>
    </div>
    <div class="card-body">
        <div class="row g-3">
            <div class="col-md-4">
                <label for="searchArticles" class="form-label">{{ trans('app.Search') }}</label>
                <input type="text" id="searchArticles" class="form-control" 
                       placeholder="{{ trans('app.search_articles') }}">
            </div>
            <div class="col-md-4">
                <label for="category-filter" class="form-label">{{ trans('app.Category') }}</label>
                <select id="category-filter" class="form-select">
                    <option value="">{{ trans('app.All Categories') }}</option>
                    @foreach($categories as $category)
                    <option value="{{ $category->id }}">{{ $category->name }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-4">
                <label for="status-filter" class="form-label">{{ trans('app.Status') }}</label>
                <select id="status-filter" class="form-select">
                    <option value="">{{ trans('app.All Statuses') }}</option>
                    <option value="published">{{ trans('app.published') }}</option>
                    <option value="draft">{{ trans('app.draft') }}</option>
                </select>
            </div>
        </div>
    </div>
</div>

<!-- KB Articles Statistics -->
<div class="row g-4 mb-5">
    <div class="col-lg-3 col-md-6">
        <div class="card border-0 shadow-sm stats-card">
            <div class="card-body p-4">
                <div class="d-flex align-items-center">
                    <div class="stats-icon bg-primary bg-opacity-10 rounded-circle p-3 me-3">
                        <i class="fas fa-file-alt text-primary fs-4"></i>
                    </div>
                    <div class="flex-grow-1">
                        <p class="text-muted small mb-1 fw-medium">{{ trans('app.Total Articles') }}</p>
                        <h3 class="fw-bold mb-1 text-dark">{{ $articles->total() }}</h3>
                        <small class="text-primary fw-medium">{{ trans('app.All KB articles') }}</small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-6">
        <div class="card border-0 shadow-sm stats-card">
            <div class="card-body p-4">
                <div class="d-flex align-items-center">
                    <div class="stats-icon bg-success bg-opacity-10 rounded-circle p-3 me-3">
                        <i class="fas fa-check-circle text-success fs-4"></i>
                    </div>
                    <div class="flex-grow-1">
                        <p class="text-muted small mb-1 fw-medium">{{ trans('app.Published Articles') }}</p>
                        <h3 class="fw-bold mb-1 text-dark">{{ $articles->where('is_published', true)->count() }}</h3>
                        <small class="text-success fw-medium">{{ trans('app.Publicly available') }}</small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-6">
        <div class="card border-0 shadow-sm stats-card">
            <div class="card-body p-4">
                <div class="d-flex align-items-center">
                    <div class="stats-icon bg-warning bg-opacity-10 rounded-circle p-3 me-3">
                        <i class="fas fa-edit text-warning fs-4"></i>
                    </div>
                    <div class="flex-grow-1">
                        <p class="text-muted small mb-1 fw-medium">{{ trans('app.Draft Articles') }}</p>
                        <h3 class="fw-bold mb-1 text-dark">{{ $articles->where('is_published', false)->count() }}</h3>
                        <small class="text-warning fw-medium">{{ trans('app.Under review') }}</small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-6">
        <div class="card border-0 shadow-sm stats-card">
            <div class="card-body p-4">
                <div class="d-flex align-items-center">
                    <div class="stats-icon bg-info bg-opacity-10 rounded-circle p-3 me-3">
                        <i class="fas fa-folder text-info fs-4"></i>
                    </div>
                    <div class="flex-grow-1">
                        <p class="text-muted small mb-1 fw-medium">{{ trans('app.Categories') }}</p>
                        <h3 class="fw-bold mb-1 text-dark">{{ $categories->count() }}</h3>
                        <small class="text-info fw-medium">{{ trans('app.Available categories') }}</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- KB Articles Table -->
<div class="card">
    <div class="card-header bg-light">
        <div class="d-flex align-items-center justify-content-between">
            <div class="d-flex align-items-center">
                <i class="fas fa-file-alt me-3 text-primary"></i>
                <div>
                    <h5 class="card-title mb-0">{{ trans('app.all_articles') }}</h5>
                    <small class="text-muted">{{ trans('app.Manage and organize knowledge base articles') }}</small>
                </div>
            </div>
            <div>
                <span class="badge bg-info fs-6">{{ $articles->total() }} {{ trans('app.Articles') }}</span>
            </div>
        </div>
    </div>

    <div class="card-body p-0">
        @if($articles->count() > 0)
        <div class="table-responsive">
            <table class="table table-hover mb-0 kb-articles-table">
                <thead class="table-light">
                    <tr>
                        <th class="text-center">{{ trans('app.Avatar') }}</th>
                        <th class="text-center">{{ trans('app.Article') }}</th>
                        <th class="text-center">{{ trans('app.Category') }}</th>
                        <th class="text-center">{{ trans('app.Status') }}</th>
                        <th class="text-center">{{ trans('app.Views') }}</th>
                        <th class="text-center">{{ trans('app.Created') }}</th>
                        <th class="text-center">{{ trans('app.Actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($articles as $article)
                    <tr class="article-row" data-title="{{ strtolower($article->title) }}" data-category="{{ $article->category_id ?? '' }}" data-status="{{ $article->is_published ? 'published' : 'draft' }}">
                        <td class="text-center">
                            <div class="bg-light rounded d-flex align-items-center justify-content-center article-avatar">
                                <span class="text-muted small fw-bold">{{ strtoupper(substr($article->title, 0, 1)) }}</span>
                            </div>
                        </td>
                        <td>
                            <div class="fw-semibold text-dark">{{ $article->title }}</div>
                            @if($article->excerpt)
                            <small class="text-muted">{{ Str::limit($article->excerpt, 60) }}</small>
                            @endif
                        </td>
                        <td class="text-center">
                            @if($article->category)
                                <span class="text-muted">{{ $article->category->name }}</span>
                            @else
                                <span class="text-muted">—</span>
                            @endif
                        </td>
                        <td class="text-center">
                            <span class="badge {{ $article->is_published ? 'bg-success' : 'bg-warning' }}">
                                @if($article->is_published)
                                    <i class="fas fa-check-circle me-1"></i>{{ trans('app.published') }}
                                @else
                                    <i class="fas fa-edit me-1"></i>{{ trans('app.draft') }}
                                @endif
                            </span>
                        </td>
                        <td class="text-center">
                            <span class="badge bg-secondary">
                                <i class="fas fa-eye me-1"></i>{{ $article->views_count ?? 0 }}
                            </span>
                        </td>
                        <td class="text-center">
                            <div class="fw-semibold text-dark">{{ $article->created_at->format('M d, Y') }}</div>
                            <small class="text-muted">{{ $article->created_at->diffForHumans() }}</small>
                        </td>
                        <td class="text-center">
                            <div class="btn-group-vertical btn-group-sm" role="group">
                                <a href="{{ route('admin.kb-articles.show', $article) }}"
                                   class="btn btn-outline-info btn-sm">
                                    <i class="fas fa-eye me-1"></i>
                                    {{ trans('app.View') }}
                                </a>

                                <a href="{{ route('admin.kb-articles.edit', $article) }}"
                                   class="btn btn-outline-primary btn-sm">
                                    <i class="fas fa-edit me-1"></i>
                                    {{ trans('app.Edit') }}
                                </a>

                                <form action="{{ route('admin.kb-articles.destroy', $article) }}" method="POST"
                                      class="d-inline" data-confirm="delete-article">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-outline-danger btn-sm w-100">
                                        <i class="fas fa-trash me-1"></i>
                                        {{ trans('app.Delete') }}
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="card-footer">
            <div class="d-flex justify-content-center">
                {{ $articles->links() }}
            </div>
        </div>
        @else
        <div class="text-center py-5">
            <div class="mb-4">
                <i class="fas fa-file-alt text-muted empty-state-icon"></i>
            </div>
            <h4 class="text-muted">{{ trans('app.No Articles Found') }}</h4>
            <p class="text-muted mb-4">{{ trans('app.Create your first KB article to get started') }}</p>
            <a href="{{ route('admin.kb-articles.create') }}" class="btn btn-primary btn-lg">
                <i class="fas fa-plus me-2"></i>
                {{ trans('app.Create Your First Article') }}
            </a>
        </div>
        @endif
    </div>
</div>

<!-- JavaScript is now handled by admin-categories.js -->


@endsection