@extends('layouts.admin')

@section('admin-content')
<div class="admin-page-header">
    <div class="admin-page-header-content">
        <div class="admin-page-title">
            <h1>{{ trans('app.kb_categories_management') }}</h1>
            <p class="admin-page-subtitle">{{ trans('app.organize_kb_categories') }}</p>
        </div>
        <div class="admin-page-actions">
            <a href="{{ route('admin.kb-categories.create') }}" class="admin-btn admin-btn-info admin-btn-m">
                <i class="fas fa-plus me-2"></i>
                {{ trans('app.new_category') }}
            </a>
        </div>
    </div>
</div>

@if(session('success'))
<div class="admin-alert admin-alert-success mb-6">
    <div class="flex">
        <i class="fas fa-check-circle text-green-500 mt-0.5 mr-3"></i>
        <div>
            <h4 class="font-semibold">{{ trans('app.Success') }}</h4>
            <p class="mt-1">{{ session('success') }}</p>
        </div>
    </div>
</div>
@endif

@if(session('error'))
<div class="admin-alert admin-alert-error mb-6">
    <div class="flex">
        <i class="fas fa-exclamation-triangle text-red-500 mt-0.5 mr-3"></i>
        <div>
            <h4 class="font-semibold">{{ trans('app.Error') }}</h4>
            <p class="mt-1">{{ session('error') }}</p>
        </div>
    </div>
</div>
@endif

<!-- Enhanced Filters Section -->
<div class="card mb-4">
    <div class="card-header bg-light">
        <div class="d-flex align-items-center">
            <i class="fas fa-filter me-3 text-primary"></i>
            <div>
                <h5 class="card-title mb-0">{{ trans('app.Filters') }}</h5>
                <small class="text-muted">{{ trans('app.Filter and search KB categories') }}</small>
            </div>
        </div>
    </div>
    <div class="card-body">
        <div class="row g-3">
            <div class="col-md-6">
                <label for="searchCategories" class="form-label">{{ trans('app.Search') }}</label>
                <input type="text" id="searchCategories" class="form-control" 
                       placeholder="{{ trans('app.search_categories') }}">
            </div>
            <div class="col-md-6">
                <label for="protection-filter" class="form-label">{{ trans('app.Protection') }}</label>
                <select id="protection-filter" class="form-select">
                    <option value="">{{ trans('app.All Protection Levels') }}</option>
                    <option value="protected">{{ trans('app.serial_protected') }}</option>
                    <option value="public">{{ trans('app.public') }}</option>
                </select>
            </div>
        </div>
    </div>
</div>

<!-- KB Categories Statistics -->
<div class="row g-4 mb-5">
    <div class="col-lg-3 col-md-6">
        <div class="card border-0 shadow-sm stats-card">
            <div class="card-body p-4">
                <div class="d-flex align-items-center">
                    <div class="stats-icon bg-primary bg-opacity-10 rounded-circle p-3 me-3">
                        <i class="fas fa-folder text-primary fs-4"></i>
                    </div>
                    <div class="flex-grow-1">
                        <p class="text-muted small mb-1 fw-medium">{{ trans('app.Total Categories') }}</p>
                        <h3 class="fw-bold mb-1 text-dark">{{ $categories->total() }}</h3>
                        <small class="text-primary fw-medium">{{ trans('app.All KB categories') }}</small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-6">
        <div class="card border-0 shadow-sm stats-card">
            <div class="card-body p-4">
                <div class="d-flex align-items-center">
                    <div class="stats-icon bg-success bg-opacity-10 rounded-circle p-3 me-3">
                        <i class="fas fa-file-alt text-success fs-4"></i>
                    </div>
                    <div class="flex-grow-1">
                        <p class="text-muted small mb-1 fw-medium">{{ trans('app.Total Articles') }}</p>
                        <h3 class="fw-bold mb-1 text-dark">{{ $categories->sum('articles_count') ?? 0 }}</h3>
                        <small class="text-success fw-medium">{{ trans('app.Across all categories') }}</small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-6">
        <div class="card border-0 shadow-sm stats-card">
            <div class="card-body p-4">
                <div class="d-flex align-items-center">
                    <div class="stats-icon bg-warning bg-opacity-10 rounded-circle p-3 me-3">
                        <i class="fas fa-lock text-warning fs-4"></i>
                    </div>
                    <div class="flex-grow-1">
                        <p class="text-muted small mb-1 fw-medium">{{ trans('app.Protected Categories') }}</p>
                        <h3 class="fw-bold mb-1 text-dark">{{ $categories->where('requires_serial', true)->count() }}</h3>
                        <small class="text-warning fw-medium">{{ trans('app.Serial protected') }}</small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-6">
        <div class="card border-0 shadow-sm stats-card">
            <div class="card-body p-4">
                <div class="d-flex align-items-center">
                    <div class="stats-icon bg-info bg-opacity-10 rounded-circle p-3 me-3">
                        <i class="fas fa-unlock text-info fs-4"></i>
                    </div>
                    <div class="flex-grow-1">
                        <p class="text-muted small mb-1 fw-medium">{{ trans('app.Public Categories') }}</p>
                        <h3 class="fw-bold mb-1 text-dark">{{ $categories->where('requires_serial', false)->count() }}</h3>
                        <small class="text-info fw-medium">{{ trans('app.Open access') }}</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- KB Categories Table -->
<div class="card">
    <div class="card-header bg-light">
        <div class="d-flex align-items-center justify-content-between">
            <div class="d-flex align-items-center">
                <i class="fas fa-folder me-3 text-primary"></i>
                <div>
                    <h5 class="card-title mb-0">{{ trans('app.all_categories') }}</h5>
                    <small class="text-muted">{{ trans('app.Organize and manage knowledge base categories') }}</small>
                </div>
            </div>
            <div>
                <span class="badge bg-info fs-6">{{ $categories->total() }} {{ trans('app.Categories') }}</span>
            </div>
        </div>
    </div>

    <div class="card-body p-0">
        @if($categories->count() > 0)
        <div class="table-responsive">
            <table class="table table-hover mb-0 kb-categories-table">
                <thead class="table-light">
                    <tr>
                        <th class="text-center">{{ trans('app.Avatar') }}</th>
                        <th>{{ trans('app.Category') }}</th>
                        <th class="text-center">{{ trans('app.Parent') }}</th>
                        <th class="text-center">{{ trans('app.Articles') }}</th>
                        <th class="text-center">{{ trans('app.Protection') }}</th>
                        <th class="text-center">{{ trans('app.Created') }}</th>
                        <th class="text-center">{{ trans('app.Actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($categories as $cat)
                    <tr class="category-row" data-name="{{ strtolower($cat->name) }}" data-protection="{{ $cat->requires_serial ? 'protected' : 'public' }}">
                        <td class="text-center">
                            <div class="bg-light rounded d-flex align-items-center justify-content-center category-avatar">
                                @if($cat->icon)
                                    <i class="{{ $cat->icon }} text-primary"></i>
                                @else
                                    <span class="text-muted small fw-bold">{{ strtoupper(substr($cat->name, 0, 1)) }}</span>
                                @endif
                            </div>
                        </td>
                        <td>
                            <div class="fw-semibold text-dark">
                                {{ $cat->name }}
                                @if($cat->is_featured)
                                    <i class="fas fa-star text-warning ms-1" title="{{ trans('app.Featured Category') }}"></i>
                                @endif
                                @if(!$cat->is_active)
                                    <i class="fas fa-eye-slash text-muted ms-1" title="{{ trans('app.Inactive') }}"></i>
                                @endif
                            </div>
                            <small class="text-muted">{{ $cat->slug }}</small>
                        </td>
                        <td class="text-center">
                            @if($cat->parent)
                                <span class="text-muted">{{ $cat->parent->name }}</span>
                            @else
                                <span class="text-muted">—</span>
                            @endif
                        </td>
                        <td class="text-center">
                            <span class="badge bg-success">
                                <i class="fas fa-file-alt me-1"></i>{{ $cat->articles_count ?? 0 }}
                            </span>
                        </td>
                        <td class="text-center">
                            @if($cat->requires_serial)
                                <span class="badge bg-warning">
                                    <i class="fas fa-lock me-1"></i>{{ trans('app.serial_protected') }}
                                </span>
                            @else
                                <span class="badge bg-secondary">
                                    <i class="fas fa-unlock me-1"></i>{{ trans('app.public') }}
                                </span>
                            @endif
                        </td>
                        <td class="text-center">
                            <div class="fw-semibold text-dark">{{ $cat->created_at->format('M d, Y') }}</div>
                            <small class="text-muted">{{ $cat->created_at->diffForHumans() }}</small>
                        </td>
                        <td class="text-center">
                            <div class="btn-group-vertical btn-group-sm" role="group">
                                <a href="{{ route('admin.kb-categories.edit', $cat) }}"
                                   class="btn btn-outline-primary btn-sm">
                                    <i class="fas fa-edit me-1"></i>
                                    {{ trans('app.Edit') }}
                                </a>

                                <form action="{{ route('admin.kb-categories.destroy', $cat) }}" method="POST"
                                      class="d-inline" data-confirm="delete-category">
                                    @csrf
                                    @method('DELETE')
                                    <input type="hidden" name="delete_mode" value="keep_articles">
                                    <button type="submit" class="btn btn-outline-success btn-sm w-100">
                                        <i class="fas fa-archive me-1"></i>
                                        {{ trans('app.delete_keep_articles') }}
                                    </button>
                                </form>

                                <form action="{{ route('admin.kb-categories.destroy', $cat) }}" method="POST"
                                      class="d-inline" data-confirm="delete-category-articles">
                                    @csrf
                                    @method('DELETE')
                                    <input type="hidden" name="delete_mode" value="with_articles">
                                    <button type="submit" class="btn btn-outline-danger btn-sm w-100">
                                        <i class="fas fa-trash me-1"></i>
                                        {{ trans('app.delete_with_articles') }}
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        @if($categories->hasPages())
        <div class="card-footer">
            <div class="d-flex justify-content-center">
                {{ $categories->links() }}
            </div>
        </div>
        @endif
        @else
        <div class="text-center py-5">
            <div class="mb-4">
                <i class="fas fa-folder text-muted empty-state-icon"></i>
            </div>
            <h4 class="text-muted">{{ trans('app.No Categories Found') }}</h4>
            <p class="text-muted mb-4">{{ trans('app.Create your first KB category to get started') }}</p>
            <a href="{{ route('admin.kb-categories.create') }}" class="btn btn-primary btn-lg">
                <i class="fas fa-plus me-2"></i>
                {{ trans('app.Create Your First Category') }}
            </a>
        </div>
        @endif
    </div>
</div>

<!-- JavaScript is now handled by admin-categories.js -->


@endsection