@extends('layouts.admin')

@section('admin-content')
<div class="admin-page-header">
    <div class="admin-page-header-content">
        <div class="admin-page-title">
            <h1>{{ trans('app.License Management') }}</h1>
            <p class="admin-page-subtitle">{{ trans('app.Manage and monitor license usage across your platform') }}</p>
        </div>
        <div class="admin-page-actions">
            <a href="{{ route('admin.licenses.create') }}" class="admin-btn admin-btn-info admin-btn-m">
                <i class="fas fa-plus me-2"></i>
                {{ trans('app.Add New License') }}
            </a>
        </div>
    </div>
</div>


@if(session('error'))
<div class="admin-alert admin-alert-error mb-6">
    <div class="flex">
        <i class="fas fa-exclamation-triangle text-red-500 mt-0.5 mr-3"></i>
        <div>
            <h4 class="font-semibold">{{ trans('app.Error') }}</h4>
            <p class="mt-1">{{ session('error') }}</p>
        </div>
    </div>
</div>
@endif

<!-- Enhanced Filters Section -->
<div class="card mb-4">
    <div class="card-header bg-light">
        <div class="d-flex align-items-center">
            <i class="fas fa-filter me-3 text-primary"></i>
            <div>
                <h5 class="card-title mb-0">{{ trans('app.Filters') }}</h5>
                <small class="text-muted">{{ trans('app.Filter and search licenses') }}</small>
            </div>
        </div>
    </div>
    <div class="card-body">
        <div class="row g-3">
            <div class="col-md-3">
                <label for="searchLicenses" class="form-label">{{ trans('app.Search') }}</label>
                <input type="text" id="searchLicenses" class="form-control" 
                       placeholder="{{ trans('app.Search by license key, customer or product') }}">
            </div>
            <div class="col-md-3">
                <label for="status-filter" class="form-label">{{ trans('app.Status') }}</label>
                <select id="status-filter" class="form-select">
                    <option value="">{{ trans('app.All Statuses') }}</option>
                    <option value="active">{{ trans('app.Active') }}</option>
                    <option value="inactive">{{ trans('app.Inactive') }}</option>
                    <option value="expired">{{ trans('app.Expired') }}</option>
                    <option value="suspended">{{ trans('app.Suspended') }}</option>
                </select>
            </div>
            <div class="col-md-3">
                <label for="type-filter" class="form-label">{{ trans('app.Type') }}</label>
                <select id="type-filter" class="form-select">
                    <option value="">{{ trans('app.All Types') }}</option>
                    <option value="single">{{ trans('app.Single') }}</option>
                    <option value="multi">{{ trans('app.Multi') }}</option>
                    <option value="unlimited">{{ trans('app.Unlimited') }}</option>
                </select>
            </div>
            <div class="col-md-3">
                <label for="sort-filter" class="form-label">{{ trans('app.Sort By') }}</label>
                <select id="sort-filter" class="form-select">
                    <option value="created_at">{{ trans('app.Created Date') }}</option>
                    <option value="license_key">{{ trans('app.License Key') }}</option>
                    <option value="expires_at">{{ trans('app.Expiry Date') }}</option>
                    <option value="status">{{ trans('app.Status') }}</option>
                </select>
            </div>
        </div>
    </div>
</div>

<!-- Licenses Statistics -->
<div class="row g-4 mb-5">
    <div class="col-lg-3 col-md-6">
        <div class="card border-0 shadow-sm stats-card">
            <div class="card-body p-4">
                <div class="d-flex align-items-center">
                    <div class="stats-icon bg-primary bg-opacity-10 rounded-circle p-3 me-3">
                        <i class="fas fa-key text-primary fs-4"></i>
                    </div>
                    <div class="flex-grow-1">
                        <p class="text-muted small mb-1 fw-medium">{{ trans('app.Total Licenses') }}</p>
                        <h3 class="fw-bold mb-1 text-dark">{{ $licenses->total() }}</h3>
                        <small class="text-primary fw-medium">{{ trans('app.All issued licenses') }}</small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-6">
        <div class="card border-0 shadow-sm stats-card">
            <div class="card-body p-4">
                <div class="d-flex align-items-center">
                    <div class="stats-icon bg-success bg-opacity-10 rounded-circle p-3 me-3">
                        <i class="fas fa-check-circle text-success fs-4"></i>
                    </div>
                    <div class="flex-grow-1">
                        <p class="text-muted small mb-1 fw-medium">{{ trans('app.Active Licenses') }}</p>
                        <h3 class="fw-bold mb-1 text-dark">{{ $licenses->where('status', 'active')->count() }}</h3>
                        <small class="text-success fw-medium">{{ trans('app.Currently active') }}</small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-6">
        <div class="card border-0 shadow-sm stats-card">
            <div class="card-body p-4">
                <div class="d-flex align-items-center">
                    <div class="stats-icon bg-warning bg-opacity-10 rounded-circle p-3 me-3">
                        <i class="fas fa-exclamation-triangle text-warning fs-4"></i>
                    </div>
                    <div class="flex-grow-1">
                        <p class="text-muted small mb-1 fw-medium">{{ trans('app.Expiring Soon') }}</p>
                        <h3 class="fw-bold mb-1 text-dark">{{ $licenses->filter(function($license) { return $license->license_expires_at && $license->license_expires_at->diffInDays() <= 30; })->count() }}</h3>
                        <small class="text-warning fw-medium">{{ trans('app.Within 30 days') }}</small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-6">
        <div class="card border-0 shadow-sm stats-card">
            <div class="card-body p-4">
                <div class="d-flex align-items-center">
                    <div class="stats-icon bg-danger bg-opacity-10 rounded-circle p-3 me-3">
                        <i class="fas fa-times-circle text-danger fs-4"></i>
                    </div>
                    <div class="flex-grow-1">
                        <p class="text-muted small mb-1 fw-medium">{{ trans('app.Expired Licenses') }}</p>
                        <h3 class="fw-bold mb-1 text-dark">{{ $licenses->filter(function($license) { return $license->license_expires_at && $license->license_expires_at->isPast(); })->count() }}</h3>
                        <small class="text-danger fw-medium">{{ trans('app.No longer valid') }}</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Licenses Table -->
<div class="card">
    <div class="card-header bg-light">
        <div class="d-flex align-items-center justify-content-between">
            <div class="d-flex align-items-center">
                <i class="fas fa-key me-3 text-primary"></i>
                <div>
                    <h5 class="card-title mb-0">{{ trans('app.All Licenses') }}</h5>
                    <small class="text-muted">{{ trans('app.Manage and monitor license usage') }}</small>
                </div>
            </div>
            <div>
                <span class="badge bg-info fs-6">{{ $licenses->total() }} {{ trans('app.Licenses') }}</span>
            </div>
        </div>
    </div>

    <div class="card-body p-0">
        @if($licenses->count() > 0)
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th class="text-center">{{ trans('app.Avatar') }}</th>
                        <th>{{ trans('app.License') }}</th>
                        <th>{{ trans('app.Customer') }}</th>
                        <th class="text-center">{{ trans('app.Product') }}</th>
                        <th class="text-center">{{ trans('app.Status') }}</th>
                        <th class="text-center">{{ trans('app.Type') }}</th>
                        <th class="text-center">{{ trans('app.Expires') }}</th>
                        <th class="text-center">{{ trans('app.Usage') }}</th>
                        <th class="text-center">{{ trans('app.Actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($licenses as $license)
                    <tr class="license-row" data-key="{{ strtolower($license->license_key) }}" data-customer="{{ strtolower($license->user->name ?? $license->customer->name ?? '') }}" data-product="{{ strtolower($license->product->name ?? '') }}" data-status="{{ $license->status }}" data-type="{{ $license->license_type }}">
                        <td class="text-center">
                            <div class="bg-light rounded d-flex align-items-center justify-content-center license-avatar">
                                <span class="text-muted small fw-bold">{{ strtoupper(substr($license->license_key, 0, 1)) }}</span>
                            </div>
                        </td>
                        <td>
                            <div class="fw-semibold text-dark">{{ $license->license_key }}</div>
                            <small class="text-muted">ID: {{ $license->id }}</small>
                        </td>
                        <td>
                            <div class="fw-semibold text-dark">{{ $license->user->name ?? $license->customer->name ?? 'N/A' }}</div>
                            <small class="text-muted">{{ $license->user->email ?? $license->customer->email ?? '' }}</small>
                        </td>
                        <td class="text-center">
                            <div class="fw-semibold text-dark">{{ $license->product->name ?? 'N/A' }}</div>
                            @if($license->product)
                            <small class="text-muted">{{ $license->product->category->name ?? '' }}</small>
                            @endif
                        </td>
                        <td class="text-center">
                            <span class="badge {{ $license->status === 'active' ? 'bg-success' : ($license->status === 'expired' ? 'bg-danger' : ($license->status === 'inactive' ? 'bg-secondary' : 'bg-warning')) }}">
                                @if($license->status === 'active')
                                    <i class="fas fa-check-circle me-1"></i>{{ trans('app.Active') }}
                                @elseif($license->status === 'inactive')
                                    <i class="fas fa-pause-circle me-1"></i>{{ trans('app.Inactive') }}
                                @elseif($license->status === 'expired')
                                    <i class="fas fa-times-circle me-1"></i>{{ trans('app.Expired') }}
                                @else
                                    <i class="fas fa-exclamation-triangle me-1"></i>{{ ucfirst($license->status) }}
                                @endif
                            </span>
                        </td>
                        <td class="text-center">
                            <span class="badge {{ $license->license_type === 'single' ? 'bg-info' : ($license->license_type === 'multi' ? 'bg-primary' : 'bg-success') }}">
                                @if($license->license_type === 'single')
                                    <i class="fas fa-user me-1"></i>{{ trans('app.Single') }}
                                @elseif($license->license_type === 'multi')
                                    <i class="fas fa-users me-1"></i>{{ trans('app.Multi') }}
                                @else
                                    <i class="fas fa-infinity me-1"></i>{{ trans('app.Unlimited') }}
                                @endif
                            </span>
                        </td>
                        <td class="text-center">
                            @if($license->license_expires_at)
                                <div class="fw-semibold text-dark">{{ $license->license_expires_at->format('M d, Y') }}</div>
                                @if($license->license_expires_at->isPast())
                                    <small class="text-danger">
                                        <i class="fas fa-times-circle me-1"></i>{{ trans('app.Expired') }}
                                    </small>
                                @elseif($license->license_expires_at->diffInDays() <= 30)
                                    <small class="text-warning">
                                        <i class="fas fa-exclamation-triangle me-1"></i>{{ trans('app.Expiring Soon') }}
                                    </small>
                                @else
                                    <small class="text-success">
                                        <i class="fas fa-check-circle me-1"></i>{{ trans('app.Valid') }}
                                    </small>
                                @endif
                            @else
                                <span class="text-muted">—</span>
                            @endif
                        </td>
                        <td class="text-center">
                            <span class="badge bg-info">
                                <i class="fas fa-chart-line me-1"></i>{{ $license->usage_count ?? 0 }}
                            </span>
                        </td>
                        <td class="text-center">
                            <div class="btn-group-vertical btn-group-sm" role="group">
                                <a href="{{ route('admin.licenses.show', $license) }}"
                                   class="btn btn-outline-info btn-sm">
                                    <i class="fas fa-eye me-1"></i>
                                    {{ trans('app.View') }}
                                </a>

                                <a href="{{ route('admin.licenses.edit', $license) }}"
                                   class="btn btn-outline-primary btn-sm">
                                    <i class="fas fa-edit me-1"></i>
                                    {{ trans('app.Edit') }}
                                </a>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="card-footer">
            <div class="d-flex justify-content-center">
                {{ $licenses->links() }}
            </div>
        </div>
        @else
        <div class="text-center py-5">
            <div class="mb-4">
                <i class="fas fa-key text-muted empty-state-icon"></i>
            </div>
            <h4 class="text-muted">{{ trans('app.No Licenses Found') }}</h4>
            <p class="text-muted mb-4">{{ trans('app.Create your first license to get started') }}</p>
            <a href="{{ route('admin.licenses.create') }}" class="btn btn-primary btn-lg">
                <i class="fas fa-plus me-2"></i>
                {{ trans('app.Add Your First License') }}
            </a>
        </div>
        @endif
    </div>
</div>

<!-- JavaScript is now handled by admin-categories.js -->

@endsection