@extends('layouts.admin')

@section('admin-content')
<div class="container-fluid">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h1 class="h3 mb-1">{{ trans('app.product_categories') }}</h1>
                            <p class="text-muted mb-0">{{ trans('app.manage_product_categories') }}</p>
                        </div>
                        <div>
                            <a href="{{ route('admin.product-categories.create') }}" class="btn btn-primary">
                                <i class="fas fa-plus me-2"></i>
                                {{ trans('app.new_category') }}
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label for="search" class="form-label">{{ trans('app.Search') }}</label>
                            <input type="text" class="form-control" id="search" 
                                   placeholder="{{ trans('app.search_categories') }}">
                        </div>
                        <div class="col-md-3">
                            <label for="status" class="form-label">{{ trans('app.Status') }}</label>
                            <select class="form-select" id="status">
                                <option value="">{{ trans('app.All Status') }}</option>
                                <option value="active">{{ trans('app.Active') }}</option>
                                <option value="inactive">{{ trans('app.Inactive') }}</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label for="sort" class="form-label">{{ trans('app.Sort By') }}</label>
                            <select class="form-select" id="sort">
                                <option value="name">{{ trans('app.Name') }}</option>
                                <option value="products">{{ trans('app.Products Count') }}</option>
                                <option value="sort_order">{{ trans('app.sort_order') }}</option>
                                <option value="created_at">{{ trans('app.Created Date') }}</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">&nbsp;</label>
                            <div class="d-grid">
                                <button type="button" class="btn btn-outline-secondary" id="reset-filters-btn">
                                    <i class="fas fa-refresh me-1"></i>
                                    {{ trans('app.Reset') }}
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Categories Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-light">
                    <div class="d-flex align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-folder me-3 text-primary"></i>
                            <div>
                                <h5 class="card-title mb-0">{{ trans('app.all_categories') }}</h5>
                                <small class="text-muted">{{ trans('app.Manage your product categories') }}</small>
                            </div>
                        </div>
                        <div>
                            <span class="badge bg-info fs-6">{{ $categories->count() }} {{ trans('app.Categories') }}</span>
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    @if($categories->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-hover mb-0 product-categories-table">
                            <thead class="table-light">
                                <tr>
                                    <th class="text-center">{{ trans('app.Image') }}</th>
                                    <th>{{ trans('app.Name') }}</th>
                                    <th>{{ trans('app.Slug') }}</th>
                                    <th class="text-center">{{ trans('app.Products') }}</th>
                                    <th class="text-center">{{ trans('app.Status') }}</th>
                                    <th class="text-center">{{ trans('app.sort_order') }}</th>
                                    <th class="text-center">{{ trans('app.Actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($categories as $category)
                                <tr>
                                    <td class="text-center">
                                        @if($category->image)
                                        <img src="{{ asset('storage/' . $category->image) }}" alt="{{ $category->name }}"
                                            class="rounded category-image">
                                        @else
                                        <div class="bg-light rounded d-flex align-items-center justify-content-center category-avatar">
                                            <span class="text-muted small fw-bold">{{ substr($category->name, 0, 1) }}</span>
                                        </div>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="fw-semibold text-dark">{{ $category->name }}</div>
                                        <small class="text-muted">{{ $category->slug }}</small>
                                    </td>
                                    <td>
                                        <span class="text-muted">{{ $category->slug }}</span>
                                    </td>
                                    <td class="text-center">
                                        <span class="badge bg-info">{{ $category->products->count() }}</span>
                                    </td>
                                    <td class="text-center">
                                        <div class="d-flex flex-wrap gap-1 justify-content-center">
                                            <span class="badge {{ $category->is_active ? 'bg-success' : 'bg-secondary' }}">
                                                {{ $category->is_active ? trans('app.Active') : trans('app.Inactive') }}
                                            </span>
                                            @if($category->is_featured)
                                            <span class="badge bg-warning text-dark">{{ trans('app.Featured') }}</span>
                                            @endif
                                            @if($category->show_in_menu)
                                            <span class="badge bg-info">{{ trans('app.In Menu') }}</span>
                                            @endif
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <span class="text-muted">{{ $category->sort_order ?? '—' }}</span>
                                    </td>
                                    <td class="text-center">
                                        <div class="btn-group-vertical btn-group-sm" role="group">
                                            <a href="{{ route('admin.product-categories.edit', $category) }}"
                                               class="btn btn-outline-primary btn-sm">
                                                <i class="fas fa-edit me-1"></i>
                                                {{ trans('app.Edit') }}
                                            </a>

                                            <form action="{{ route('admin.product-categories.destroy', $category) }}" method="POST"
                                                  class="d-inline" data-confirm="delete-category">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-outline-danger btn-sm w-100">
                                                    <i class="fas fa-trash me-1"></i>
                                                    {{ trans('app.Delete') }}
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @else
                    <div class="text-center py-5">
                        <div class="mb-4">
                            <i class="fas fa-folder-open text-muted empty-state-icon"></i>
                        </div>
                        <h4 class="text-muted">{{ trans('app.No Categories Found') }}</h4>
                        <p class="text-muted mb-4">{{ trans('app.Create your first product category to get started') }}</p>
                        <a href="{{ route('admin.product-categories.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus me-2"></i>
                            {{ trans('app.Create Category') }}
                        </a>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Pagination -->
    @if($categories->hasPages())
    <div class="row mt-4">
        <div class="col-12">
            <div class="d-flex justify-content-center">
                {{ $categories->links() }}
            </div>
        </div>
    </div>
    @endif
</div>

<!-- JavaScript is now handled by admin-categories.js -->
@endsection