@extends('layouts.admin')

@section('title', trans('app.Products'))

@section('admin-content')
<!-- Enhanced Professional Products Page -->
<div class="admin-page">
    <div class="dashboard-content">
        <!-- Modern Page Header with Gradient -->
        <div class="admin-page-header modern-header">
            <div class="admin-page-header-content">
                <div class="admin-page-title">
                    <h1 class="gradient-text">{{ trans('app.Products') }}</h1>
                    <p class="admin-page-subtitle">
                        {{ trans('app.Manage your products catalog') }}
                    </p>
                </div>
                <div class="admin-page-actions">
                    <a href="{{ route('admin.products.create') }}" class="btn btn-primary btn-lg">
                        <i class="fas fa-plus me-2"></i>
                        <span class="d-none d-sm-inline">{{ trans('app.Add Product') }}</span>
                        <span class="d-sm-none">{{ trans('app.Add') }}</span>
                    </a>
                </div>
            </div>
        </div>

        <!-- Enhanced Filters Section -->
        <div class="card mb-4">
            <div class="card-header bg-light">
                <div class="d-flex align-items-center">
                    <i class="fas fa-filter me-3 text-primary"></i>
                    <div>
                        <h5 class="card-title mb-0">{{ trans('app.Filters') }}</h5>
                        <small class="text-muted">{{ trans('app.Filter and search products') }}</small>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.products.index') }}" method="GET">
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label for="search" class="form-label">{{ trans('app.Search') }}</label>
                            <input type="text" id="search" name="q" value="{{ request('q') }}" 
                                class="form-control" placeholder="{{ trans('app.Search products') }}">
                        </div>
                        <div class="col-md-4">
                            <label for="category_id" class="form-label">{{ trans('app.Category') }}</label>
                            <select id="category_id" name="category_id" class="form-select">
                                <option value="">{{ trans('app.All Categories') }}</option>
                                @foreach($categories as $category)
                                <option value="{{ $category->id }}" @selected(request('category_id')==$category->id)>
                                    {{ $category->name }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4 d-flex align-items-end">
                            <button type="submit" class="btn btn-outline-secondary w-100">
                                <i class="fas fa-search me-2"></i>
                                {{ trans('app.Apply') }}
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Products Table -->
        <div class="card">
            <div class="card-header bg-light">
                <div class="d-flex align-items-center justify-content-between">
                    <div class="d-flex align-items-center">
                        <i class="fas fa-cube me-3 text-primary"></i>
                        <div>
                            <h5 class="card-title mb-0">{{ trans('app.All Products') }}</h5>
                            <small class="text-muted">{{ trans('app.Manage your product catalog') }}</small>
                        </div>
                    </div>
                    <div>
                        <span class="badge bg-info fs-6">{{ $products->total() }} {{ trans('app.Products') }}</span>
                    </div>
                </div>
            </div>

            <div class="card-body p-0">
                @if($products->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="text-center">{{ trans('app.Image') }}</th>
                                <th>{{ trans('app.Name') }}</th>
                                <th>{{ trans('app.Category') }}</th>
                                <th>{{ trans('app.Language') }}</th>
                                <th class="text-end">{{ trans('app.Price') }}</th>
                                <th class="text-center">{{ trans('app.Stock') }}</th>
                                <th class="text-center">{{ trans('app.Status') }}</th>
                                <th class="text-center">{{ trans('app.Flags') }}</th>
                                <th class="text-center">{{ trans('app.Actions') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($products as $product)
                            <tr>
                                <td class="text-center">
                                    @if($product->image)
                                    <img src="{{ asset('storage/' . $product->image) }}" alt="{{ $product->name }}"
                                        class="rounded product-image">
                                    @else
                                    <div class="bg-light rounded d-flex align-items-center justify-content-center" 
                                         class="product-avatar">
                                        <span class="text-muted small fw-bold">{{ substr($product->name, 0, 1) }}</span>
                                    </div>
                                    @endif
                                </td>
                                <td>
                                    <div class="fw-semibold text-dark">{{ $product->name }}</div>
                                    <small class="text-muted">{{ $product->slug }}</small>
                                </td>
                                <td>
                                    <span class="text-muted">{{ optional($product->category)->name ?? '—' }}</span>
                                </td>
                                <td>
                                    <span class="text-muted">{{ optional($product->programmingLanguage)->name ?? '—' }}</span>
                                </td>
                                <td class="text-end">
                                    <div class="fw-semibold">{{ $product->formatted_price }}</div>
                                    @if($product->tax_rate)
                                    <small class="text-muted">{{ trans('app.Tax') }}:
                                        {{ rtrim(rtrim(number_format($product->tax_rate, 2, '.', ''), '0'), '.') }}%</small>
                                    @endif
                                </td>
                                <td class="text-center">
                                    <span class="badge {{ $product->isInStock() ? 'bg-success' : 'bg-danger' }}">
                                        {{ $product->stock_status }}
                                    </span>
                                </td>
                                <td class="text-center">
                                    <span class="badge {{ $product->is_active ? 'bg-success' : 'bg-secondary' }}">
                                        {{ $product->is_active ? trans('app.Active') : trans('app.Inactive') }}
                                    </span>
                                </td>
                                <td class="text-center">
                                    <div class="d-flex flex-wrap gap-1 justify-content-center">
                                        @if($product->is_featured)
                                        <span class="badge bg-warning text-dark">{{ trans('app.Featured') }}</span>
                                        @endif
                                        @if($product->is_popular)
                                        <span class="badge bg-info">{{ trans('app.Popular') }}</span>
                                        @endif
                                        @if($product->requires_domain)
                                        <span class="badge bg-secondary">{{ trans('app.Requires Domain') }}</span>
                                        @endif
                                        @if($product->is_downloadable)
                                        <span class="badge bg-success">{{ trans('app.Downloadable') }}</span>
                                        @endif
                                    </div>
                                </td>
                                <td class="text-center">
                                    <div class="btn-group-vertical btn-group-sm" role="group">
                                        <a href="{{ route('admin.products.edit', $product) }}" 
                                           class="btn btn-outline-primary btn-sm">
                                            <i class="fas fa-edit me-1"></i>
                                            {{ trans('app.Edit') }}
                                        </a>
                                        
                                        <a href="{{ route('admin.products.logs', $product) }}" 
                                           class="btn btn-outline-info btn-sm">
                                            <i class="fas fa-list me-1"></i>
                                            {{ trans('app.Logs') }}
                                        </a>
                                        
                                        <a href="{{ route('admin.products.files.index', $product) }}" 
                                           class="btn btn-outline-success btn-sm">
                                            <i class="fas fa-file-upload me-1"></i>
                                            {{ trans('app.Files') }}
                                        </a>

                                        @if($product->integration_file_path)
                                        <a href="{{ route('admin.products.download-integration', $product) }}" 
                                           class="btn btn-outline-success btn-sm">
                                            <i class="fas fa-download me-1"></i>
                                            {{ trans('app.Download') }}
                                        </a>
                                        @endif

                                        <form action="{{ route('admin.products.regenerate-integration', $product) }}" 
                                              method="POST" class="d-inline">
                                            @csrf
                                            <button type="submit" class="btn btn-outline-warning btn-sm w-100">
                                                <i class="fas fa-sync me-1"></i>
                                                {{ trans('app.Regenerate') }}
                                            </button>
                                        </form>

                                        <form action="{{ route('admin.products.destroy', $product) }}" method="POST" 
                                              class="d-inline" data-confirm="delete-product">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-outline-danger btn-sm w-100">
                                                <i class="fas fa-trash me-1"></i>
                                                {{ trans('app.Delete') }}
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <div class="card-footer">
                    <div class="d-flex justify-content-center">
                        {{ $products->links() }}
                    </div>
                </div>
                @else
                <div class="text-center py-5">
                    <div class="mb-4">
                        <i class="fas fa-cube text-muted empty-state-icon"></i>
                    </div>
                    <h4 class="text-muted">{{ trans('app.No Products Found') }}</h4>
                    <p class="text-muted mb-4">{{ trans('app.Get started by adding your first product') }}</p>
                    <a href="{{ route('admin.products.create') }}" class="btn btn-primary btn-lg">
                        <i class="fas fa-plus me-2"></i>
                        {{ trans('app.Add Your First Product') }}
                    </a>
                </div>
                @endif
            </div>
        </div>

        <!-- Grouped by Category -->
        <div class="mt-5">
            @foreach($categories as $category)
            @php $categoryProducts = $allProducts->where('category_id', $category->id); @endphp
            @if($categoryProducts->count())
            <div class="card mb-4">
                <div class="card-header bg-light">
                    <div class="d-flex align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-folder me-3 text-primary"></i>
                            <div>
                                <h5 class="card-title mb-0">{{ $category->name }}</h5>
                                <small class="text-muted">{{ trans('app.Products in this category') }}</small>
                            </div>
                        </div>
                        <div>
                            <span class="badge bg-info fs-6">{{ $categoryProducts->count() }} {{ trans('app.Products') }}</span>
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    @if($categoryProducts->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th class="text-center">{{ trans('app.Image') }}</th>
                                    <th>{{ trans('app.Name') }}</th>
                                    <th>{{ trans('app.Category') }}</th>
                                    <th>{{ trans('app.Language') }}</th>
                                    <th class="text-end">{{ trans('app.Price') }}</th>
                                    <th class="text-center">{{ trans('app.Stock') }}</th>
                                    <th class="text-center">{{ trans('app.Status') }}</th>
                                    <th class="text-center">{{ trans('app.Flags') }}</th>
                                    <th class="text-center">{{ trans('app.Actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($categoryProducts as $product)
                                <tr>
                                    <td class="text-center">
                                        @if($product->image)
                                        <img src="{{ asset('storage/' . $product->image) }}" alt="{{ $product->name }}"
                                            class="rounded product-image">
                                        @else
                                        <div class="bg-light rounded d-flex align-items-center justify-content-center" 
                                             class="product-avatar">
                                            <span class="text-muted small fw-bold">{{ substr($product->name, 0, 1) }}</span>
                                        </div>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="fw-semibold text-dark">{{ $product->name }}</div>
                                        <small class="text-muted">{{ $product->slug }}</small>
                                    </td>
                                    <td>
                                        <span class="text-muted">{{ optional($product->category)->name ?? '—' }}</span>
                                    </td>
                                    <td>
                                        <span class="text-muted">{{ optional($product->programmingLanguage)->name ?? '—' }}</span>
                                    </td>
                                    <td class="text-end">
                                        <div class="fw-semibold">{{ $product->formatted_price }}</div>
                                        @if($product->tax_rate)
                                        <small class="text-muted">{{ trans('app.Tax') }}:
                                            {{ rtrim(rtrim(number_format($product->tax_rate, 2, '.', ''), '0'), '.') }}%</small>
                                        @endif
                                    </td>
                                    <td class="text-center">
                                        <span class="badge {{ $product->isInStock() ? 'bg-success' : 'bg-danger' }}">
                                            {{ $product->stock_status }}
                                        </span>
                                    </td>
                                    <td class="text-center">
                                        <span class="badge {{ $product->is_active ? 'bg-success' : 'bg-secondary' }}">
                                            {{ $product->is_active ? trans('app.Active') : trans('app.Inactive') }}
                                        </span>
                                    </td>
                                    <td class="text-center">
                                        <div class="d-flex flex-wrap gap-1 justify-content-center">
                                            @if($product->is_featured)
                                            <span class="badge bg-warning text-dark">{{ trans('app.Featured') }}</span>
                                            @endif
                                            @if($product->is_popular)
                                            <span class="badge bg-info">{{ trans('app.Popular') }}</span>
                                            @endif
                                            @if($product->requires_domain)
                                            <span class="badge bg-secondary">{{ trans('app.Requires Domain') }}</span>
                                            @endif
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <div class="btn-group-vertical btn-group-sm" role="group">
                                            <a href="{{ route('admin.products.edit', $product) }}" 
                                               class="btn btn-outline-primary btn-sm">
                                                <i class="fas fa-edit me-1"></i>
                                                {{ trans('app.Edit') }}
                                            </a>
                                            
                                            <a href="{{ route('admin.products.logs', $product) }}" 
                                               class="btn btn-outline-info btn-sm">
                                                <i class="fas fa-list me-1"></i>
                                                {{ trans('app.Logs') }}
                                            </a>
                                            
                                            <a href="{{ route('admin.products.files.index', $product) }}" 
                                               class="btn btn-outline-success btn-sm">
                                                <i class="fas fa-file-upload me-1"></i>
                                                {{ trans('app.Files') }}
                                            </a>

                                            @if($product->integration_file_path)
                                            <a href="{{ route('admin.products.download-integration', $product) }}" 
                                               class="btn btn-outline-success btn-sm">
                                                <i class="fas fa-download me-1"></i>
                                                {{ trans('app.Download') }}
                                            </a>
                                            @endif

                                            <form action="{{ route('admin.products.regenerate-integration', $product) }}" 
                                                  method="POST" class="d-inline">
                                                @csrf
                                                <button type="submit" class="btn btn-outline-warning btn-sm w-100">
                                                    <i class="fas fa-sync me-1"></i>
                                                    {{ trans('app.Regenerate') }}
                                                </button>
                                            </form>

                                            <form action="{{ route('admin.products.destroy', $product) }}" method="POST" 
                                                  class="d-inline" data-confirm="delete-product">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-outline-danger btn-sm w-100">
                                                    <i class="fas fa-trash me-1"></i>
                                                    {{ trans('app.Delete') }}
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @else
                    <div class="text-center py-5">
                        <div class="mb-4">
                            <i class="fas fa-cube text-muted empty-state-icon"></i>
                        </div>
                        <h4 class="text-muted">{{ trans('app.No Products Found') }}</h4>
                        <p class="text-muted mb-4">{{ trans('app.No products in this category') }}</p>
                    </div>
                    @endif
                </div>
            </div>
            @endif
            @endforeach

            @php $uncategorized = $allProducts->whereNull('category_id'); @endphp
            @if($uncategorized->count())
            <div class="card mb-4">
                <div class="card-header bg-light">
                    <div class="d-flex align-items-center">
                        <i class="fas fa-question-circle me-3 text-warning"></i>
                        <div>
                            <h5 class="card-title mb-0">{{ trans('app.Uncategorized') }}</h5>
                            <small class="text-muted">{{ trans('app.Products without category') }}</small>
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    @if($uncategorized->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th class="text-center">{{ trans('app.Image') }}</th>
                                    <th>{{ trans('app.Name') }}</th>
                                    <th>{{ trans('app.Category') }}</th>
                                    <th>{{ trans('app.Language') }}</th>
                                    <th class="text-end">{{ trans('app.Price') }}</th>
                                    <th class="text-center">{{ trans('app.Stock') }}</th>
                                    <th class="text-center">{{ trans('app.Status') }}</th>
                                    <th class="text-center">{{ trans('app.Flags') }}</th>
                                    <th class="text-center">{{ trans('app.Actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($uncategorized as $product)
                                <tr>
                                    <td class="text-center">
                                        @if($product->image)
                                        <img src="{{ asset('storage/' . $product->image) }}" alt="{{ $product->name }}"
                                            class="rounded product-image">
                                        @else
                                        <div class="bg-light rounded d-flex align-items-center justify-content-center" 
                                             class="product-avatar">
                                            <span class="text-muted small fw-bold">{{ substr($product->name, 0, 1) }}</span>
                                        </div>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="fw-semibold text-dark">{{ $product->name }}</div>
                                        <small class="text-muted">{{ $product->slug }}</small>
                                    </td>
                                    <td>
                                        <span class="text-muted">{{ optional($product->category)->name ?? '—' }}</span>
                                    </td>
                                    <td>
                                        <span class="text-muted">{{ optional($product->programmingLanguage)->name ?? '—' }}</span>
                                    </td>
                                    <td class="text-end">
                                        <div class="fw-semibold">{{ $product->formatted_price }}</div>
                                        @if($product->tax_rate)
                                        <small class="text-muted">{{ trans('app.Tax') }}:
                                            {{ rtrim(rtrim(number_format($product->tax_rate, 2, '.', ''), '0'), '.') }}%</small>
                                        @endif
                                    </td>
                                    <td class="text-center">
                                        <span class="badge {{ $product->isInStock() ? 'bg-success' : 'bg-danger' }}">
                                            {{ $product->stock_status }}
                                        </span>
                                    </td>
                                    <td class="text-center">
                                        <span class="badge {{ $product->is_active ? 'bg-success' : 'bg-secondary' }}">
                                            {{ $product->is_active ? trans('app.Active') : trans('app.Inactive') }}
                                        </span>
                                    </td>
                                    <td class="text-center">
                                        <div class="d-flex flex-wrap gap-1 justify-content-center">
                                            @if($product->is_featured)
                                            <span class="badge bg-warning text-dark">{{ trans('app.Featured') }}</span>
                                            @endif
                                            @if($product->is_popular)
                                            <span class="badge bg-info">{{ trans('app.Popular') }}</span>
                                            @endif
                                            @if($product->requires_domain)
                                            <span class="badge bg-secondary">{{ trans('app.Requires Domain') }}</span>
                                            @endif
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <div class="btn-group-vertical btn-group-sm" role="group">
                                            <a href="{{ route('admin.products.edit', $product) }}" 
                                               class="btn btn-outline-primary btn-sm">
                                                <i class="fas fa-edit me-1"></i>
                                                {{ trans('app.Edit') }}
                                            </a>
                                            
                                            <a href="{{ route('admin.products.logs', $product) }}" 
                                               class="btn btn-outline-info btn-sm">
                                                <i class="fas fa-list me-1"></i>
                                                {{ trans('app.Logs') }}
                                            </a>
                                            
                                            <a href="{{ route('admin.products.files.index', $product) }}" 
                                               class="btn btn-outline-success btn-sm">
                                                <i class="fas fa-file-upload me-1"></i>
                                                {{ trans('app.Files') }}
                                            </a>

                                            @if($product->integration_file_path)
                                            <a href="{{ route('admin.products.download-integration', $product) }}" 
                                               class="btn btn-outline-success btn-sm">
                                                <i class="fas fa-download me-1"></i>
                                                {{ trans('app.Download') }}
                                            </a>
                                            @endif

                                            <form action="{{ route('admin.products.regenerate-integration', $product) }}" 
                                                  method="POST" class="d-inline">
                                                @csrf
                                                <button type="submit" class="btn btn-outline-warning btn-sm w-100">
                                                    <i class="fas fa-sync me-1"></i>
                                                    {{ trans('app.Regenerate') }}
                                                </button>
                                            </form>

                                            <form action="{{ route('admin.products.destroy', $product) }}" method="POST" 
                                                  class="d-inline" data-confirm="delete-product">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-outline-danger btn-sm w-100">
                                                    <i class="fas fa-trash me-1"></i>
                                                    {{ trans('app.Delete') }}
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @else
                    <div class="text-center py-5">
                        <div class="mb-4">
                            <i class="fas fa-cube text-muted empty-state-icon"></i>
                        </div>
                        <h4 class="text-muted">{{ trans('app.No Products Found') }}</h4>
                        <p class="text-muted mb-4">{{ trans('app.No uncategorized products') }}</p>
                    </div>
                    @endif
                </div>
            </div>
            @endif
        </div>
    </div>
</div>

@endsection