@extends('layouts.admin')

@section('title', trans('app.reports_and_statistics'))

@section('admin-content')
<!-- Professional Reports Page -->
<div class="admin-reports-page">
    <!-- Page Header -->
    <div class="admin-page-header modern-header">
        <div class="d-flex align-items-center justify-content-between">
            <div class="flex-grow-1">
                <h1 class="gradient-text">
                    <i class="fas fa-chart-line me-3"></i>{{ trans('app.reports_and_statistics') }}
                </h1>
                <p class="admin-page-subtitle">{{ trans('app.comprehensive_analytics_and_insights') }}</p>
            </div>
            <div class="d-flex align-items-center gap-2">
                <button type="button" class="admin-btn admin-btn-success admin-btn-m" data-action="refresh-reports">
                    <i class="fas fa-sync-alt me-2"></i>
                    {{ trans('app.refresh') }}
                </button>
                <a href="{{ route('admin.dashboard') }}" class="admin-btn admin-btn-secondary admin-btn-m">
                    <i class="fas fa-arrow-left me-2"></i>
                    {{ trans('app.back_to_dashboard') }}
                </a>
            </div>
        </div>
    </div>

    <!-- Export Actions -->
    <div class="admin-section">
        <div class="admin-section-header">
            <h2><i class="fas fa-download me-2"></i>{{ trans('app.export_reports') }}</h2>
            <div class="admin-section-actions">
                <span class="admin-badge admin-badge-info">{{ trans('app.multiple_formats') }}</span>
            </div>
        </div>
        <div class="admin-section-content">
            <div class="row g-4">
                <div class="col-lg-6">
                    <div class="admin-card export-card">
                        <div class="admin-card-content">
                            <div class="export-card-header">
                                <div class="export-icon-wrapper">
                                    <i class="fas fa-file-pdf export-icon"></i>
                                </div>
                                <div class="export-content">
                                    <h4 class="export-title">{{ trans('app.export_pdf') }}</h4>
                                    <p class="export-description">{{ trans('app.download_comprehensive_pdf_report') }}</p>
                                </div>
                            </div>
                            <div class="export-card-footer">
                                <button id="export-pdf" class="admin-btn admin-btn-primary admin-btn-m w-100" data-format="pdf">
                                    <i class="fas fa-download me-2"></i>{{ trans('app.download') }}
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="admin-card export-card">
                        <div class="admin-card-content">
                            <div class="export-card-header">
                                <div class="export-icon-wrapper">
                                    <i class="fas fa-file-csv export-icon"></i>
                                </div>
                                <div class="export-content">
                                    <h4 class="export-title">{{ trans('app.export_csv') }}</h4>
                                    <p class="export-description">{{ trans('app.download_data_for_analysis') }}</p>
                                </div>
                            </div>
                            <div class="export-card-footer">
                                <button id="export-csv" class="admin-btn admin-btn-success admin-btn-m w-100" data-format="csv">
                                    <i class="fas fa-download me-2"></i>{{ trans('app.download') }}
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Progressive Enhancement: Fallback for users without JavaScript -->
            <noscript>
                <div class="admin-alert admin-alert-warning mt-4">
                    <div class="admin-alert-content">
                        <i class="fas fa-exclamation-triangle admin-alert-icon"></i>
                        <div>
                            <h4 class="admin-alert-title">{{ trans('app.javascript_required') }}</h4>
                            <p class="admin-alert-message">
                                {{ trans('app.export_functionality_requires_javascript') }}
                                <a href="{{ route('admin.reports.export', ['format' => 'pdf']) }}" class="admin-link">
                                    {{ trans('app.download_pdf_report') }}
                                </a> |
                                <a href="{{ route('admin.reports.export', ['format' => 'csv']) }}" class="admin-link">
                                    {{ trans('app.download_csv_report') }}
                                </a>
                            </p>
                        </div>
                    </div>
                </div>
            </noscript>
        </div>
    </div>

    <!-- Filters Section -->
    <div class="admin-section">
        <div class="admin-section-header">
            <h2><i class="fas fa-filter me-2"></i>{{ trans('app.filters') }}</h2>
            <div class="admin-section-actions">
                <span class="admin-badge admin-badge-info">{{ trans('app.customize_data_range') }}</span>
            </div>
        </div>
        <div class="admin-section-content">
            <form action="{{ route('admin.reports.index') }}" method="GET" class="reports-filters-form">
                @csrf
                <div class="row g-3">
                    <div class="col-md-4">
                        <div class="admin-form-group">
                            <label class="admin-form-label" for="date_from">
                                <i class="fas fa-calendar-alt me-1"></i>{{ trans('app.date_from') }}
                            </label>
                            <input type="date" id="date_from" name="date_from" class="admin-form-input"
                                value="{{ request('date_from') }}">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="admin-form-group">
                            <label class="admin-form-label" for="date_to">
                                <i class="fas fa-calendar-alt me-1"></i>{{ trans('app.date_to') }}
                            </label>
                            <input type="date" id="date_to" name="date_to" class="admin-form-input"
                                value="{{ request('date_to') }}">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="admin-form-group">
                            <label class="admin-form-label">&nbsp;</label>
                            <button type="submit" class="admin-btn admin-btn-primary admin-btn-m w-100">
                                <i class="fas fa-search me-2"></i>{{ trans('app.apply_filters') }}
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Key Metrics -->
    <div class="admin-section">
        <div class="admin-section-header">
            <h2><i class="fas fa-chart-bar me-2"></i>{{ trans('app.key_metrics') }}</h2>
            <div class="admin-section-actions">
                <span class="admin-badge admin-badge-primary">{{ trans('app.system_overview') }}</span>
            </div>
        </div>
        <div class="admin-section-content">
            <div class="row g-4">
                <!-- Total Licenses -->
                <div class="col-lg-3 col-md-6">
                    <div class="admin-card stats-card stats-card-primary">
                        <div class="admin-card-content">
                            <div class="stats-card-header">
                                <div class="stats-icon-wrapper">
                                    <i class="fas fa-file-contract stats-icon"></i>
                                </div>
                                <div class="stats-trend">
                                    <i class="fas fa-arrow-up"></i>
                                    <span>+12%</span>
                                </div>
                            </div>
                            <div class="stats-card-body">
                                <h3 class="stats-value">{{ number_format($totalLicenses) }}</h3>
                                <p class="stats-label">{{ trans('app.Total_licenses') }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Active Licenses -->
                <div class="col-lg-3 col-md-6">
                    <div class="admin-card stats-card stats-card-success">
                        <div class="admin-card-content">
                            <div class="stats-card-header">
                                <div class="stats-icon-wrapper">
                                    <i class="fas fa-check-circle stats-icon"></i>
                                </div>
                                <div class="stats-trend">
                                    <i class="fas fa-arrow-up"></i>
                                    <span>{{ $totalLicenses > 0 ? round(($activeLicenses / $totalLicenses) * 100, 1) : 0 }}%</span>
                                </div>
                            </div>
                            <div class="stats-card-body">
                                <h3 class="stats-value">{{ number_format($activeLicenses) }}</h3>
                                <p class="stats-label">{{ trans('app.Active_licenses') }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Expired Licenses -->
                <div class="col-lg-3 col-md-6">
                    <div class="admin-card stats-card stats-card-warning">
                        <div class="admin-card-content">
                            <div class="stats-card-header">
                                <div class="stats-icon-wrapper">
                                    <i class="fas fa-exclamation-triangle stats-icon"></i>
                                </div>
                                <div class="stats-trend">
                                    <i class="fas fa-arrow-down"></i>
                                    <span>{{ $totalLicenses > 0 ? round(($expiredLicenses / $totalLicenses) * 100, 1) : 0 }}%</span>
                                </div>
                            </div>
                            <div class="stats-card-body">
                                <h3 class="stats-value">{{ number_format($expiredLicenses) }}</h3>
                                <p class="stats-label">{{ trans('app.expired_licenses') }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Blocked IPs -->
                <div class="col-lg-3 col-md-6">
                    <div class="admin-card stats-card stats-card-danger">
                        <div class="admin-card-content">
                            <div class="stats-card-header">
                                <div class="stats-icon-wrapper">
                                    <i class="fas fa-shield-alt stats-icon"></i>
                                </div>
                                <div class="stats-trend">
                                    <i class="fas fa-shield-alt"></i>
                                    <span>{{ trans('app.security') }}</span>
                                </div>
                            </div>
                            <div class="stats-card-body">
                                <h3 class="stats-value">{{ $rateLimitedIPs->count() }}</h3>
                                <p class="stats-label">{{ trans('app.blocked_ips') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Invoices & Revenue -->
    <div class="admin-section">
        <div class="admin-section-header">
            <h2><i class="fas fa-receipt me-2"></i>{{ trans('app.Invoices & Revenue') }}</h2>
            <div class="admin-section-actions">
                <span class="admin-badge admin-badge-info">{{ trans('app.financial_overview') }}</span>
            </div>
        </div>
        <div class="admin-section-content">
            <div class="row g-4 mb-4">
                <div class="col-lg-4 col-md-6">
                    <div class="admin-card revenue-card revenue-card-success">
                        <div class="admin-card-content">
                            <div class="revenue-card-header">
                                <div class="revenue-icon-wrapper">
                                    <i class="fas fa-dollar-sign revenue-icon"></i>
                                </div>
                                <div class="revenue-trend">
                                    <i class="fas fa-arrow-up"></i>
                                    <span>+8.2%</span>
                                </div>
                            </div>
                            <div class="revenue-card-body">
                                <h3 class="revenue-value">${{ number_format($invoiceStatusTotals['paid'] ?? 0, 2) }}</h3>
                                <p class="revenue-label">{{ trans('app.Total Paid Amount') }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4 col-md-6">
                    <div class="admin-card revenue-card revenue-card-warning">
                        <div class="admin-card-content">
                            <div class="revenue-card-header">
                                <div class="revenue-icon-wrapper">
                                    <i class="fas fa-clock revenue-icon"></i>
                                </div>
                                <div class="revenue-trend">
                                    <i class="fas fa-exclamation-triangle"></i>
                                    <span>{{ trans('app.due_soon') }}</span>
                                </div>
                            </div>
                            <div class="revenue-card-body">
                                <h3 class="revenue-value">${{ number_format($invoiceStatusTotals['due_soon'] ?? 0, 2) }}</h3>
                                <p class="revenue-label">{{ trans('app.Due Soon Amount') }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4 col-md-6">
                    <div class="admin-card revenue-card revenue-card-danger">
                        <div class="admin-card-content">
                            <div class="revenue-card-header">
                                <div class="revenue-icon-wrapper">
                                    <i class="fas fa-times-circle revenue-icon"></i>
                                </div>
                                <div class="revenue-trend">
                                    <i class="fas fa-arrow-down"></i>
                                    <span>-2.1%</span>
                                </div>
                            </div>
                            <div class="revenue-card-body">
                                <h3 class="revenue-value">${{ number_format($invoiceStatusTotals['cancelled'] ?? 0, 2) }}</h3>
                                <p class="revenue-label">{{ trans('app.Cancelled/Unpaid Amount') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="admin-card chart-card">
                <div class="admin-card-header">
                    <h3 class="admin-card-title">
                        <i class="fas fa-chart-line me-2"></i>{{ trans('app.monthly_revenue_chart') }}
                    </h3>
                    <div class="admin-card-actions">
                        <button class="admin-btn admin-btn-outline-primary admin-btn-sm" data-action="export-chart" data-chart="invoicesMonthly" data-format="csv">
                            <i class="fas fa-download me-1"></i>{{ trans('app.Export') }}
                        </button>
                    </div>
                </div>
                <div class="admin-card-content">
                    <div class="chart-container">
                        <canvas id="invoicesMonthlyChart" width="400" height="120" data-chart-data='@json($invoiceMonthlyAmounts ?? [])'></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Revenue Charts -->
    <div class="admin-section">
        <div class="admin-section-header">
            <h2><i class="fas fa-dollar-sign me-2"></i>{{ trans('app.revenue_analytics') }}</h2>
            <div class="admin-section-actions">
                <span class="admin-badge admin-badge-success">{{ trans('app.financial_insights') }}</span>
            </div>
        </div>
        <div class="admin-section-content">
            <div class="row g-4">
                <!-- Monthly Revenue Chart -->
                <div class="col-lg-12">
                    <div class="admin-card chart-card">
                        <div class="admin-card-header">
                            <h3 class="admin-card-title">
                                <i class="fas fa-chart-line me-2"></i>{{ trans('app.monthly_revenue_from_licenses') }}
                            </h3>
                            <div class="admin-card-actions">
                                <button class="admin-btn admin-btn-outline-success admin-btn-sm" data-action="export-chart" data-chart="monthlyRevenue" data-format="csv">
                                    <i class="fas fa-download me-1"></i>{{ trans('app.Export') }}
                                </button>
                            </div>
                        </div>
                        <div class="admin-card-content">
                            <div class="chart-container">
                                <canvas id="monthlyRevenueChart" width="400" height="120" data-chart-data='@json($monthlyRevenue ?? [])'></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Data Visualization -->
    <div class="admin-section">
        <div class="admin-section-header">
            <h2><i class="fas fa-chart-pie me-2"></i>{{ trans('app.data_visualization') }}</h2>
            <div class="admin-section-actions">
                <span class="admin-badge admin-badge-info">{{ trans('app.interactive_charts') }}</span>
            </div>
        </div>
        <div class="admin-section-content">
            <div class="row g-4">
                <!-- System Overview Chart -->
                <div class="col-lg-12 mb-4">
                    <div class="admin-card chart-card">
                        <div class="admin-card-header">
                            <h3 class="admin-card-title">
                                <i class="fas fa-cogs me-2"></i>{{ trans('app.system_overview') }}
                            </h3>
                            <div class="admin-card-actions">
                                <button class="admin-btn admin-btn-outline-secondary admin-btn-sm" data-action="export-chart" data-chart="systemOverview" data-format="csv">
                                    <i class="fas fa-download me-1"></i>{{ trans('app.Export') }}
                                </button>
                            </div>
                        </div>
                        <div class="admin-card-content">
                            <div class="chart-container">
                                <canvas id="systemOverviewChart" width="400" height="150" 
                                    data-chart-data='@json($systemOverviewData ?? [])'></canvas>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- License Type Distribution Chart -->
                <div class="col-lg-6">
                    <div class="admin-card chart-card">
                        <div class="admin-card-header">
                            <h3 class="admin-card-title">
                                <i class="fas fa-tags me-2"></i>{{ trans('app.license_type_distribution') }}
                            </h3>
                            <div class="admin-card-actions">
                                <button class="admin-btn admin-btn-outline-primary admin-btn-sm" data-action="export-chart" data-chart="licenseType" data-format="csv">
                                    <i class="fas fa-download me-1"></i>{{ trans('app.Export') }}
                                </button>
                            </div>
                        </div>
                        <div class="admin-card-content">
                            <div class="chart-container">
                                <canvas id="licenseTypeChart" width="400" height="200" 
                                    data-chart-data='@json($licenseTypeData ?? [])'></canvas>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Monthly Licenses Chart -->
                <div class="col-lg-6">
                    <div class="admin-card chart-card">
                        <div class="admin-card-header">
                            <h3 class="admin-card-title">
                                <i class="fas fa-chart-line me-2"></i>{{ trans('app.monthly_licenses') }}
                            </h3>
                            <div class="admin-card-actions">
                                <button class="admin-btn admin-btn-outline-success admin-btn-sm" data-action="export-chart" data-chart="monthlyLicenses" data-format="csv">
                                    <i class="fas fa-download me-1"></i>{{ trans('app.Export') }}
                                </button>
                            </div>
                        </div>
                        <div class="admin-card-content">
                            <div class="chart-container">
                                <canvas id="monthlyLicensesChart" width="400" height="200" 
                                    data-chart-data='@json($monthlyLicenses ?? [])'></canvas>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- User Registrations Chart -->
                <div class="col-lg-6">
                    <div class="admin-card chart-card">
                        <div class="admin-card-header">
                            <h3 class="admin-card-title">
                                <i class="fas fa-user-plus me-2"></i>{{ trans('app.user_registrations') }}
                            </h3>
                            <div class="admin-card-actions">
                                <button class="admin-btn admin-btn-outline-warning admin-btn-sm" data-action="export-chart" data-chart="userRegistrations" data-format="csv">
                                    <i class="fas fa-download me-1"></i>{{ trans('app.Export') }}
                                </button>
                            </div>
                        </div>
                        <div class="admin-card-content">
                            <div class="chart-container">
                                <canvas id="userRegistrationsChart" width="400" height="200" 
                                    data-chart-data='@json($userRegistrations ?? [])'></canvas>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Activity Timeline Chart -->
                <div class="col-lg-6">
                    <div class="admin-card chart-card">
                        <div class="admin-card-header">
                            <h3 class="admin-card-title">
                                <i class="fas fa-calendar-day me-2"></i>{{ trans('app.activity_timeline') }}
                            </h3>
                            <div class="admin-card-actions">
                                <button class="admin-btn admin-btn-outline-info admin-btn-sm" data-action="export-chart" data-chart="activityTimeline" data-format="csv">
                                    <i class="fas fa-download me-1"></i>{{ trans('app.Export') }}
                                </button>
                            </div>
                        </div>
                        <div class="admin-card-content">
                            <div class="chart-container">
                                <canvas id="activityTimelineChart" width="400" height="200" 
                                    data-chart-data='@json($activityTimeline ?? [])'></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>

    <!-- Detailed Reports -->
    <div class="admin-section">
        <div class="admin-section-header">
            <h2><i class="fas fa-table me-2"></i>{{ trans('app.detailed_reports') }}</h2>
            <div class="admin-section-actions">
                <span class="admin-badge admin-badge-info">{{ trans('app.activity_logs') }}</span>
            </div>
        </div>
        <div class="admin-section-content">
            <div class="row g-4">
                <!-- Top Products Table -->
                <div class="col-lg-6">
                    <div class="admin-card table-card">
                        <div class="admin-card-header">
                            <div class="d-flex align-items-center justify-content-between">
                                <h3 class="admin-card-title">
                                    <i class="fas fa-trophy me-2"></i>{{ trans('app.top_products') }}
                                </h3>
                                <div class="d-flex align-items-center gap-2">
                                    <span class="admin-badge admin-badge-warning">{{ $topProducts->count() }} {{ trans('app.products') }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="admin-card-content">
                            @if($topProducts->count() > 0)
                            <div class="table-responsive">
                                <table class="admin-table">
                                    <thead>
                                        <tr>
                                            <th>
                                                <i class="fas fa-box me-1"></i>{{ trans('app.Product') }}
                                            </th>
                                            <th>
                                                <i class="fas fa-hashtag me-1"></i>{{ trans('app.Licenses') }}
                                            </th>
                                            <th>
                                                <i class="fas fa-dollar-sign me-1"></i>{{ trans('app.Revenue') }}
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($topProducts->take(5) as $product)
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="product-avatar me-3">
                                                        <i class="fas fa-box"></i>
                                                    </div>
                                                    <span class="fw-medium">{{ $product->name }}</span>
                                                </div>
                                            </td>
                                            <td>
                                                <span class="admin-badge admin-badge-primary">
                                                    {{ $product->licenses_count }}
                                                </span>
                                            </td>
                                            <td class="text-success fw-bold">
                                                ${{ number_format($product->revenue ?? 0, 2) }}
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            @else
                            <div class="admin-empty-state">
                                <div class="admin-empty-state-content">
                                    <div class="empty-state-icon-wrapper">
                                        <i class="fas fa-trophy admin-empty-state-icon"></i>
                                    </div>
                                    <h4 class="admin-empty-state-title">{{ trans('app.No_products_found') }}</h4>
                                    <p class="admin-empty-state-description">{{ trans('app.no_top_products_available') }}</p>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
                        <div class="admin-card-content">
                            @if($recentActivities->count() > 0)
                            <div class="table-responsive">
                                <table class="admin-table">
                                    <thead>
                                        <tr>
                                            <th>
                                                <i class="fas fa-user me-1"></i>{{ trans('app.User') }}
                                            </th>
                                            <th>
                                                <i class="fas fa-tasks me-1"></i>{{ trans('app.Action') }}
                                            </th>
                                            <th>
                                                <i class="fas fa-calendar me-1"></i>{{ trans('app.date') }}
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($recentActivities as $activity)
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="user-avatar me-3">
                                                        <i class="fas fa-user"></i>
                                                    </div>
                                                    <span class="fw-medium">{{ $activity->license->user->name ?? 'N/A' }}</span>
                                                </div>
                                            </td>
                                            <td>
                                                @if($activity->action === 'activate')
                                                    <span class="admin-badge admin-badge-success">{{ trans('app.license_activated') }}</span>
                                                @elseif($activity->action === 'add_domain')
                                                    <span class="admin-badge admin-badge-info">{{ trans('app.domain_added') }}</span>
                                                @elseif($activity->action === 'check_status')
                                                    <span class="admin-badge admin-badge-warning">{{ trans('app.Status_checked') }}</span>
                                                @else
                                                    <span class="admin-badge admin-badge-secondary">{{ $activity->action ?? 'N/A' }}</span>
                                                @endif
                                            </td>
                                            <td class="text-muted">
                                                {{ $activity->created_at->format('M d, Y H:i') }}
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            @else
                            <div class="admin-empty-state">
                                <div class="admin-empty-state-content">
                                    <div class="empty-state-icon-wrapper">
                                        <i class="fas fa-history admin-empty-state-icon"></i>
                                    </div>
                                    <h4 class="admin-empty-state-title">{{ trans('app.No_activity_found') }}</h4>
                                    <p class="admin-empty-state-description">{{ trans('app.no_recent_activities') }}</p>
                                    <div class="admin-empty-state-actions">
                                        <button class="admin-btn admin-btn-primary admin-btn-m" data-action="refresh-activity">
                                            <i class="fas fa-sync-alt me-2"></i>{{ trans('app.Refresh') }}
                                        </button>
                                        <button class="admin-btn admin-btn-outline-secondary admin-btn-m" data-action="view-all-activities">
                                            <i class="fas fa-list me-2"></i>{{ trans('app.View All Activities') }}
                                        </button>
                                    </div>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Blocked IPs Table -->
                <div class="col-lg-6">
                    <div class="admin-card table-card">
                        <div class="admin-card-header">
                            <div class="d-flex align-items-center justify-content-between">
                                <h3 class="admin-card-title">
                                    <i class="fas fa-shield-alt me-2"></i>{{ trans('app.blocked_ips_due_to_rate_limiting') }}
                                </h3>
                                <div class="d-flex align-items-center gap-2">
                                    <span class="admin-badge admin-badge-danger">{{ $rateLimitedIPs->count() }} {{ trans('app.blocked') }}</span>
                                    @if($rateLimitedIPs->count() > 0)
                                    <button class="admin-btn admin-btn-outline-warning admin-btn-sm" data-action="clear-blocked-ips">
                                        <i class="fas fa-trash me-1"></i>{{ trans('app.Clear All') }}
                                    </button>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="admin-card-content">
                            @if($rateLimitedIPs->count() > 0)
                            <div class="table-responsive">
                                <table class="admin-table">
                                    <thead>
                                        <tr>
                                            <th>
                                                <i class="fas fa-globe me-1"></i>{{ trans('app.ip_address') }}
                                            </th>
                                            <th>
                                                <i class="fas fa-exclamation-triangle me-1"></i>{{ trans('app.attempts') }}
                                            </th>
                                            <th>
                                                <i class="fas fa-clock me-1"></i>{{ trans('app.blocked_until') }}
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($rateLimitedIPs as $blockedIP)
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="ip-avatar me-3">
                                                        <i class="fas fa-globe"></i>
                                                    </div>
                                                    <span class="font-monospace">{{ $blockedIP['ip'] }}</span>
                                                </div>
                                            </td>
                                            <td>
                                                <span class="admin-badge admin-badge-danger">
                                                    {{ $blockedIP['attempts'] }} {{ trans('app.attempts') }}
                                                </span>
                                            </td>
                                            <td class="text-muted">
                                                {{ $blockedIP['blocked_until']->format('M d, Y H:i:s') }}
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            @else
                            <div class="admin-empty-state">
                                <div class="admin-empty-state-content">
                                    <div class="empty-state-icon-wrapper">
                                        <i class="fas fa-shield-alt admin-empty-state-icon"></i>
                                    </div>
                                    <h4 class="admin-empty-state-title">{{ trans('app.No_blocked_ips') }}</h4>
                                    <p class="admin-empty-state-description">{{ trans('app.no_blocked_ips_found') }}</p>
                                    <div class="admin-empty-state-actions">
                                        <button class="admin-btn admin-btn-success admin-btn-m" data-action="refresh-reports">
                                            <i class="fas fa-sync-alt me-2"></i>{{ trans('app.Refresh') }}
                                        </button>
                                        <button class="admin-btn admin-btn-outline-info admin-btn-m" data-action="view-security-logs">
                                            <i class="fas fa-shield-alt me-2"></i>{{ trans('app.View Security Logs') }}
                                        </button>
                                    </div>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection