@extends('layouts.admin')

@section('admin-content')
<!-- Admin Settings Page -->
<div class="admin-settings-page">
<div class="admin-page-header modern-header">
    <div class="admin-page-header-content">
        <div class="admin-page-title">
            <h1 class="gradient-text">{{ trans('app.system_settings') }}</h1>
            <p class="admin-page-subtitle">{{ trans('app.configure_your_application_settings') }}</p>
        </div>
        <div class="admin-page-actions">
            <a href="{{ route('admin.envato-guide') }}" class="admin-btn admin-btn-secondary admin-btn-m">
                <i class="fas fa-book w-4 h-4 mr-2"></i>
                {{ trans('app.envato_guide') }}
            </a>
            <a href="{{ route('admin.dashboard') }}" class="admin-btn admin-btn-secondary admin-btn-m">
                <i class="fas fa-arrow-left w-4 h-4 mr-2"></i>
                {{ trans('app.back_to_dashboard') }}
            </a>
        </div>
    </div>
</div>

<!-- Alerts -->
@if($errors->any())
<div class="admin-alert admin-alert-error mb-4">
    <div class="admin-alert-content">
        <i class="fas fa-exclamation-triangle admin-alert-icon"></i>
        <div class="admin-alert-text">
            <h4>{{ trans('app.validation_errors') }}</h4>
            <ul class="mt-2">
                @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    </div>
</div>
@endif

<div class="admin-content">
    <!-- Settings Tabs Navigation -->
    <div class="admin-card mb-4">
        <div class="admin-card-header">
            <h3 class="admin-card-title">{{ trans('app.system_settings') }}</h3>
        </div>
        <div class="admin-card-content">
            <!-- Tabs Navigation -->
            <div class="admin-tabs-nav">
                <button type="button" class="admin-tab-btn admin-tab-btn-active" data-action="show-tab" data-tab="general-tab" role="tab" aria-selected="true" aria-controls="general-tab" tabindex="0">
                    <i class="fas fa-cog me-2"></i>
                    {{ trans('app.general_settings') }}
                </button>
                <button type="button" class="admin-tab-btn" data-action="show-tab" data-tab="seo-tab" role="tab" aria-selected="false" aria-controls="seo-tab" tabindex="-1">
                    <i class="fas fa-search me-2"></i>
                    {{ trans('app.SEO') }}
                </button>
                <button type="button" class="admin-tab-btn" data-action="show-tab" data-tab="envato-api-tab" role="tab" aria-selected="false" aria-controls="envato-api-tab" tabindex="-1">
                    <i class="fas fa-plug me-2"></i>
                    {{ trans('app.envato_api_settings') }}
                </button>
                <button type="button" class="admin-tab-btn" data-action="show-tab" data-tab="oauth-tab" role="tab" aria-selected="false" aria-controls="oauth-tab" tabindex="-1">
                    <i class="fas fa-sign-in-alt me-2"></i>
                    {{ trans('app.envato_oauth_settings') }}
                </button>
                <button type="button" class="admin-tab-btn" data-action="show-tab" data-tab="license-tab" role="tab" aria-selected="false" aria-controls="license-tab" tabindex="-1">
                    <i class="fas fa-shield-alt me-2"></i>
                    {{ trans('app.license_settings') }}
                </button>
                <button type="button" class="admin-tab-btn" data-action="show-tab" data-tab="preloader-tab" role="tab" aria-selected="false" aria-controls="preloader-tab" tabindex="-1">
                    <i class="fas fa-spinner me-2"></i>
                    {{ trans('app.preloader_settings') }}
                </button>
                <button type="button" class="admin-tab-btn" data-action="show-tab" data-tab="logo-tab" role="tab" aria-selected="false" aria-controls="logo-tab" tabindex="-1">
                    <i class="fas fa-image me-2"></i>
                    {{ trans('app.logo_settings') }}
                </button>
                <button type="button" class="admin-tab-btn" data-action="show-tab" data-tab="advanced-license-tab" role="tab" aria-selected="false" aria-controls="advanced-license-tab" tabindex="-1">
                    <i class="fas fa-cogs me-2"></i>
                    {{ trans('app.advanced_license_settings') }}
                </button>
                <button type="button" class="admin-tab-btn" data-action="show-tab" data-tab="security-tab" role="tab" aria-selected="false" aria-controls="security-tab" tabindex="-1">
                    <i class="fas fa-shield-alt me-2"></i>
                    {{ trans('app.security_antispam') ?? 'Security / Anti-Spam' }}
                </button>
            </div>
        </div>
    </div>

    <!-- Tab Content Container -->
    <form method="post" action="{{ route('admin.settings.update') }}" enctype="multipart/form-data" id="settings-form" class="needs-validation" novalidate>
        @csrf
        @method('PUT')

        <!-- General Settings Tab -->
        <div class="admin-tab-panel" id="general-tab" role="tabpanel" aria-labelledby="general-tab" aria-hidden="false">
            <div class="admin-card mb-4">
                <div class="admin-card-header">
                    <h3 class="admin-card-title">
                        <i class="fas fa-cog text-blue-500 me-2"></i>{{ trans('app.general_settings') }}
                    </h3>
                    <span class="admin-badge admin-badge-primary">{{ trans('app.Required') }}</span>
                </div>
                <div class="admin-card-content">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label required" for="site_name">
                                    <i class="fas fa-globe text-blue-500 me-1"></i>{{ trans('app.site_name') }}
                                </label>
                                <input type="text" id="site_name" name="site_name" class="admin-form-input"
                                    value="{{ old('site_name', $settingsArray['site_name'] ?? 'Lic') }}" required
                                    placeholder="{{ trans('app.enter_site_name') }}">
                                @error('site_name')
                                <div class="admin-form-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label" for="support_email">
                                    <i class="fas fa-envelope text-green-500 me-1"></i>{{ trans('app.support_email') }}
                                </label>
                                <input type="email" id="support_email" name="support_email" class="admin-form-input"
                                    value="{{ old('support_email', $settingsArray['support_email'] ?? '') }}"
                                    placeholder="{{ trans('app.enter_support_email') }}">
                                @error('support_email')
                                <div class="admin-form-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label" for="avg_response_time">
                                    <i class="fas fa-clock text-orange-500 me-1"></i>{{ trans('app.avg_response_time') }}
                                </label>
                                <input type="number" id="avg_response_time" name="avg_response_time" class="admin-form-input"
                                    value="{{ old('avg_response_time', $settingsArray['avg_response_time'] ?? 24) }}"
                                    min="1" max="168" placeholder="24">
                                <p class="admin-form-help">{{ trans('app.avg_response_time_help') }}</p>
                                @error('avg_response_time')
                                <div class="admin-form-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label" for="support_phone">
                                    <i class="fas fa-phone text-purple-500 me-1"></i>{{ trans('app.support_phone') }}
                                </label>
                                <input type="text" id="support_phone" name="support_phone" class="admin-form-input"
                                    value="{{ old('support_phone', $settingsArray['support_phone'] ?? '') }}"
                                    placeholder="{{ trans('app.enter_support_phone') }}">
                                @error('support_phone')
                                <div class="admin-form-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label required" for="timezone">
                                    <i class="fas fa-clock text-orange-500 me-1"></i>{{ trans('app.timezone') }}
                                </label>
                                <select id="timezone" name="timezone" class="admin-form-input" required>
                                    @foreach(\DateTimeZone::listIdentifiers() as $tz)
                                    <option value="{{ $tz }}" {{ $tz === $currentTimezone ? 'selected' : '' }}>
                                        {{ $tz }}
                                    </option>
                                    @endforeach
                                </select>
                                @error('timezone')
                                <div class="admin-form-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-tools text-gray-500 me-1"></i>{{ trans('app.maintenance_mode') }}
                                </label>
                                <div class="admin-switch">
                                    <input type="checkbox" id="maintenance_mode" name="maintenance_mode" value="1"
                                        @checked(old('maintenance_mode', $settingsArray['maintenance_mode'] ?? false)) class="admin-switch-input">
                                    <label for="maintenance_mode" class="admin-switch-label">
                                        <span class="admin-switch-inner"></span>
                                        <span class="admin-switch-switch"></span>
                                    </label>
                                </div>
                                <p class="admin-form-help">{{ trans('app.put_the_site_in_maintenance_mode') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- SEO Settings Tab -->
        <div class="admin-tab-panel admin-tab-panel-hidden" id="seo-tab" role="tabpanel" aria-labelledby="seo-tab">
            <div class="admin-card mb-4">
                <div class="admin-card-header">
                    <h3 class="admin-card-title">
                        <i class="fas fa-search text-indigo-500 me-2"></i>{{ trans('app.SEO') }}
                    </h3>
                    <span class="admin-badge admin-badge-info">{{ trans('app.Optional') }}</span>
                </div>
                <div class="admin-card-content">
                    <div class="row g-3">
                        <div class="col-12">
                            <div class="admin-form-group">
                                <label class="admin-form-label" for="seo_site_title">{{ trans('app.SEO Site Title') }}</label>
                                <input type="text" id="seo_site_title" name="seo_site_title" class="admin-form-input"
                                    value="{{ old('seo_site_title', $settingsArray['seo_site_title'] ?? '') }}"
                                    maxlength="255" placeholder="{{ trans('app.SEO Title Placeholder') }}">
                                @error('seo_site_title')
                                <div class="admin-form-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="admin-form-group">
                                <label class="admin-form-label" for="seo_site_description">{{ trans('app.SEO Site Description') }}</label>
                                <input type="text" id="seo_site_description" name="seo_site_description"
                                    class="admin-form-input"
                                    value="{{ old('seo_site_description', $settingsArray['seo_site_description'] ?? '') }}"
                                    maxlength="500" placeholder="{{ trans('app.SEO Description Placeholder') }}">
                                @error('seo_site_description')
                                <div class="admin-form-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label" for="seo_og_image">{{ trans('app.SEO OG Image') }}</label>
                                <input type="file" id="seo_og_image" name="seo_og_image" class="admin-form-input">
                                @if(!empty($settingsArray['seo_og_image']))
                                <div class="mt-3">
                                    <img src="{{ asset('storage/' . $settingsArray['seo_og_image']) }}" alt="OG Image"
                                        class="admin-image-preview">
                                </div>
                                @endif
                                @error('seo_og_image')
                                <div class="admin-form-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label" for="seo_kb_title">{{ trans('app.KB SEO Title') }}</label>
                                <input type="text" id="seo_kb_title" name="seo_kb_title" class="admin-form-input"
                                    value="{{ old('seo_kb_title', $settingsArray['seo_kb_title'] ?? '') }}"
                                    maxlength="255">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label" for="seo_kb_description">{{ trans('app.KB SEO Description') }}</label>
                                <input type="text" id="seo_kb_description" name="seo_kb_description"
                                    class="admin-form-input"
                                    value="{{ old('seo_kb_description', $settingsArray['seo_kb_description'] ?? '') }}"
                                    maxlength="500">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label" for="seo_tickets_title">{{ trans('app.Tickets SEO Title') }}</label>
                                <input type="text" id="seo_tickets_title" name="seo_tickets_title"
                                    class="admin-form-input"
                                    value="{{ old('seo_tickets_title', $settingsArray['seo_tickets_title'] ?? '') }}"
                                    maxlength="255">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label" for="seo_tickets_description">{{ trans('app.Tickets SEO Description') }}</label>
                                <input type="text" id="seo_tickets_description" name="seo_tickets_description"
                                    class="admin-form-input"
                                    value="{{ old('seo_tickets_description', $settingsArray['seo_tickets_description'] ?? '') }}"
                                    maxlength="500">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Envato API Settings Tab -->
        <div class="admin-tab-panel admin-tab-panel-hidden" id="envato-api-tab" role="tabpanel" aria-labelledby="envato-api-tab">
            <div class="admin-card mb-4">
                <div class="admin-card-header">
                    <h3 class="admin-card-title">
                        <i class="fas fa-plug text-green-500 me-2"></i>{{ trans('app.envato_api_settings') }}
                    </h3>
                    <span class="admin-badge admin-badge-info">{{ trans('app.Optional') }}</span>
                </div>
                <div class="admin-card-content">
                    <div class="admin-alert admin-alert-info mb-4">
                        <div class="admin-alert-content">
                            <i class="fas fa-info-circle admin-alert-icon"></i>
                            <div class="admin-alert-text">
                                <p>{{ trans('app.configure_envato_api_credentials_for_license_verification_and_purchase_validation') }}</p>
                            </div>
                        </div>
                    </div>

                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label" for="envato_personal_token">
                                    <i class="fas fa-key text-orange-500 me-1"></i>{{ trans('app.envato_personal_token') }}
                                </label>
                                <input type="password" id="envato_personal_token" name="envato_personal_token"
                                    class="admin-form-input"
                                    value="{{ old('envato_personal_token', $settingsArray['envato_personal_token'] ?? '') }}"
                                    placeholder="{{ trans('app.enter_envato_personal_token') }}">
                                <p class="admin-form-help">
                                    {{ trans('app.required_for_verifying_purchases_and_licenses_get_from') }}
                                    <a href="https://build.envato.com/my-apps/" target="_blank"
                                        class="text-primary">{{ trans('app.envato_my_apps') }}</a>
                                </p>
                                @error('envato_personal_token')
                                <div class="admin-form-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label" for="envato_api_key">
                                    <i class="fas fa-key text-purple-500 me-1"></i>{{ trans('app.envato_api_key') }}
                                </label>
                                <input type="password" id="envato_api_key" name="envato_api_key"
                                    class="admin-form-input"
                                    value="{{ old('envato_api_key', $settingsArray['envato_api_key'] ?? '') }}"
                                    placeholder="{{ trans('app.enter_envato_api_key') }}">
                                <p class="admin-form-help">{{ trans('app.optional_api_key_for_additional_envato_services') }}</p>
                                @error('envato_api_key')
                                <div class="admin-form-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-12">
                            <button type="button" id="test-api-btn" class="admin-btn admin-btn-info admin-btn-m"
                                data-action="test-envato-api">
                                <i class="fas fa-check-circle me-2"></i>
                                {{ trans('app.test_api_connection') }}
                            </button>
                            <noscript>
                                <div class="admin-alert admin-alert-warning mt-2">
                                    <div class="admin-alert-content">
                                        <i class="fas fa-exclamation-triangle admin-alert-icon"></i>
                                        <div class="admin-alert-text">
                                            <h4>{{ trans('app.javascript_required') }}</h4>
                                            <p>{{ trans('app.api_testing_requires_javascript') }}</p>
                                        </div>
                                    </div>
                                </div>
                            </noscript>
                            <div id="api-test-result" class="mt-3"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- OAuth Settings Tab -->
        <div class="admin-tab-panel admin-tab-panel-hidden" id="oauth-tab" role="tabpanel" aria-labelledby="oauth-tab">
            <div class="admin-card mb-4">
                <div class="admin-card-header">
                    <h3 class="admin-card-title">
                        <i class="fas fa-sign-in-alt text-indigo-500 me-2"></i>{{ trans('app.envato_oauth_settings') }}
                    </h3>
                    <span class="admin-badge admin-badge-info">{{ trans('app.Optional') }}</span>
                </div>
                <div class="admin-card-content">
                    <div class="admin-alert admin-alert-info mb-4">
                        <div class="admin-alert-content">
                            <i class="fas fa-info-circle admin-alert-icon"></i>
                            <div class="admin-alert-text">
                                <p>{{ trans('app.configure_oauth_for_user_authentication_and_account_linking') }}</p>
                            </div>
                        </div>
                    </div>

                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label" for="envato_client_id">
                                    <i class="fas fa-id-card text-blue-500 me-1"></i>{{ trans('app.envato_client_id') }}
                                </label>
                                <input type="password" id="envato_client_id" name="envato_client_id"
                                    class="admin-form-input"
                                    value="{{ old('envato_client_id', $settingsArray['envato_client_id'] ?? '') }}"
                                    placeholder="{{ trans('app.enter_envato_client_id') }}">
                                <p class="admin-form-help">{{ trans('app.oauth_client_id_from_your_envato_app') }}</p>
                                @error('envato_client_id')
                                <div class="admin-form-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label" for="envato_client_secret">
                                    <i class="fas fa-lock text-red-500 me-1"></i>{{ trans('app.envato_client_secret') }}
                                </label>
                                <input type="password" id="envato_client_secret" name="envato_client_secret"
                                    class="admin-form-input"
                                    value="{{ old('envato_client_secret', $settingsArray['envato_client_secret'] ?? '') }}"
                                    placeholder="{{ trans('app.enter_envato_client_secret') }}">
                                <p class="admin-form-help">{{ trans('app.oauth_client_secret_from_your_envato_app') }}</p>
                                @error('envato_client_secret')
                                <div class="admin-form-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label" for="envato_redirect_uri">
                                    <i class="fas fa-link text-green-500 me-1"></i>{{ trans('app.envato_redirect_uri') }}
                                </label>
                                <input type="text" id="envato_redirect_uri" name="envato_redirect_uri"
                                    class="admin-form-input"
                                    value="{{ old('envato_redirect_uri', $settingsArray['envato_redirect_uri'] ?? config('app.url') . '/auth/envato/callback') }}"
                                    placeholder="{{ trans('app.enter_envato_redirect_uri') }}">
                                <p class="admin-form-help">{{ trans('app.oauth_redirect_uri_automatically_set_to_your_apps_callback_url') }}</p>
                                @error('envato_redirect_uri')
                                <div class="admin-form-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-toggle-on text-purple-500 me-1"></i>{{ trans('app.enable_envato_oauth') }}
                                </label>
                                <div class="admin-switch">
                                    <input type="checkbox" id="envato_oauth_enabled" name="envato_oauth_enabled"
                                        value="1" @checked(old('envato_oauth_enabled', $settingsArray['envato_oauth_enabled'] ?? false)) class="admin-switch-input">
                                    <label for="envato_oauth_enabled" class="admin-switch-label">
                                        <span class="admin-switch-inner"></span>
                                        <span class="admin-switch-switch"></span>
                                    </label>
                                </div>
                                <p class="admin-form-help">{{ trans('app.allow_users_to_login_and_link_their_envato_accounts') }}</p>
                            </div>
                        </div>

                        <div class="col-12">
                            <a href="{{ route('admin.envato-guide') }}" class="admin-btn admin-btn-secondary admin-btn-m">
                                <i class="fas fa-book me-2"></i>
                                {{ trans('app.how_to_create_envato_app') }}
                            </a>
                            <p class="admin-form-help">{{ trans('app.learn_how_to_create_and_configure_your_envato_oauth_application') }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Security / Anti-Spam Settings Tab -->
        <div class="admin-tab-panel admin-tab-panel-hidden" id="security-tab" role="tabpanel" aria-labelledby="security-tab">
            <div class="admin-card mb-4">
                <div class="admin-card-header">
                    <h3 class="admin-card-title">
                        <i class="fas fa-shield-alt text-red-500 me-2"></i>{{ trans('app.security_antispam') ?? 'Security / Anti-Spam' }}
                    </h3>
                    <span class="admin-badge admin-badge-info">{{ trans('app.Optional') }}</span>
                </div>
                <div class="admin-card-content">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label" for="enable_captcha">{{ trans('app.enable_captcha') ?? 'Enable Google reCAPTCHA' }}</label>
                                <div class="admin-switch">
                                    <input type="checkbox" id="enable_captcha" name="enable_captcha" value="1" @checked(old('enable_captcha', $settingsArray['enable_captcha'] ?? false)) class="admin-switch-input">
                                    <label for="enable_captcha" class="admin-switch-label">
                                        <span class="admin-switch-inner"></span>
                                        <span class="admin-switch-switch"></span>
                                    </label>
                                </div>
                                @error('enable_captcha')
                                <div class="admin-form-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label" for="captcha_site_key">{{ trans('app.captcha_site_key') ?? 'Captcha Site Key' }}</label>
                                <input type="text" id="captcha_site_key" name="captcha_site_key" class="admin-form-input" value="{{ old('captcha_site_key', $settingsArray['captcha_site_key'] ?? '') }}" placeholder="">
                                @error('captcha_site_key')
                                <div class="admin-form-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label" for="captcha_secret_key">{{ trans('app.captcha_secret_key') ?? 'Captcha Secret Key' }}</label>
                                <input type="password" id="captcha_secret_key" name="captcha_secret_key" class="admin-form-input" value="{{ old('captcha_secret_key', $settingsArray['captcha_secret_key'] ?? '') }}" placeholder="">
                                @error('captcha_secret_key')
                                <div class="admin-form-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label" for="enable_human_question">{{ trans('app.enable_human_question') ?? 'Enable Human Question' }}</label>
                                <div class="admin-switch">
                                    <input type="checkbox" id="enable_human_question" name="enable_human_question" value="1" @checked(old('enable_human_question', $settingsArray['enable_human_question'] ?? true)) class="admin-switch-input">
                                    <label for="enable_human_question" class="admin-switch-label">
                                        <span class="admin-switch-inner"></span>
                                        <span class="admin-switch-switch"></span>
                                    </label>
                                </div>
                                @error('enable_human_question')
                                <div class="admin-form-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="admin-form-group">
                                <label class="admin-form-label" for="human_questions_list">{{ trans('app.human_questions') ?? 'Human Questions' }}</label>
                                <div id="human-questions-list">
                                    @php
                                        $existingQuestions = [];
                                        if (!empty($settingsArray['human_questions'])) {
                                            try {
                                                $existingQuestions = json_decode($settingsArray['human_questions'], true) ?: [];
                                            } catch (\Exception $e) {
                                                $existingQuestions = [];
                                            }
                                        }
                                        // If old input exists (after validation error) prefer it
                                        if (old('human_questions') && is_array(old('human_questions'))) {
                                            $existingQuestions = old('human_questions');
                                        }
                                    @endphp

                                    @if(!empty($existingQuestions))
                                        @foreach($existingQuestions as $i => $q)
                                        <div class="human-question-row mb-3" data-index="{{ $i }}">
                                            <div class="row g-2 align-items-center">
                                                <div class="col-md-7">
                                                    <input type="text" name="human_questions[{{ $i }}][question]" class="admin-form-input" value="{{ $q['question'] ?? '' }}" placeholder="{{ trans('app.Question') }}">
                                                </div>
                                                <div class="col-md-4">
                                                    <input type="text" name="human_questions[{{ $i }}][answer]" class="admin-form-input" value="{{ $q['answer'] ?? '' }}" placeholder="{{ trans('app.Answer') }}">
                                                </div>
                                                <div class="col-md-1">
                                                    <button type="button" class="admin-btn admin-btn-danger btn-remove-question">&times;</button>
                                                </div>
                                            </div>
                                        </div>
                                        @endforeach
                                    @else
                                        <div class="human-question-row mb-3" data-index="0">
                                            <div class="row g-2 align-items-center">
                                                <div class="col-md-7">
                                                    <input type="text" name="human_questions[0][question]" class="admin-form-input" value="What is 2 + 3?" placeholder="{{ trans('app.Question') }}">
                                                </div>
                                                <div class="col-md-4">
                                                    <input type="text" name="human_questions[0][answer]" class="admin-form-input" value="5" placeholder="{{ trans('app.Answer') }}">
                                                </div>
                                                <div class="col-md-1">
                                                    <button type="button" class="admin-btn admin-btn-danger btn-remove-question">&times;</button>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                </div>

                                <div class="mt-3">
                                    <button type="button" id="btn-add-question" class="admin-btn admin-btn-primary">{{ trans('app.add_question') ?? 'Add question' }}</button>
                                </div>

                                <p class="admin-form-help">{{ trans('app.human_questions_help') ?? 'Add one or more simple question/answer pairs to reduce automated signups.' }}</p>
                                @error('human_questions')
                                <div class="admin-form-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- License Settings Tab -->
        <div class="admin-tab-panel admin-tab-panel-hidden" id="license-tab" role="tabpanel" aria-labelledby="license-tab">
            <div class="admin-card mb-4">
                <div class="admin-card-header">
                    <h3 class="admin-card-title">
                        <i class="fas fa-shield-alt text-red-500 me-2"></i>{{ trans('app.license_settings') }}
                    </h3>
                    <span class="admin-badge admin-badge-primary">{{ trans('app.Required') }}</span>
                </div>
                <div class="admin-card-content">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label required" for="license_max_attempts">
                                    <i class="fas fa-repeat text-orange-500 me-1"></i>{{ trans('app.max_verification_attempts') }}
                                </label>
                                <input type="number" id="license_max_attempts" name="license_max_attempts"
                                    class="admin-form-input"
                                    value="{{ old('license_max_attempts', $settingsArray['license_max_attempts'] ?? 5) }}"
                                    min="1" required placeholder="5">
                                <p class="admin-form-help">{{ trans('app.maximum_number_of_verification_attempts_allowed_per_license') }}</p>
                                @error('license_max_attempts')
                                <div class="admin-form-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label required" for="license_lockout_minutes">
                                    <i class="fas fa-clock text-blue-500 me-1"></i>{{ trans('app.lockout_duration_minutes') }}
                                </label>
                                <input type="number" id="license_lockout_minutes" name="license_lockout_minutes"
                                    class="admin-form-input"
                                    value="{{ old('license_lockout_minutes', $settingsArray['license_lockout_minutes'] ?? 15) }}"
                                    min="1" required placeholder="15">
                                <p class="admin-form-help">{{ trans('app.how_long_to_lock_out_verification_attempts_after_max_attempts_reached') }}</p>
                                @error('license_lockout_minutes')
                                <div class="admin-form-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="admin-form-group">
                                <label class="admin-form-label required" for="license_api_token">
                                    <i class="fas fa-key text-purple-500 me-1"></i>{{ trans('app.license_api_token') }}
                                </label>
                                <div class="input-group">
                                    <input type="text" id="license_api_token" name="license_api_token"
                                        class="admin-form-input"
                                        value="{{ old('license_api_token', $settingsArray['license_api_token'] ?? '') }}"
                                        required placeholder="{{ trans('app.enter_license_api_token') }}"
                                        style="cursor: text;">
                                    <button type="button" class="admin-btn admin-btn-secondary" id="generate-api-token">
                                        <i class="fas fa-sync-alt me-1"></i>{{ trans('app.generate_new_token') }}
                                    </button>
                                </div>
                                <p class="admin-form-help">{{ trans('app.license_api_token_description') }}</p>
                                @error('license_api_token')
                                <div class="admin-form-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Preloader Settings Tab -->
        <div class="admin-tab-panel admin-tab-panel-hidden" id="preloader-tab" role="tabpanel" aria-labelledby="preloader-tab">
            <div class="admin-card mb-4">
                <div class="admin-card-header">
                    <h3 class="admin-card-title">
                        <i class="fas fa-spinner text-purple-500 me-2"></i>{{ trans('app.preloader_settings') }}
                    </h3>
                    <span class="admin-badge admin-badge-info">{{ trans('app.Optional') }}</span>
                </div>
                <div class="admin-card-content">
                    <div class="row g-3">
                        <!-- Preloader Enable/Disable -->
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-toggle-on me-2"></i>
                                    {{ trans('app.enable_preloader') }}
                                </label>
                                <div class="admin-switch">
                                    <input type="checkbox" name="preloader_enabled" value="1"
                                           {{ $settings->preloader_enabled ? 'checked' : '' }}
                                           class="admin-switch-input" id="preloader_enabled">
                                    <label for="preloader_enabled" class="admin-switch-label">
                                        <span class="admin-switch-inner"></span>
                                        <span class="admin-switch-switch"></span>
                                    </label>
                                </div>
                                <p class="admin-form-help">{{ trans('app.show_preloader_on_page_load') }}</p>
                            </div>
                        </div>

                        <!-- Preloader Type -->
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-palette me-2"></i>
                                    {{ trans('app.preloader_type') }}
                                </label>
                                <select name="preloader_type" class="admin-form-input">
                                    <option value="spinner" {{ $settings->preloader_type === 'spinner' ? 'selected' : '' }}>
                                        {{ trans('app.spinner') }}
                                    </option>
                                    <option value="dots" {{ $settings->preloader_type === 'dots' ? 'selected' : '' }}>
                                        {{ trans('app.dots') }}
                                    </option>
                                    <option value="bars" {{ $settings->preloader_type === 'bars' ? 'selected' : '' }}>
                                        {{ trans('app.bars') }}
                                    </option>
                                    <option value="pulse" {{ $settings->preloader_type === 'pulse' ? 'selected' : '' }}>
                                        {{ trans('app.pulse') }}
                                    </option>
                                    <option value="progress" {{ $settings->preloader_type === 'progress' ? 'selected' : '' }}>
                                        {{ trans('app.progress_bar') }}
                                    </option>
                                    <option value="custom" {{ $settings->preloader_type === 'custom' ? 'selected' : '' }}>
                                        {{ trans('app.custom') }}
                                    </option>
                                </select>
                                <p class="admin-form-help">{{ trans('app.choose_preloader_animation_style') }}</p>
                            </div>
                        </div>

                        <!-- Preloader Color -->
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-fill-drip me-2"></i>
                                    {{ trans('app.preloader_color') }}
                                </label>
                                <div class="d-flex align-items-center gap-3">
                                    <input type="color" name="preloader_color"
                                           value="{{ $settings->preloader_color ?? '#3b82f6' }}"
                                           class="admin-form-color">
                                    <input type="text" name="preloader_color_text"
                                           value="{{ $settings->preloader_color ?? '#3b82f6' }}"
                                           class="admin-form-input" placeholder="#3b82f6">
                                </div>
                                <p class="admin-form-help">{{ trans('app.primary_color_for_preloader_animation') }}</p>
                            </div>
                        </div>

                        <!-- Background Color -->
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-paint-brush me-2"></i>
                                    {{ trans('app.background_color') }}
                                </label>
                                <div class="d-flex align-items-center gap-3">
                                    <input type="color" name="preloader_background_color"
                                           value="{{ $settings->preloader_background_color ?? '#ffffff' }}"
                                           class="admin-form-color">
                                    <input type="text" name="preloader_background_color_text"
                                           value="{{ $settings->preloader_background_color ?? '#ffffff' }}"
                                           class="admin-form-input" placeholder="#ffffff">
                                </div>
                                <p class="admin-form-help">{{ trans('app.background_color_for_preloader') }}</p>
                            </div>
                        </div>

                        <!-- Duration -->
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-clock me-2"></i>
                                    {{ trans('app.duration_milliseconds') }}
                                </label>
                                <input type="number" name="preloader_duration"
                                       value="{{ $settings->preloader_duration ?? 2000 }}"
                                       class="admin-form-input" min="500" max="10000" step="100">
                                <p class="admin-form-help">{{ trans('app.how_long_to_show_preloader') }}</p>
                            </div>
                        </div>

                        <!-- Custom CSS -->
                        <div class="col-12">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-code me-2"></i>
                                    {{ trans('app.custom_css') }}
                                </label>
                                <textarea name="preloader_custom_css" rows="6"
                                          class="admin-form-textarea"
                                          placeholder="{{ trans('app.enter_custom_css_for_preloader') }}">{{ $settings->preloader_custom_css ?? '' }}</textarea>
                                <p class="admin-form-help">{{ trans('app.add_custom_styles_for_preloader') }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Preview Section -->
                    <div class="admin-card mt-4">
                        <div class="admin-card-header">
                            <h4 class="admin-card-title">{{ trans('app.preview') }}</h4>
                        </div>
                        <div class="admin-card-content">
                            <div class="text-center">
                                <button type="button" id="preview-preloader" class="admin-btn admin-btn-secondary">
                                    <i class="fas fa-eye me-2"></i>
                                    {{ trans('app.preview_preloader') }}
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Logo Settings Tab -->
        <div class="admin-tab-panel admin-tab-panel-hidden" id="logo-tab" role="tabpanel" aria-labelledby="logo-tab">
            <div class="admin-card mb-4">
                <div class="admin-card-header">
                    <h3 class="admin-card-title">
                        <i class="fas fa-image text-green-500 me-2"></i>{{ trans('app.logo_settings') }}
                    </h3>
                    <span class="admin-badge admin-badge-info">{{ trans('app.Optional') }}</span>
                </div>
                <div class="admin-card-content">
                    <div class="row g-3">
                        <!-- Site Logo -->
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-image me-2"></i>
                                    {{ trans('app.site_logo') }}
                                </label>
                                <div class="admin-file-upload">
                                    <input type="file" name="site_logo" accept="image/*" class="admin-file-input" id="site_logo">
                                    <label for="site_logo" class="admin-file-label">
                                        <i class="fas fa-upload me-2"></i>
                                        {{ trans('app.choose_logo_file') }}
                                    </label>
                                </div>
                                @if($settings->site_logo)
                                    <div class="mt-3">
                                        <img src="{{ asset('storage/' . $settings->site_logo) }}"
                                             alt="{{ trans('app.current_logo') }}"
                                             class="admin-image-preview">
                                        <p class="text-muted mt-1">{{ trans('app.current_logo') }}</p>
                                    </div>
                                @endif
                                <p class="admin-form-help">{{ trans('app.upload_site_logo_recommended_size') }}</p>
                            </div>
                        </div>

                        <!-- Dark Mode Logo -->
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-moon me-2"></i>
                                    {{ trans('app.dark_mode_logo') }}
                                </label>
                                <div class="admin-file-upload">
                                    <input type="file" name="site_logo_dark" accept="image/*" class="admin-file-input" id="site_logo_dark">
                                    <label for="site_logo_dark" class="admin-file-label">
                                        <i class="fas fa-upload me-2"></i>
                                        {{ trans('app.choose_dark_logo_file') }}
                                    </label>
                                </div>
                                @if($settings->site_logo_dark)
                                    <div class="mt-3">
                                        <img src="{{ asset('storage/' . $settings->site_logo_dark) }}"
                                             alt="{{ trans('app.current_dark_logo') }}"
                                             class="admin-image-preview">
                                        <p class="text-muted mt-1">{{ trans('app.current_dark_logo') }}</p>
                                    </div>
                                @endif
                                <p class="admin-form-help">{{ trans('app.upload_dark_mode_logo_optional') }}</p>
                            </div>
                        </div>

                        <!-- Logo Dimensions -->
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-expand-arrows-alt me-2"></i>
                                    {{ trans('app.logo_width') }}
                                </label>
                                <input type="number" name="logo_width"
                                       value="{{ $settings->logo_width ?? 150 }}"
                                       class="admin-form-input" min="50" max="500">
                                <p class="admin-form-help">{{ trans('app.logo_width_in_pixels') }}</p>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-expand-arrows-alt me-2"></i>
                                    {{ trans('app.logo_height') }}
                                </label>
                                <input type="number" name="logo_height"
                                       value="{{ $settings->logo_height ?? 50 }}"
                                       class="admin-form-input" min="20" max="200">
                                <p class="admin-form-help">{{ trans('app.logo_height_in_pixels') }}</p>
                            </div>
                        </div>

                        <!-- Logo Text Settings -->
                        <div class="col-12">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-font me-2"></i>
                                    {{ trans('app.show_logo_text') }}
                                </label>
                                <div class="admin-switch">
                                    <input type="checkbox" name="logo_show_text" value="1"
                                           {{ $settings->logo_show_text ? 'checked' : '' }}
                                           class="admin-switch-input" id="logo_show_text">
                                    <label for="logo_show_text" class="admin-switch-label">
                                        <span class="admin-switch-inner"></span>
                                        <span class="admin-switch-switch"></span>
                                    </label>
                                </div>
                                <p class="admin-form-help">{{ trans('app.show_text_next_to_logo') }}</p>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-text-width me-2"></i>
                                    {{ trans('app.logo_text') }}
                                </label>
                                <input type="text" name="logo_text"
                                       value="{{ $settings->logo_text ?? config('app.name') }}"
                                       class="admin-form-input" placeholder="{{ config('app.name') }}">
                                <p class="admin-form-help">{{ trans('app.text_to_display_with_logo') }}</p>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-fill-drip me-2"></i>
                                    {{ trans('app.logo_text_color') }}
                                </label>
                                <div class="d-flex align-items-center gap-3">
                                    <input type="color" name="logo_text_color"
                                           value="{{ $settings->logo_text_color ?? '#1f2937' }}"
                                           class="admin-form-color">
                                    <input type="text" name="logo_text_color_text"
                                           value="{{ $settings->logo_text_color ?? '#1f2937' }}"
                                           class="admin-form-input" placeholder="#1f2937">
                                </div>
                                <p class="admin-form-help">{{ trans('app.color_for_logo_text') }}</p>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-text-height me-2"></i>
                                    {{ trans('app.logo_text_font_size') }}
                                </label>
                                <input type="text" name="logo_text_font_size"
                                       value="{{ $settings->logo_text_font_size ?? '24px' }}"
                                       class="admin-form-input" placeholder="24px">
                                <p class="admin-form-help">{{ trans('app.font_size_for_logo_text') }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Logo Preview -->
                    <div class="admin-card mt-4">
                        <div class="admin-card-header">
                            <h4 class="admin-card-title">{{ trans('app.logo_preview') }}</h4>
                        </div>
                        <div class="admin-card-content">
                            <div class="text-center p-4 bg-light rounded">
                                <div id="logo-preview" class="admin-logo-preview" 
                                     data-logo-width="{{ $settings->logo_width ?? 150 }}"
                                     data-logo-height="{{ $settings->logo_height ?? 50 }}"
                                     data-logo-text-color="{{ $settings->logo_text_color ?? '#1f2937' }}"
                                     data-logo-text-font-size="{{ $settings->logo_text_font_size ?? '24px' }}">
                                    @if($settings->site_logo)
                                        <img src="{{ asset('storage/' . $settings->site_logo) }}"
                                             alt="{{ $settings->logo_text ?? config('app.name') }}"
                                             class="admin-logo-preview-image">
                                    @endif
                                    @if($settings->logo_show_text)
                                        <span class="admin-logo-preview-text">
                                            {{ $settings->logo_text ?? config('app.name') }}
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Advanced License Settings Tab -->
        <div class="admin-tab-panel" id="advanced-license-tab" role="tabpanel" aria-labelledby="advanced-license-tab" aria-hidden="true">
            <!-- License Verification Settings -->
            <div class="admin-card mb-4">
                <div class="admin-card-header">
                    <h3 class="admin-card-title">
                        <i class="fas fa-shield-alt text-green-500 me-2"></i>{{ trans('app.license_verification_settings') }}
                    </h3>
                    <span class="admin-badge admin-badge-success">{{ trans('app.Advanced') }}</span>
                </div>
                <div class="admin-card-content">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-check-circle text-green-500 me-1"></i>
                                    {{ trans('app.verify_with_envato') }}
                                </label>
                                <div class="admin-form-switch">
                                    <input type="checkbox" class="admin-form-switch-input" id="license_verify_envato" name="license_verify_envato" value="1" {{ old('license_verify_envato', $settings->license_verify_envato ?? true) ? 'checked' : '' }}>
                                    <label class="admin-form-switch-label" for="license_verify_envato"></label>
                                </div>
                                <div class="admin-form-help">{{ trans('app.verify_with_envato_help') }}</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-database text-blue-500 me-1"></i>
                                    {{ trans('app.fallback_to_internal') }}
                                </label>
                                <div class="admin-form-switch">
                                    <input type="checkbox" class="admin-form-switch-input" id="license_fallback_internal" name="license_fallback_internal" value="1" {{ old('license_fallback_internal', $settings->license_fallback_internal ?? true) ? 'checked' : '' }}>
                                    <label class="admin-form-switch-label" for="license_fallback_internal"></label>
                                </div>
                                <div class="admin-form-help">{{ trans('app.fallback_to_internal_help') }}</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-clock text-orange-500 me-1"></i>
                                    {{ trans('app.cache_duration_minutes') }}
                                </label>
                                <input type="number" class="admin-form-input" id="license_cache_duration" name="license_cache_duration" value="{{ old('license_cache_duration', $settings->license_cache_duration ?? 60) }}" min="1" max="1440">
                                <div class="admin-form-help">{{ trans('app.cache_duration_minutes_help') }}</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-calendar text-purple-500 me-1"></i>
                                    {{ trans('app.grace_period_days') }}
                                </label>
                                <input type="number" class="admin-form-input" id="license_grace_period" name="license_grace_period" value="{{ old('license_grace_period', $settings->license_grace_period ?? 7) }}" min="0" max="30">
                                <div class="admin-form-help">{{ trans('app.grace_period_days_help') }}</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Domain Management Settings -->
            <div class="admin-card mb-4">
                <div class="admin-card-header">
                    <h3 class="admin-card-title">
                        <i class="fas fa-globe text-blue-500 me-2"></i>{{ trans('app.domain_management_settings') }}
                    </h3>
                    <span class="admin-badge admin-badge-info">{{ trans('app.Domain') }}</span>
                </div>
                <div class="admin-card-content">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-home text-green-500 me-1"></i>
                                    {{ trans('app.allow_localhost') }}
                                </label>
                                <div class="admin-form-switch">
                                    <input type="checkbox" class="admin-form-switch-input" id="license_allow_localhost" name="license_allow_localhost" value="1" {{ old('license_allow_localhost', $settings->license_allow_localhost ?? true) ? 'checked' : '' }}>
                                    <label class="admin-form-switch-label" for="license_allow_localhost"></label>
                                </div>
                                <div class="admin-form-help">{{ trans('app.allow_localhost_help') }}</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-asterisk text-orange-500 me-1"></i>
                                    {{ trans('app.allow_wildcards') }}
                                </label>
                                <div class="admin-form-switch">
                                    <input type="checkbox" class="admin-form-switch-input" id="license_allow_wildcards" name="license_allow_wildcards" value="1" {{ old('license_allow_wildcards', $settings->license_allow_wildcards ?? true) ? 'checked' : '' }}>
                                    <label class="admin-form-switch-label" for="license_allow_wildcards"></label>
                                </div>
                                <div class="admin-form-help">{{ trans('app.allow_wildcards_help') }}</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-plus-circle text-green-500 me-1"></i>
                                    {{ trans('app.auto_register_domains') }}
                                </label>
                                <div class="admin-form-switch">
                                    <input type="checkbox" class="admin-form-switch-input" id="license_auto_register_domains" name="license_auto_register_domains" value="1" {{ old('license_auto_register_domains', $settings->license_auto_register_domains ?? false) ? 'checked' : '' }}>
                                    <label class="admin-form-switch-label" for="license_auto_register_domains"></label>
                                </div>
                                <div class="admin-form-help">{{ trans('app.auto_register_domains_help') }}</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-hashtag text-purple-500 me-1"></i>
                                    {{ trans('app.max_domains_per_license') }}
                                </label>
                                <input type="number" class="admin-form-input" id="license_max_domains" name="license_max_domains" value="{{ old('license_max_domains', $settings->license_max_domains ?? 5) }}" min="1" max="100">
                                <div class="admin-form-help">{{ trans('app.max_domains_per_license_help') }}</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-clock text-red-500 me-1"></i>
                                    {{ trans('app.domain_change_cooldown_hours') }}
                                </label>
                                <input type="number" class="admin-form-input" id="license_domain_cooldown" name="license_domain_cooldown" value="{{ old('license_domain_cooldown', $settings->license_domain_cooldown ?? 24) }}" min="1" max="168">
                                <div class="admin-form-help">{{ trans('app.domain_change_cooldown_hours_help') }}</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Security Settings -->
            <div class="admin-card mb-4">
                <div class="admin-card-header">
                    <h3 class="admin-card-title">
                        <i class="fas fa-lock text-red-500 me-2"></i>{{ trans('app.security_settings') }}
                    </h3>
                    <span class="admin-badge admin-badge-danger">{{ trans('app.Security') }}</span>
                </div>
                <div class="admin-card-content">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-shield-alt text-green-500 me-1"></i>
                                    {{ trans('app.encrypt_license_data') }}
                                </label>
                                <div class="admin-form-switch">
                                    <input type="checkbox" class="admin-form-switch-input" id="license_encrypt_data" name="license_encrypt_data" value="1" {{ old('license_encrypt_data', $settings->license_encrypt_data ?? true) ? 'checked' : '' }}>
                                    <label class="admin-form-switch-label" for="license_encrypt_data"></label>
                                </div>
                                <div class="admin-form-help">{{ trans('app.encrypt_license_data_help') }}</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-key text-blue-500 me-1"></i>
                                    {{ trans('app.use_secure_tokens') }}
                                </label>
                                <div class="admin-form-switch">
                                    <input type="checkbox" class="admin-form-switch-input" id="license_secure_tokens" name="license_secure_tokens" value="1" {{ old('license_secure_tokens', $settings->license_secure_tokens ?? true) ? 'checked' : '' }}>
                                    <label class="admin-form-switch-label" for="license_secure_tokens"></label>
                                </div>
                                <div class="admin-form-help">{{ trans('app.use_secure_tokens_help') }}</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-ban text-red-500 me-1"></i>
                                    {{ trans('app.prevent_license_sharing') }}
                                </label>
                                <div class="admin-form-switch">
                                    <input type="checkbox" class="admin-form-switch-input" id="license_prevent_sharing" name="license_prevent_sharing" value="1" {{ old('license_prevent_sharing', $settings->license_prevent_sharing ?? true) ? 'checked' : '' }}>
                                    <label class="admin-form-switch-label" for="license_prevent_sharing"></label>
                                </div>
                                <div class="admin-form-help">{{ trans('app.prevent_license_sharing_help') }}</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-exclamation-triangle text-orange-500 me-1"></i>
                                    {{ trans('app.detect_suspicious_activity') }}
                                </label>
                                <div class="admin-form-switch">
                                    <input type="checkbox" class="admin-form-switch-input" id="license_detect_suspicious" name="license_detect_suspicious" value="1" {{ old('license_detect_suspicious', $settings->license_detect_suspicious ?? true) ? 'checked' : '' }}>
                                    <label class="admin-form-switch-label" for="license_detect_suspicious"></label>
                                </div>
                                <div class="admin-form-help">{{ trans('app.detect_suspicious_activity_help') }}</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Notification Settings -->
            <div class="admin-card mb-4">
                <div class="admin-card-header">
                    <h3 class="admin-card-title">
                        <i class="fas fa-bell text-yellow-500 me-2"></i>{{ trans('app.notification_settings') }}
                    </h3>
                    <span class="admin-badge admin-badge-warning">{{ trans('app.Notifications') }}</span>
                </div>
                <div class="admin-card-content">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-envelope text-blue-500 me-1"></i>
                                    {{ trans('app.notification_email') }}
                                </label>
                                <input type="email" class="admin-form-input" id="license_notification_email" name="license_notification_email" value="{{ old('license_notification_email', $settings->license_notification_email ?? '') }}" placeholder="admin@example.com">
                                <div class="admin-form-help">{{ trans('app.notification_email_help') }}</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-calendar-times text-red-500 me-1"></i>
                                    {{ trans('app.notify_on_expiration') }}
                                </label>
                                <div class="admin-form-switch">
                                    <input type="checkbox" class="admin-form-switch-input" id="license_notify_expiration" name="license_notify_expiration" value="1" {{ old('license_notify_expiration', $settings->license_notify_expiration ?? true) ? 'checked' : '' }}>
                                    <label class="admin-form-switch-label" for="license_notify_expiration"></label>
                                </div>
                                <div class="admin-form-help">{{ trans('app.notify_on_expiration_help') }}</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-globe text-green-500 me-1"></i>
                                    {{ trans('app.notify_on_domain_change') }}
                                </label>
                                <div class="admin-form-switch">
                                    <input type="checkbox" class="admin-form-switch-input" id="license_notify_domain_change" name="license_notify_domain_change" value="1" {{ old('license_notify_domain_change', $settings->license_notify_domain_change ?? true) ? 'checked' : '' }}>
                                    <label class="admin-form-switch-label" for="license_notify_domain_change"></label>
                                </div>
                                <div class="admin-form-help">{{ trans('app.notify_on_domain_change_help') }}</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="admin-form-group">
                                <label class="admin-form-label">
                                    <i class="fas fa-exclamation-triangle text-orange-500 me-1"></i>
                                    {{ trans('app.notify_on_suspicious_activity') }}
                                </label>
                                <div class="admin-form-switch">
                                    <input type="checkbox" class="admin-form-switch-input" id="license_notify_suspicious" name="license_notify_suspicious" value="1" {{ old('license_notify_suspicious', $settings->license_notify_suspicious ?? true) ? 'checked' : '' }}>
                                    <label class="admin-form-switch-label" for="license_notify_suspicious"></label>
                                </div>
                                <div class="admin-form-help">{{ trans('app.notify_on_suspicious_activity_help') }}</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Form Actions -->
        <div class="admin-card">
            <div class="admin-card-content">
                <div class="d-flex gap-3">
                    <button type="submit" class="admin-btn admin-btn-primary admin-btn-m">
                        <i class="fas fa-save me-2"></i>
                        {{ trans('app.save_settings') }}
                    </button>
                    <a href="{{ route('admin.dashboard') }}" class="admin-btn admin-btn-secondary admin-btn-m">
                        <i class="fas fa-times me-2"></i>
                        {{ trans('app.Cancel') }}
                    </a>
                </div>
            </div>
        </div>
    </form>
</div>
</div>


@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Human questions dynamic add/remove handling
    (function(){
        const list = document.getElementById('human-questions-list');
        const addBtn = document.getElementById('btn-add-question');
        if (!list || !addBtn) return;

        function reindex() {
            const rows = list.querySelectorAll('.human-question-row');
            rows.forEach((row, idx) => {
                row.setAttribute('data-index', idx);
                const q = row.querySelector('input[name$="[question]"]');
                const a = row.querySelector('input[name$="[answer]"]');
                if (q) q.name = `human_questions[${idx}][question]`;
                if (a) a.name = `human_questions[${idx}][answer]`;
            });
        }

        document.addEventListener('click', function(e){
            if (e.target && e.target.classList.contains('btn-remove-question')) {
                const row = e.target.closest('.human-question-row');
                if (row) {
                    row.remove();
                    reindex();
                }
            }
        });

        addBtn.addEventListener('click', function(){
            const idx = list.querySelectorAll('.human-question-row').length;
            const wrapper = document.createElement('div');
            wrapper.className = 'human-question-row mb-3';
            wrapper.setAttribute('data-index', idx);
            wrapper.innerHTML = `
                <div class="row g-2 align-items-center">
                    <div class="col-md-7">
                        <input type="text" name="human_questions[${idx}][question]" class="admin-form-input" value="" placeholder="Question">
                    </div>
                    <div class="col-md-4">
                        <input type="text" name="human_questions[${idx}][answer]" class="admin-form-input" value="" placeholder="Answer">
                    </div>
                    <div class="col-md-1">
                        <button type="button" class="admin-btn admin-btn-danger btn-remove-question">&times;</button>
                    </div>
                </div>
            `;
            list.appendChild(wrapper);
            reindex();
        });
    })();
    // Generate API Token functionality
    const generateTokenBtn = document.getElementById('generate-api-token');
    const tokenInput = document.getElementById('license_api_token');
    
    if (generateTokenBtn && tokenInput) {
        generateTokenBtn.addEventListener('click', function() {
            // Generate a random 64-character token
            const chars = '0123456789abcdef';
            let token = '';
            for (let i = 0; i < 64; i++) {
                token += chars[Math.floor(Math.random() * chars.length)];
            }
            
            // Update the input field
            tokenInput.value = token;
            tokenInput.removeAttribute('readonly');
            
            // Show success message
            showNotification('Token generated successfully!', 'success');
        });
    }
    
    // Make token input editable when clicked
    if (tokenInput) {
        tokenInput.addEventListener('click', function() {
            this.removeAttribute('readonly');
        });
        
        // Allow manual input
        tokenInput.addEventListener('input', function() {
            // Remove readonly when user starts typing
            this.removeAttribute('readonly');
        });
    }
    
    // Test API Connection functionality
    const testApiBtn = document.getElementById('test-api-btn');
    const apiTestResult = document.getElementById('api-test-result');
    
    if (testApiBtn && apiTestResult) {
        testApiBtn.addEventListener('click', function() {
            const button = this;
            const originalText = button.innerHTML;
            
            // Show loading state
            button.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Testing...';
            button.disabled = true;
            
            // Get form data
            const formData = new FormData(document.querySelector('form'));
            formData.append('_token', document.querySelector('meta[name="csrf-token"]').getAttribute('content'));
            formData.append('action', 'test-envato-api');
            
            // Make AJAX request
            fetch('{{ route("admin.settings.test-api") }}', {
                method: 'POST',
                body: formData,
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    apiTestResult.innerHTML = `
                        <div class="admin-alert admin-alert-success">
                            <div class="admin-alert-content">
                                <i class="fas fa-check-circle admin-alert-icon"></i>
                                <div class="admin-alert-text">
                                    <h4>Connection Successful!</h4>
                                    <p>${data.message}</p>
                                </div>
                            </div>
                        </div>
                    `;
                } else {
                    apiTestResult.innerHTML = `
                        <div class="admin-alert admin-alert-danger">
                            <div class="admin-alert-content">
                                <i class="fas fa-exclamation-triangle admin-alert-icon"></i>
                                <div class="admin-alert-text">
                                    <h4>Connection Failed!</h4>
                                    <p>${data.message}</p>
                                </div>
                            </div>
                        </div>
                    `;
                }
            })
            .catch(error => {
                apiTestResult.innerHTML = `
                    <div class="admin-alert admin-alert-danger">
                        <div class="admin-alert-content">
                            <i class="fas fa-exclamation-triangle admin-alert-icon"></i>
                            <div class="admin-alert-text">
                                <h4>Connection Error!</h4>
                                <p>An error occurred while testing the connection.</p>
                            </div>
                        </div>
                    </div>
                `;
            })
            .finally(() => {
                // Restore button state
                button.innerHTML = originalText;
                button.disabled = false;
            });
        });
    }
    
    // Tab switching functionality
    const tabButtons = document.querySelectorAll('[data-tab]');
    const tabPanels = document.querySelectorAll('.admin-tab-panel');
    
    tabButtons.forEach(button => {
        button.addEventListener('click', function() {
            const targetTab = this.getAttribute('data-tab');
            
            // Remove active class from all buttons
            tabButtons.forEach(btn => btn.classList.remove('active'));
            // Add active class to clicked button
            this.classList.add('active');
            
            // Hide all panels
            tabPanels.forEach(panel => {
                panel.classList.add('admin-tab-panel-hidden');
                panel.setAttribute('aria-hidden', 'true');
            });
            
            // Show target panel
            const targetPanel = document.getElementById(targetTab);
            if (targetPanel) {
                targetPanel.classList.remove('admin-tab-panel-hidden');
                targetPanel.setAttribute('aria-hidden', 'false');
            }
        });
    });
    
    // Logo preview functionality
    const logoPreview = document.getElementById('logo-preview');
    const logoInputs = document.querySelectorAll('input[name^="logo_"]');
    
    if (logoPreview && logoInputs.length > 0) {
        logoInputs.forEach(input => {
            input.addEventListener('input', updateLogoPreview);
        });
        
        function updateLogoPreview() {
            const width = document.querySelector('input[name="logo_width"]')?.value || 150;
            const height = document.querySelector('input[name="logo_height"]')?.value || 50;
            const textColor = document.querySelector('input[name="logo_text_color"]')?.value || '#1f2937';
            const fontSize = document.querySelector('input[name="logo_text_font_size"]')?.value || '24px';
            
            logoPreview.style.width = width + 'px';
            logoPreview.style.height = height + 'px';
            
            const textElement = logoPreview.querySelector('.admin-logo-preview-text');
            if (textElement) {
                textElement.style.color = textColor;
                textElement.style.fontSize = fontSize;
            }
        }
    }
    
    // Color picker synchronization
    const colorInputs = document.querySelectorAll('input[type="color"]');
    colorInputs.forEach(input => {
        const textInput = input.nextElementSibling;
        if (textInput && textInput.type === 'text') {
            input.addEventListener('input', function() {
                textInput.value = this.value;
            });
            
            textInput.addEventListener('input', function() {
                if (this.value.match(/^#[0-9A-F]{6}$/i)) {
                    input.value = this.value;
                }
            });
        }
    });
    
    // Form validation
    const form = document.querySelector('form');
    if (form) {
        form.addEventListener('submit', function(e) {
            const requiredFields = form.querySelectorAll('[required]');
            let isValid = true;
            
            requiredFields.forEach(field => {
                if (!field.value.trim()) {
                    field.classList.add('is-invalid');
                    isValid = false;
                } else {
                    field.classList.remove('is-invalid');
                }
            });
            
            if (!isValid) {
                e.preventDefault();
                showNotification('Please fill in all required fields.', 'error');
            }
        });
    }
    
    // Notification function
    function showNotification(message, type = 'info') {
        const notification = document.createElement('div');
        notification.className = `admin-alert admin-alert-${type} admin-alert-dismissible`;
        notification.innerHTML = `
            <div class="admin-alert-content">
                <i class="fas fa-${type === 'success' ? 'check-circle' : type === 'error' ? 'exclamation-triangle' : 'info-circle'} admin-alert-icon"></i>
                <div class="admin-alert-text">${message}</div>
                <button type="button" class="admin-alert-close" onclick="this.parentElement.parentElement.remove()">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        `;
        
        // Insert at the top of the page
        const container = document.querySelector('.admin-container') || document.body;
        container.insertBefore(notification, container.firstChild);
        
        // Auto remove after 5 seconds
        setTimeout(() => {
            if (notification.parentElement) {
                notification.remove();
            }
        }, 5000);
    }
});
</script>
@endpush