{{-- Professional Preloader Component --}}
{{-- High-quality, customizable preloader with multiple styles --}}

@php
$settings = \App\Models\Setting::first();
$preloaderEnabled = $settings->preloader_enabled ?? true;
$preloaderType = $settings->preloader_type ?? 'spinner';
$preloaderColor = $settings->preloader_color ?? '#3b82f6';
$preloaderBgColor = $settings->preloader_background_color ?? '#ffffff';
$preloaderDuration = $settings->preloader_duration ?? 2000;
$preloaderText = trans('app.Loading...');
$siteLogo = $settings->site_logo ?? null;
$logoText = $settings->logo_text ?? config('app.name');
$logoShowText = $settings->logo_show_text ?? true;
@endphp

@if($preloaderEnabled)
<div class="preloader-container" 
     id="preloader-container"
     data-enabled="1"
     data-type="{{ $preloaderType }}"
     data-color="{{ $preloaderColor }}"
     data-bg="{{ $preloaderBgColor }}"
     data-duration="{{ $preloaderDuration }}"
     data-text="{{ $preloaderText }}"
     data-logo="{{ $siteLogo }}">
    <div class="preloader-content">
        {{-- Logo Section --}}
        @if($siteLogo || $logoShowText)
        <div class="preloader-logo">
            @if($siteLogo)
            <img src="{{ asset('storage/' . $siteLogo) }}" alt="{{ $logoText }}" class="preloader-logo-img"
                class="max-w-[150px] max-h-[50px]">
            @elseif($logoShowText)
            <div class="preloader-logo-text"
                class="text-gray-800 text-2xl font-semibold">
                {{ $logoText }}
            </div>
            @endif
        </div>
        @endif

        {{-- Preloader Animation --}}
        <div class="preloader-animation">
            @switch($preloaderType)
                @case('spinner')
                    <div class="preloader-spinner"></div>
                    @break
                @case('dots')
                    <div class="preloader-dots">
                        <div class="preloader-dot"></div>
                        <div class="preloader-dot"></div>
                        <div class="preloader-dot"></div>
                    </div>
                    @break
                @case('bars')
                    <div class="preloader-bars">
                        <div class="preloader-bar"></div>
                        <div class="preloader-bar"></div>
                        <div class="preloader-bar"></div>
                        <div class="preloader-bar"></div>
                        <div class="preloader-bar"></div>
                    </div>
                    @break
                @case('pulse')
                    <div class="preloader-pulse"></div>
                    @break
                @case('progress')
                    <div class="preloader-progress">
                        <div class="preloader-progress-bar"></div>
                    </div>
                    @break
                @case('custom')
                    <div class="preloader-custom">
                        {!! $settings->preloader_custom_css ?? '<div class="custom-loader"></div>' !!}
                    </div>
                    @break
                @default
                    <div class="preloader-spinner"></div>
            @endswitch
        </div>

        {{-- Loading Text --}}
        <div class="preloader-text">{{ $preloaderText }}</div>
    </div>
</div>

{{-- Preloader settings moved to data-* attributes to avoid inline JS --}}
@endif

{{-- Progressive Enhancement: Fallback for users without JavaScript --}}
<noscript>
    <link rel="stylesheet" href="{{ asset('assets/front/css/preloader-noscript.css') }}">
</noscript>