@extends('layouts.user')

@section('title', $article->title)
@section('page-title', $article->title)
@section('page-subtitle', trans('app.Knowledge Base'))

@section('content')
<div class="user-dashboard-container">
    <!-- Article Serial Header -->
    <div class="article-serial-header">
        <div class="article-serial-header-content">
            <!-- Breadcrumbs -->
            <nav class="user-breadcrumbs">
                <a href="{{ route('kb.index') }}" class="user-breadcrumb-link">
                    <i class="fas fa-home"></i>
                    {{ trans('app.Knowledge Base') }}
                </a>
                <span class="user-breadcrumb-separator">
                    <i class="fas fa-chevron-right"></i>
                </span>
                @if($article->category)
                <a href="{{ route('kb.category', $article->category->slug) }}" class="user-breadcrumb-link">
                    {{ $article->category->name }}
                </a>
                <span class="user-breadcrumb-separator">
                    <i class="fas fa-chevron-right"></i>
                </span>
                @endif
                <span class="user-breadcrumb-current">{{ $article->title }}</span>
            </nav>

            <div class="article-serial-hero">
                <div class="article-serial-hero-content">
                    <div class="article-serial-hero-icon">
                        <i class="fas fa-lock"></i>
                    </div>
                    <div class="article-serial-hero-text">
                        <h1 class="article-serial-hero-title">{{ $article->title }}</h1>
                        @if($article->excerpt)
                        <p class="article-serial-hero-subtitle">{{ $article->excerpt }}</p>
                        @endif
                    </div>
                    <div class="article-serial-hero-badge">
                        <span class="user-badge user-badge-info">
                            <i class="fas fa-shield-alt"></i>
                            {{ trans('app.serial_protection') }}
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Serial Verification Card -->
    <div class="serial-verification-card">
        <div class="serial-verification-header">
            <div class="serial-verification-icon">
                <i class="fas fa-key"></i>
            </div>
            <div class="serial-verification-title-section">
                <h2 class="serial-verification-title">{{ trans('app.serial_protection') }}</h2>
                <p class="serial-verification-subtitle">
                    @if($article->requires_serial && $article->serial_message)
                    {{ $article->serial_message }}
                    @elseif($article->category && $article->category->requires_serial && $article->category->serial_message)
                    {{ $article->category->serial_message }}
                    @else
                    {{ trans('app.users_must_enter_serial_to_access_content') }}
                    @endif
                </p>
            </div>
        </div>

        <div class="serial-verification-content">
            @if(session('error'))
            <div class="serial-error-message">
                <div class="serial-error-icon">
                    <i class="fas fa-exclamation-triangle"></i>
                </div>
                <div class="serial-error-content">
                    <h4 class="serial-error-title">{{ trans('app.Error') }}</h4>
                    <p class="serial-error-text">{{ session('error') }}</p>
                </div>
            </div>
            @endif

            <form method="GET" action="{{ route('kb.article', $article->slug) }}" class="serial-verification-form">
                <div class="serial-form-group">
                    <label for="serial" class="serial-form-label">
                        <i class="fas fa-key"></i>
                        {{ trans('app.serial_code') }}
                    </label>
                    <input 
                        id="serial" 
                        name="serial" 
                        type="text" 
                        required 
                        class="serial-form-input"
                        placeholder="{{ trans('app.enter_serial_code') }}"
                    >
                    <p class="serial-form-help">
                        <i class="fas fa-info-circle"></i>
                        {{ trans('app.enter_your_serial_code_to_access') }}
                    </p>
                </div>

                <button type="submit" class="serial-verify-button">
                    <i class="fas fa-check"></i>
                    {{ trans('app.verify_serial') }}
                </button>
            </form>
        </div>
    </div>

    <!-- Back Link -->
    <div class="serial-back-section">
        <a href="{{ route('kb.index') }}" class="serial-back-link">
            <i class="fas fa-arrow-left"></i>
            {{ trans('app.back_to_kb') }}
        </a>
    </div>

    <!-- Article Information -->
    <div class="user-card article-info-card">
        <div class="user-card-header">
            <div class="user-section-header">
                <div class="user-section-title">
                    <div class="user-section-icon">
                        <i class="fas fa-info-circle"></i>
                    </div>
                    <div>
                        <h3 class="user-section-title-text">{{ trans('app.Article Information') }}</h3>
                        <p class="user-section-subtitle">{{ trans('app.About this article') }}</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="user-card-content">
            <div class="article-info-grid">
                <div class="article-info-item">
                    <div class="info-icon">
                        <i class="fas fa-file-alt"></i>
                    </div>
                    <div class="info-content">
                        <div class="info-label">{{ trans('app.Article Title') }}</div>
                        <div class="info-value">{{ $article->title }}</div>
                    </div>
                </div>

                @if($article->category)
                <div class="article-info-item">
                    <div class="info-icon">
                        <i class="fas fa-folder"></i>
                    </div>
                    <div class="info-content">
                        <div class="info-label">{{ trans('app.Category') }}</div>
                        <div class="info-value">{{ $article->category->name }}</div>
                    </div>
                </div>
                @endif

                <div class="article-info-item">
                    <div class="info-icon">
                        <i class="fas fa-calendar"></i>
                    </div>
                    <div class="info-content">
                        <div class="info-label">{{ trans('app.Created') }}</div>
                        <div class="info-value">{{ $article->created_at->format('M d, Y') }}</div>
                    </div>
                </div>

                <div class="article-info-item">
                    <div class="info-icon">
                        <i class="fas fa-eye"></i>
                    </div>
                    <div class="info-content">
                        <div class="info-label">{{ trans('app.Views') }}</div>
                        <div class="info-value">{{ $article->views }}</div>
                    </div>
                </div>

                <div class="article-info-item">
                    <div class="info-icon">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <div class="info-content">
                        <div class="info-label">{{ trans('app.Access Level') }}</div>
                        <div class="info-value">
                            <span class="user-badge user-badge-info">
                                <i class="fas fa-lock"></i>
                                {{ trans('app.Serial Required') }}
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection