@extends('layouts.admin')

@section('title', trans('app.Updater'))

@section('admin-content')
    <div class="admin-card">
        <div class="admin-card-header">
            <h3>{{ trans('app.Updater') }}</h3>
        </div>
        <div class="admin-card-body">
            <p>{{ trans('app.update_instructions') }}</p>
            <form method="POST" action="{{ route('update.run') }}" enctype="multipart/form-data">
                @csrf
                <div class="form-group">
                    <label for="package">{{ trans('app.update_package') }}</label>
                    <input type="file" name="package" id="package" class="form-control">
                    @error('package')<div class="text-danger">{{ $message }}</div>@enderror
                </div>
                <button class="btn btn-primary" type="submit">{{ trans('app.Run Update') }}</button>
            </form>
        </div>
    </div>
@endsection
