@extends('layouts.user')

@section('title', trans('app.Invoice Details'))
@section('page-title', trans('app.Invoice Details'))
@section('page-subtitle', trans('app.View invoice information and make payments'))

@section('seo_title', $siteSeoTitle ?? trans('app.Invoice Details'))
@section('meta_description', $siteSeoDescription ?? trans('app.View invoice information and make payments'))


@section('content')
<div class="user-dashboard-container">
    <!-- Header Section -->
    <div class="user-card">
        <div class="user-card-header">
            <div class="user-card-title">
                <i class="fas fa-file-invoice"></i>
                {{ trans('app.Invoice') }} #{{ $invoice->invoice_number }}
            </div>
            <p class="user-card-subtitle">
                {{ trans('app.Invoice details and payment information') }}
            </p>
        </div>

        <div class="user-card-content">
            <!-- Invoice Status Banner -->
            <div class="invoice-status-banner invoice-status-{{ $invoice->status }}">
                <div class="status-content">
                    <i class="fas fa-{{ $invoice->status === 'paid' ? 'check-circle' : ($invoice->status === 'pending' ? 'clock' : 'times-circle') }}"></i>
                    <div>
                        <h3>{{ trans('app.Invoice') }} {{ ucfirst($invoice->status) }}</h3>
                        <p>
                            @if($invoice->status === 'paid')
                                {{ trans('app.This invoice has been paid successfully') }}
                            @elseif($invoice->status === 'pending')
                                {{ trans('app.This invoice is pending payment') }}
                            @else
                                {{ trans('app.This invoice has been cancelled') }}
                            @endif
                        </p>
                    </div>
                </div>
            </div>

            <!-- Invoice Details Grid -->
            <div class="license-details-grid">
                <!-- Invoice Information -->
                <div class="license-info-card">
                    <div class="license-info-header">
                        <h3>{{ trans('app.Invoice Information') }}</h3>
                    </div>
                    
                    <div class="license-info-content">
                        <div class="info-row">
                            <label>{{ trans('app.Invoice Number') }}:</label>
                            <span>{{ $invoice->invoice_number }}</span>
                        </div>
                        
                        <div class="info-row">
                            <label>{{ trans('app.Status') }}:</label>
                            <span class="invoice-status-badge invoice-status-{{ $invoice->status }}">
                                {{ ucfirst($invoice->status) }}
                            </span>
                        </div>
                        
                        <div class="info-row">
                            <label>{{ trans('app.Amount') }}:</label>
                            <span class="invoice-amount">${{ number_format($invoice->amount, 2) }}</span>
                        </div>
                        
                        <div class="info-row">
                            <label>{{ trans('app.Created Date') }}:</label>
                            <span>{{ $invoice->created_at->format('M d, Y') }}</span>
                        </div>
                        
                        @if($invoice->due_date)
                        <div class="info-row">
                            <label>{{ trans('app.Due Date') }}:</label>
                            <span>{{ $invoice->due_date->format('M d, Y') }}</span>
                        </div>
                        @endif
                        
                        @if($invoice->paid_at)
                        <div class="info-row">
                            <label>{{ trans('app.Paid Date') }}:</label>
                            <span>{{ $invoice->paid_at->format('M d, Y') }}</span>
                        </div>
                        @endif
                    </div>
                </div>

                <!-- Product Information -->
                @if($invoice->license && $invoice->license->product)
                <div class="license-info-card">
                    <div class="license-info-header">
                        <h3>{{ trans('app.Product Information') }}</h3>
                    </div>
                    
                    <div class="license-info-content">
                        <div class="info-row">
                            <label>{{ trans('app.Product') }}:</label>
                            <span>{{ $invoice->license->product->name }}</span>
                        </div>
                        
                        <div class="info-row">
                            <label>{{ trans('app.Version') }}:</label>
                            <span>v{{ $invoice->license->product->version ?? '-' }}</span>
                        </div>
                        
                        <div class="info-row">
                            <label>{{ trans('app.License Type') }}:</label>
                            <span class="license-type-badge">{{ ucfirst($invoice->license->license_type ?? '-') }}</span>
                        </div>
                        
                        <div class="info-row">
                            <label>{{ trans('app.License Key') }}:</label>
                            <div class="license-key-display">
                                <code class="license-key-code">{{ $invoice->license->license_key }}</code>
                                <button class="copy-key-btn" data-key="{{ $invoice->license->license_key }}" title="{{ trans('app.Copy License Key') }}">
                                    <i class="fas fa-copy"></i>
                                </button>
                            </div>
                        </div>
                        
                        <div class="info-row">
                            <label>{{ trans('app.Actions') }}:</label>
                            <a href="{{ route('public.products.show', $invoice->license->product->slug) }}" class="license-action-link">
                                <i class="fas fa-external-link-alt"></i>
                                {{ trans('app.View Product') }}
                            </a>
                        </div>
                    </div>
                </div>
                @endif
            </div>

            <!-- Payment Section -->
            @if($invoice->status === 'pending')
            <div id="payment" class="payment-section">
                <div class="section-header">
                    <h3>{{ trans('app.Make Payment') }}</h3>
                </div>
                
                <div class="payment-methods">
                    <div class="payment-method-card">
                        <div class="payment-method-header">
                            <i class="fas fa-credit-card"></i>
                            <h4>{{ trans('app.Credit Card') }}</h4>
                        </div>
                        <p>{{ trans('app.Pay securely with your credit card') }}</p>
                        <button class="user-action-button" data-payment="credit_card">
                            <i class="fas fa-credit-card"></i>
                            {{ trans('app.Pay with Credit Card') }}
                        </button>
                    </div>
                    
                    <div class="payment-method-card">
                        <div class="payment-method-header">
                            <i class="fas fa-university"></i>
                            <h4>{{ trans('app.Bank Transfer') }}</h4>
                        </div>
                        <p>{{ trans('app.Transfer funds directly from your bank') }}</p>
                        <button class="user-action-button" data-payment="bank_transfer">
                            <i class="fas fa-university"></i>
                            {{ trans('app.Pay with Bank Transfer') }}
                        </button>
                    </div>
                    
                    <div class="payment-method-card">
                        <div class="payment-method-header">
                            <i class="fab fa-paypal"></i>
                            <h4>{{ trans('app.PayPal') }}</h4>
                        </div>
                        <p>{{ trans('app.Pay with your PayPal account') }}</p>
                        <button class="user-action-button" data-payment="paypal">
                            <i class="fab fa-paypal"></i>
                            {{ trans('app.Pay with PayPal') }}
                        </button>
                    </div>
                </div>
            </div>
            @endif

            <!-- Download Section -->
            @if($invoice->status === 'paid' && $invoice->license && $invoice->license->product)
            <div id="download" class="download-section">
                <div class="section-header">
                    <h3>{{ trans('app.Download Product') }}</h3>
                </div>
                
                <div class="download-content">
                    <div class="download-info">
                        <i class="fas fa-download"></i>
                        <div>
                            <h4>{{ $invoice->license->product->name }}</h4>
                            <p>{{ trans('app.Your product is ready for download') }}</p>
                        </div>
                    </div>
                    
                    <div class="download-actions">
                        <a href="{{ route('public.products.show', $invoice->license->product->slug) }}" class="user-action-button">
                            <i class="fas fa-download"></i>
                            {{ trans('app.Download Product') }}
                        </a>
                        
                        <a href="{{ route('user.licenses.show', $invoice->license) }}" class="user-action-button">
                            <i class="fas fa-key"></i>
                            {{ trans('app.View License') }}
                        </a>
                    </div>
                </div>
            </div>
            @endif

            <!-- Invoice Actions -->
            <div class="license-actions-section">
                <div class="action-buttons">
                    <a href="{{ route('user.invoices.index') }}" class="user-action-button">
                        <i class="fas fa-arrow-left"></i>
                        {{ trans('app.Back to Invoices') }}
                    </a>
                    
                    <button class="user-action-button" data-action="print">
                        <i class="fas fa-print"></i>
                        {{ trans('app.Print Invoice') }}
                    </button>
                    
                    <a href="{{ route('user.tickets.create') }}" class="user-action-button">
                        <i class="fas fa-headset"></i>
                        {{ trans('app.Get Support') }}
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection