@extends('layouts.user')

@section('title', trans('app.Product Files') . ' - ' . $product->name)
@section('page-title', trans('app.Product Files'))
@section('page-subtitle', $product->name)

@section('content')
<div class="user-dashboard-container">
    <!-- Header Section -->
    <div class="user-card">
        <div class="user-card-header">
            <div class="user-card-title">
                <i class="fas fa-download"></i>
                {{ trans('app.Product Files') }}: {{ $product->name }}
            </div>
            <p class="user-card-subtitle">
                {{ trans('app.Download and manage your product files') }}
            </p>
        </div>

        <div class="user-card-content">
            <!-- Action Buttons -->
            <div class="user-action-buttons">
                <a href="{{ route('user.products.show', $product) }}" class="user-btn user-btn-secondary">
                    <i class="fas fa-arrow-left"></i>
                    {{ trans('app.Back to Product') }}
                </a>
                @if($files->count() > 1)
                    <a href="{{ route('user.products.files.download-all', $product) }}" class="user-btn user-btn-success">
                        <i class="fas fa-download"></i>
                        {{ trans('app.Download All as ZIP') }}
                    </a>
                @endif
            </div>
            @if(isset($permissions) && !$permissions['can_download'])
                <div class="user-alert user-alert-warning">
                    <div class="user-alert-icon">
                        <i class="fas fa-exclamation-triangle"></i>
                    </div>
                    <div class="user-alert-content">
                        <h4 class="user-alert-title">{{ trans('app.Cannot Download Files') }}</h4>
                        <p class="user-alert-message">{{ $permissions['message'] }}</p>
                        
                        @if(!$permissions['has_license'])
                            <div class="user-alert-actions">
                                <a href="{{ route('user.products.show', $product) }}" class="user-btn user-btn-primary">
                                    <i class="fas fa-shopping-cart"></i>
                                    {{ trans('app.Purchase Product') }}
                                </a>
                            </div>
                        @elseif(!$permissions['has_paid_invoice'])
                            <div class="user-alert-actions">
                                <a href="{{ route('user.invoices.index') }}" class="user-btn user-btn-warning">
                                    <i class="fas fa-credit-card"></i>
                                    {{ trans('app.Pay Invoice') }}
                                </a>
                            </div>
                        @endif
                    </div>
                </div>
            @elseif($files->count() > 0)
                <div class="user-alert user-alert-success">
                    <div class="user-alert-icon">
                        <i class="fas fa-check-circle"></i>
                    </div>
                    <div class="user-alert-content">
                        <h4 class="user-alert-title">{{ trans('app.Files Available') }}</h4>
                        <p class="user-alert-message">{{ trans('app.You can download the following files because you have a valid license and paid invoice for this product.') }}</p>
                    </div>
                </div>

                <!-- Files Grid -->
                <div class="user-stats-grid">
                    @foreach($files as $file)
                        <div class="user-stat-card">
                            <!-- File Header -->
                            <div class="user-stat-header">
                                <div class="user-stat-title">{{ $file->original_name }}</div>
                                <div class="user-stat-icon blue">
                                    @if($file->file_extension == 'zip')
                                        <i class="fas fa-file-archive"></i>
                                    @elseif(in_array($file->file_extension, ['pdf']))
                                        <i class="fas fa-file-pdf"></i>
                                    @elseif(in_array($file->file_extension, ['doc', 'docx']))
                                        <i class="fas fa-file-word"></i>
                                    @elseif(in_array($file->file_extension, ['xls', 'xlsx']))
                                        <i class="fas fa-file-excel"></i>
                                    @elseif(in_array($file->file_extension, ['jpg', 'jpeg', 'png', 'gif']))
                                        <i class="fas fa-file-image"></i>
                                    @else
                                        <i class="fas fa-file"></i>
                                    @endif
                                </div>
                            </div>
                            
                            <!-- File Info -->
                            <div class="user-stat-value">{{ $file->formatted_size }}</div>
                            <p class="text-sm text-slate-500 dark:text-slate-400">{{ strtoupper($file->file_extension) }} {{ trans('app.File') }}</p>
                            
                            <!-- File Description -->
                            @if($file->description)
                                <div class="mt-3">
                                    <p class="text-xs text-slate-400 dark:text-slate-500">{{ $file->description }}</p>
                                </div>
                            @endif
                            
                            <!-- File Stats -->
                            <div class="mt-3 flex justify-between text-xs text-slate-500 dark:text-slate-400">
                                <span><i class="fas fa-download mr-1"></i>{{ $file->download_count }} {{ trans('app.Downloads') }}</span>
                                <span><i class="fas fa-calendar mr-1"></i>{{ $file->created_at->format('M d, Y') }}</span>
                            </div>
                            
                            <!-- Download Button -->
                            <div class="mt-4">
                                <a href="{{ route('user.product-files.download', $file) }}" 
                                   class="user-btn user-btn-primary user-btn-full"
                                   title="{{ trans('app.Download') }} {{ $file->original_name }}">
                                    <i class="fas fa-download mr-2"></i>
                                    {{ trans('app.Download File') }}
                                </a>
                            </div>
                        </div>
                    @endforeach
                </div>

                <!-- Download Statistics -->
                <div class="user-stats-grid">
                    <div class="user-stat-card">
                        <div class="user-stat-header">
                            <div class="user-stat-title">{{ trans('app.Total Files') }}</div>
                            <div class="user-stat-icon blue">
                                <i class="fas fa-file"></i>
                            </div>
                        </div>
                        <div class="user-stat-value">{{ $files->count() }}</div>
                        <p class="text-sm text-slate-500 dark:text-slate-400">{{ trans('app.Available for download') }}</p>
                    </div>

                    <div class="user-stat-card">
                        <div class="user-stat-header">
                            <div class="user-stat-title">{{ trans('app.Total Downloads') }}</div>
                            <div class="user-stat-icon green">
                                <i class="fas fa-download"></i>
                            </div>
                        </div>
                        <div class="user-stat-value">{{ $files->sum('download_count') }}</div>
                        <p class="text-sm text-slate-500 dark:text-slate-400">{{ trans('app.Downloads made') }}</p>
                    </div>

                    <div class="user-stat-card">
                        <div class="user-stat-header">
                            <div class="user-stat-title">{{ trans('app.Total Size') }}</div>
                            <div class="user-stat-icon purple">
                                <i class="fas fa-hdd"></i>
                            </div>
                        </div>
                        <div class="user-stat-value">{{ $files->sum('file_size') > 0 ? number_format($files->sum('file_size') / 1024 / 1024, 2) . ' MB' : '0 MB' }}</div>
                        <p class="text-sm text-slate-500 dark:text-slate-400">{{ trans('app.Combined size') }}</p>
                    </div>

                    <div class="user-stat-card">
                        <div class="user-stat-header">
                            <div class="user-stat-title">{{ trans('app.Last Updated') }}</div>
                            <div class="user-stat-icon orange">
                                <i class="fas fa-calendar"></i>
                            </div>
                        </div>
                        <div class="user-stat-value">{{ $files->sortByDesc('created_at')->first()->created_at->format('Y-m-d') }}</div>
                        <p class="text-sm text-slate-500 dark:text-slate-400">{{ trans('app.Most recent file') }}</p>
                    </div>
                </div>
            @else
                <div class="user-empty-state">
                    <div class="user-empty-state-icon">
                        <i class="fas fa-folder-open"></i>
                    </div>
                    <h4 class="user-empty-state-title">{{ trans('app.No files available') }}</h4>
                    <p class="user-empty-state-message">{{ trans('app.No files have been uploaded for this product yet.') }}</p>
                    <div class="user-empty-state-actions">
                        <a href="{{ route('user.products.show', $product) }}" class="user-btn user-btn-primary">
                            <i class="fas fa-arrow-left"></i>
                            {{ trans('app.Back to Product') }}
                        </a>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection