<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\LicenseApiController;
use App\Http\Controllers\Api\KbApiController;
use App\Http\Controllers\Api\LicenseController;
use App\Http\Controllers\Api\TicketApiController;
use App\Http\Controllers\Api\ProductApiController;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\TicketController;
use App\Http\Controllers\Admin\ProgrammingLanguageController;
use App\Http\Controllers\KbArticleController;
use App\Http\Controllers\KbCategoryController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// License file content API
Route::get('programming-languages/license-file/{language}', [ProgrammingLanguageController::class, 'getLicenseFileContent'])
    ->name('api.programming-languages.license-file');

// License verification endpoints (public access)
Route::prefix('license')->group(function () {
    Route::post('/verify', [LicenseApiController::class, 'verify'])->middleware('throttle:30,1');
    Route::post('/register', [LicenseApiController::class, 'register']);
    Route::post('/status', [LicenseApiController::class, 'status']);
});

// KB serial verification endpoints (public access)
Route::prefix('kb')->group(function () {
    Route::get('/article/{slug}/requirements', [KbApiController::class, 'getArticleRequirements']);
    Route::post('/article/{slug}/verify', [KbApiController::class, 'verifyArticleSerial']);
    Route::get('/category/{slug}/requirements', [KbApiController::class, 'getCategoryRequirements']);
});

// API Resource Routes (for testing)
Route::middleware('auth:sanctum')->group(function () {
    Route::apiResource('licenses', LicenseController::class);
    Route::apiResource('products', ProductController::class);
    Route::apiResource('users', UserController::class);
    Route::apiResource('tickets', TicketApiController::class);
    Route::apiResource('kb/articles', KbArticleController::class);
    Route::apiResource('kb/categories', KbCategoryController::class);
});

// Public API Routes (for testing without authentication)
Route::apiResource('licenses', LicenseController::class)->only(['index']);
Route::apiResource('products', ProductController::class)->only(['index']);
Route::apiResource('users', UserController::class)->only(['index']);
Route::apiResource('tickets', TicketApiController::class)->only(['index']);
Route::apiResource('kb/articles', KbArticleController::class)->only(['index']);
Route::apiResource('kb/categories', KbCategoryController::class)->only(['index']);

// Verify purchase code for ticket creation - moved to web routes for XAMPP compatibility
// Route::get('/verify-purchase-code/{purchaseCode}', [TicketApiController::class, 'verifyPurchaseCode'])
//     ->name('api.verify-purchase-code');

// Product lookup by purchase code (for ticket creation)
Route::post('/product/lookup', [ProductApiController::class, 'lookupByPurchaseCode'])
    ->name('api.product.lookup');

// Admin API routes for form functionality
Route::prefix('admin')->middleware(['auth:sanctum', 'admin'])->group(function () {
    Route::get('/user-licenses/{userId}', [UserController::class, 'getUserLicenses'])
        ->name('api.admin.user-licenses');
});