<?php

use Illuminate\Foundation\Inspiring;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schedule;

Artisan::command('inspire', function () {
    $this->comment(Inspiring::quote());
})->purpose('Display an inspiring quote');

// Schedule invoice processing jobs
Schedule::command('invoices:process')
    ->dailyAt('09:00')
    ->description('Process renewal and overdue invoices daily at 9 AM');

Schedule::command('invoices:process --overdue')
    ->hourly()
    ->description('Process overdue invoices hourly');

// Schedule renewal invoice generation
Schedule::command('licenses:generate-renewal-invoices')
    ->dailyAt('08:00')
    ->description('Generate renewal invoices for licenses expiring within 7 days');

Schedule::command('licenses:generate-renewal-invoices --days=30')
    ->weekly()
    ->sundays()
    ->at('08:00')
    ->description('Generate renewal invoices for licenses expiring within 30 days (weekly reminder)');
