(function ($) {
	"use strict";

	/**======================START social share drag and drop ===============================**/

	$(document).ready(function () {

		var $checkboxes = $('.customize-control-checkbox-social');

		if ($checkboxes.length > 0) {
			$checkboxes.each(function () {
				$(this).val($(this).is(':checked') ? 1 : 0);
			});

			$checkboxes.on('change', function () {
				// Update the checkbox value based on its checked state				
				$(this).val($(this).is(':checked') ? 1 : 0);

				var arr1 = [];
				var $parentList = $(this).closest('.litho-post-social-icon-list');
				$parentList.find('.customize-control-textbox-social').each(function (index) {
					var $textbox = $(this);
					var dataValue = $textbox.attr('data-value');

					if (dataValue != '') {
						arr1.push(dataValue);
						arr1.push($textbox.siblings('.customize-control-checkbox-social').attr('value'));
						arr1.push($textbox.attr('data-label'));
					}
				});

				// Set the value of the parent list
				$parentList.closest('.customize-control').find('.litho-post-social-icon-list').val(arr1).trigger('change');
			});
		}

		var $socialIconLists = $('.litho-post-social-icon-list');
		if ($socialIconLists.length > 0) {
			$socialIconLists.sortable({
				handle: 'img.icon-move',
				cancel: '',
				update: function () {
					var arr = [];
					var $currentList = $(this);
					$currentList.find('.customize-control-textbox-social').each(function (index) {
						var $textbox = $(this);
						var dataValue = $textbox.attr('data-value');

						if (dataValue != '') {
							arr.push(dataValue);
							arr.push($textbox.siblings('.customize-control-checkbox-social').attr('value'));
							arr.push($textbox.attr('data-label'));
						}
					});

					// Update the value of the parent control with the sorted array
					$currentList.closest('.customize-control').find('.litho-post-social-icon-list').val(arr).trigger('change');
				}
			});
		}

		/**====================== END social share drag and drop ===============================**/

		$(document).on('click', 'li.litho-switch-option', function (event) {
			var _parents = $(this).parent();
			_parents.find('.active').removeClass('active');
			$(this).addClass('active');
		});
		/**======================END Switch button ===============================**/

		/**======================START Custom Fonts===============================**/

		$(document).on('focus', '.custom-font .font-family', function (event) {
			$(this).removeClass('error');
		});

		$(document).on('change', '.litho_font_upload_button', function (event) {
			event.preventDefault();

			var _self = $(this),
				mime_type = _self.data('mime_type'),
				font_type = _self.data('font_type'),
				inputTextField = _self.parent().parent().find('input[type="text"]'),
				fontFamily = _self.parents('.custom-font').find('.font-family'),
				fontFamily_val = fontFamily.val();

			var fontTextpattern = /^[a-zA-Z\s-_]+$/; // Allow characters, spaces, dash, underscore

			if (!fontTextpattern.test(fontFamily_val) || fontFamily.length === 0 || fontFamily_val === '') {
				alert(LithoCustomizer.i18n.error_message);
				fontFamily.focus();
				return false;
			}

			var file_data = _self.prop('files')[0];
			var form_data = new FormData();

			form_data.append('file', file_data);
			form_data.append('fontFamily', fontFamily_val);
			form_data.append('mime_type', mime_type);
			form_data.append('font_type', font_type);
			form_data.append('action', 'litho_upload_custom_font_action_data');
			form_data.append('_ajax_nonce', LithoCustomizer.nonce);

			$.ajax({
				url: LithoCustomizer.ajaxurl,
				type: 'POST',
				contentType: false,
				processData: false,
				data: form_data,
				success: function (response) {
					if (typeof response === 'string') {
						response = JSON.parse(response);
					}

					if (response.success) {
						inputTextField.val('');
						inputTextField.val(response.data.url);
						customFontValue();
					} else {
						alert(response.data);
					}
				},
				error: function () {
					alert(LithoCustomizer.i18n.ajax_failed);
				}
			});

			return false;
		});

		$(document).on('click', '.add_more_fonts', function () {
			var template = wp.template('litho-custom-font-repeater');
			setTimeout(function () {
				var html = template();
				$('.add-custom-font').append(html);
			}, 600);
		});

		$(document).on('keyup', '.custom-font input', function () {
			customFontValue();
		});

		$(document).on('click', '.remove-custom-font', function () {
			var button = $(this),
				fontFamily = button.closest('.custom-font').find('.font-family'),
				fontFamily_val = fontFamily.val();

			if (!fontFamily_val) {
				alert(LithoCustomizer.i18n.font_missing_text);
				return;
			}

			var data = {
				'action': 'litho_remove_font_family_action_data',
				'fontfamily': fontFamily_val,
				'_ajax_nonce': LithoCustomizer.nonce
			};

			$.post(
				LithoCustomizer.ajaxurl,
				data,
				function (response) {
					if (response.success) {
						button.closest('.custom-font').remove();
						customFontValue();
					} else {
						alert('Error: ' + (response.data || LithoCustomizer.i18n.font_delete));
					}
				}
			).fail(function () {
				alert(LithoCustomizer.i18n.ajax_failed);
			});
		});

		function customFontValue(response) {
			var final_array = [];
			if ($('.add-custom-font ul').length > 0) {
				$(document).find('.custom-font').each(function () {
					var array = [];
					$(this).find('input[type="text"]').each(function () {
						array.push($(this).val());
					});
					final_array.push(array);
					$(this).parents('#customize-control-litho_custom_fonts').find('input[type=hidden]').val(JSON.stringify(final_array)).trigger('change');
				});
			} else {
				wp.customize.value('litho_custom_fonts')('');
			}
		}

		/**======================END Custom Fonts===============================**/

		/**======================START Multiple Checkbox===============================**/

		$(document).on('change', '.customize-control-checkbox-multiple .checkbox-field', function () {
			getcheckedvalue($(this));
		});

		$(document).on('change', '.customize-control-checkbox-multiple .selectall', function () {
			$(this).parents('.customize-control-checkbox-multiple').find('.checkbox-field').prop('checked', this.checked);
			getcheckedvalue($(this));
		});

		$('.customize-control-checkbox-multiple .checkbox-field').each(function (index) {
			getcheckedvalue($(this));
		});

		function getcheckedvalue(self) {
			var _parents = self.parents('.customize-control-checkbox-multiple');
			if (_parents.find('.checkbox-field:checked').length === _parents.find('.checkbox-field').length) {
				_parents.find('.selectall').prop('checked', true);
			} else {
				_parents.find('.selectall').prop('checked', false);
			}
			var checkbox_values = _parents.find('.checkbox-field:checked').map(function () {
				return $(this).val();
			}).get();

			self.parents('.customize-control').find('input[type="hidden"]').val(checkbox_values.join(',')).trigger('change');
		}

		/**======================END Multiple Checkbox===============================**/

		/**======================START Select2 Multiple ===============================**/

		// Initialize the select2
		function initializeSelect2() {
			const $elSelectElement = $('.customize-control-select2');

			if ($elSelectElement.length > 0) {
				$elSelectElement.each(function () {
					const $elThis = $(this);
					const selectedValues = $elThis.data('selected') ? $elThis.data('selected').split(',') : [];

					if (!$elThis.hasClass('select2-initialized')) {
						$elThis.select2({
							width: '100%',
							allowClear: true
						}).addClass('select2-initialized');

						$elThis.val(selectedValues).trigger('change');
					}
				});
			}
		}

		initializeSelect2();

		$(document).on('click', '.select2-selection__clear', function () {
			const $select = $(this).closest('.select2-container').prev('.select2-initialized');

			if ($select.length > 0) {
				$select.val(null).trigger('change').select2('close');
			}
		});

		/**======================END Select2 Multiple ===============================**/


		/**======================START Alpha Color Picker===============================**/

		$(document).on('click', '.wp-picker-clear', function (event) {
			$(this).parent().find('.alpha-color-control').trigger('change');
		});

		/**======================END Alpha Color Picker===============================**/

		/**======================START Image preview selector ===============================**/

		$(document).on('click', '.litho-image-select img', function () {

			var current_click = $(this),
				_parents = current_click.parent().parent();

			_parents.parent().find('.active').removeClass('active');
			_parents.addClass('active');
		});

		/**======================END Image preview selector ===============================**/

		/**======================START Custom sidebars ===============================**/

		if ($('#litho_field_add_sidebar').length > 0) {
			var current_val = $('#litho_field_add_sidebar').find('input[type=hidden]').val();
			var content = null;
			if (current_val != '') {
				var count = current_val.split(",").length;
				for (var i = 0; i < count; i++) {
					var template = wp.template('litho-custom-sidebar-repeater');
					var get_input_val = current_val.split(",")[i];

					content = template({
						input_val: get_input_val
					});

					$('.add-custom-text-box').append(content);
				}
			}
		}

		$(document).on('click', '.add_more_sidebar', function () {
			var template = wp.template('litho-custom-sidebar-repeater');
			var content = null;

			content = template({
				input_val: ''
			});
			$('.add-custom-text-box').append(content);
		});

		$(document).on('keyup', '.add-text-input', function () {
			display();
		});

		$(document).on('click', '.remove-text-box', function () {
			$(this).parent().remove();
			display();
		});

		function display() {
			var array = [];
			if ($('.add-custom-text-box li').length > 0) {
				$('.add-text-input').each(function (index) {
					array.push($(this).val());
					$(this).parents('#customize-control-litho_custom_sidebars').find('input[type=hidden]').val(array).trigger('change');
				});
			} else {
				wp.customize.value('litho_custom_sidebars')('');
			}
		}

		/**======================END Custom sidebars ===============================**/

		/**====================== START Custom Preload Resources ===============================**/

		function isValidUrl( url ) {
			// Regular expression for validating a URL
			let pattern = /^(https?:\/\/)((localhost|[\da-z.-]+\.[a-z.]{2,6})|(\d{1,3}\.){3}\d{1,3}|\[[0-9a-fA-F:]+\])(:[0-9]{1,5})?(\/[^\s]*)?$/;
			return pattern.test( url );
		}

		function saveResources() {
			let resources  = [];
			let isAnyValid = false;

			// Loop through each resource item.
			let resourceItem = $( '.resource-item' );
			if ( resourceItem.length > 0 ) {
				resourceItem.each( function () {
					let $thisItem = $( this );
					let url = $thisItem.find( '.resource-url' ).val();
					let type = $thisItem.find( '.resource-type' ).val();

					let errorMessageElement = $thisItem.find( '.preload-error-message' );
					// Remove any existing error message
					errorMessageElement.remove();

					// Only add to resources if URL is valid
					if ( url && isValidUrl( url ) ) {
						resources.push( { url: url, type: type } );
						isAnyValid = true;
					} else if ( url && ! isValidUrl( url ) ) {
						$thisItem.append( '<div class="preload-error-message">' + LithoCustomizer.i18n.resource_error_message + '</div>' );
					}
				});
			}

			// Update the Customizer setting with the updated resource list only if there are valid URLs
			if ( isAnyValid ) {
				wp.customize( 'litho_preload_resources' ).set( JSON.stringify( resources ) );
			} else {
				wp.customize( 'litho_preload_resources' ).set( '' );
			}
		}

		// Add new resource item
		$( document ).on( 'click', '.add-resource', function ( e ) {
			e.preventDefault();

			let choices = {
				'document': LithoCustomizer.preload_resources_type.document,
				'font': LithoCustomizer.preload_resources_type.font,
				'image': LithoCustomizer.preload_resources_type.image,
				'script': LithoCustomizer.preload_resources_type.script,
				'style': LithoCustomizer.preload_resources_type.style,
			};

			let newResource = $( '<div class="resource-item"></div>' );

			// Text box for URL
			let urlInput = $( '<input type="text" class="resource-url" placeholder="' + LithoCustomizer.i18n.resource_placeholder_url + '" />' );

			// Dropdown for resource type
			let selectDropdown = $( '<select class="resource-type"></select>' );
			$.each( choices, function ( value, label ) {
				selectDropdown.append( '<option value="' + value + '">' + label + '</option>' );
			});

			// Remove button
			let removeButton = $( '<a href="#" class="remove-resource">' + LithoCustomizer.i18n.resource_remove_btn_text + '</a>' );

			// Append inputs and button to the new resource div
			newResource.append( urlInput ).append( selectDropdown ).append( removeButton );

			// Add to the new resource container
			$( '.new-resource' ).append( newResource );

			// Attach input event to the new URL input to validate on input
			urlInput.on( 'input', function () {
				saveResources();
				triggerCustomizerChange();
			});

			// Trigger save function after adding a new resource
			saveResources();
		});

		// Event handler to remove a resource
		$( document ).on( 'click', '.remove-resource', function ( e ) {
			e.preventDefault();
			$( this ).closest( '.resource-item' ).remove();
			saveResources();
			triggerCustomizerChange();
		});

		// Save data on input change
		$( document ).on( 'input change', '.resource-url, .resource-type', function () {
			saveResources();
			triggerCustomizerChange();
		});

		function triggerCustomizerChange() {
			wp.customize.previewer.refresh();
		}

		/**====================== END Custom Preload Resources ===============================**/
		/**====================== Start Custom Prefetch URL ===============================**/

		// Add a new text field
		const $document = $( document ); 
		$document.on( 'click', '.add-prefetch', function () {
			const newField = `
				<div class="prefetch-item box-item">
					<input type="text" class="prefetch-url" placeholder="e.g., fonts.googleapis.com" />
					<button type="button" class="button remove-prefetch remove-text-box">` + LithoCustomizer.custom_preload_remove + `</button>
				</div>`;
			$( '#prefetch-container' ).append( newField );
			triggerPrefetchUpdate();
		} );

		// Remove a resource
		$document.on( 'click', '.remove-prefetch', function () {
			$( this ).closest( '.prefetch-item' ).remove();
			triggerPrefetchUpdate();
		});

		// Listen for input changes
		$document.on( 'input', '.prefetch-url', function () {
			triggerPrefetchUpdate();
		} );

		// Update Customizer setting
		function triggerPrefetchUpdate() {
			const resources = [];
			$( '#prefetch-container .prefetch-item' ).each( function () {
				const url = $( this ).find( '.prefetch-url' ).val();
				resources.push( { url } );
			});
			wp.customize( 'litho_prefetch_dns_urls', function ( setting ) {
				setting.set( JSON.stringify( resources ) );
			});
		}
		/**====================== End Custom Prefetch URL ===============================**/

		/**====================== Start Custom Preconnect Domain ===============================**/

		// Add new preconnect item
		$document.on( 'click', '.add-preconnect', function () {
			$( '#preconnect-container' ).append(`
				<div class="preconnect-item box-item">
					<input type="text" class="preconnect-domain" placeholder="e.g., cdn.google.com" />
					<div class="check-crossorigin">
						<input type="checkbox" id="preconnect_domain" name="preconnect_domain" value="">
						<label>` + LithoCustomizer.crossorigin + `</label>
					</div>
					<button type="button" class="button remove-preconnect remove-text-box">` + LithoCustomizer.custom_preload_remove + `</button>
				</div>
			`);
			triggerPreconnectUpdate();
		});

		// Remove a preconnect item
		$document.on( 'click', '.remove-preconnect', function () {
			$( this ).closest( '.preconnect-item' ).remove();
			triggerPreconnectUpdate();
		});

		// Update the Customizer when inputs change
		$document.on( 'input change', '.preconnect-domain, .preconnect-item input[type="checkbox"]', function () {
			triggerPreconnectUpdate();
		});

		// Function to trigger Customizer updates
		function triggerPreconnectUpdate() {
			const resources = [];
			$( '#preconnect-container .preconnect-item' ).each( function () {
				const url       = $( this ).find( '.preconnect-domain' ).val();
				const isChecked = $( this ).find( 'input[type="checkbox"]' ).is( ':checked' ) ? 1 : 0;
				resources.push({ url, isChecked });
			});

			// Update the Customizer setting
			wp.customize( 'litho_preconnect_urls', function ( setting ) {
				setting.set( JSON.stringify( resources ) );
			});
		}
		/**====================== End Custom Preconnect Domain ===============================**/

	});

})(jQuery);
