<?php
/**
 * Customizer Control: Multiple Select
 *
 * @package Litho
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// If class `WP_Customize_Control` exists.
if ( class_exists( 'WP_Customize_Control' ) ) {

	// If class `Litho_Customize_Multi_Select_Control` doesn't exists yet.
	if ( ! class_exists( 'Litho_Customize_Multi_Select_Control' ) ) {

        /**
		 * Define Litho_Customize_Checkbox_Multiple class
		 */
		class Litho_Customize_Multi_Select_Control extends WP_Customize_Control {

            /**
			 * Customize control type.
			 *
			 * @var string
			 */
			public $type = 'select2-multiple';
            
			/**
			 * Render Callback functions.
			 */
			public function render_content() {
				if ( empty( $this->choices ) ) {
					return;
				}

				$default_array_filp = array_flip( $this->choices );
				$selected_values    = $this->value();
				$total_sizes_array  = [];

				if ( ! empty( $selected_values ) ) {
					$selected_values   = explode( ',', $selected_values );
					$total_sizes_array = array_filter(
						$default_array_filp,
						function ( $value ) use ( $selected_values ) {
							return in_array( $value, $selected_values, true );
						}
					);
				}

				$litho_all_sizes_array = array_unique( $total_sizes_array );
				$litho_sizes_string    = implode( ',', $litho_all_sizes_array );
				?>
				<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
				<select class="customize-control-select2" name="multi-select2[]" <?php $this->link(); ?> multiple="multiple" data-selected="<?php echo esc_attr( $litho_sizes_string ); ?>">
					<?php
					foreach ( $default_array_filp as $key => $value ) {
						$selected = in_array( $value, $litho_all_sizes_array, true ) ? 'selected="selected"' : '';
						echo '<option value="' . esc_attr( $value ) . '" ' . $selected . '>' . esc_html( $key ) . '</option>'; // phpcs:ignore
					}
					?>
				</select>
				<?php
			}
		}
	}
}