<?php
namespace LithoAddons\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;  // Exit if accessed directly.
}

use Elementor\Widget_Base;
use Elementor\Plugin;
use Elementor\Controls_Manager;
use LithoAddons\Classes\Elementor_Templates;

/**
 *
 * Litho widget for Template.
 *
 * @package Litho
 */

// If class `Template` doesn't exists yet.
if ( ! class_exists( 'LithoAddons\Widgets\Template' ) ) {
	/**
	 * Define `Template` class.
	 */
	class Template extends Widget_Base {

		/**
		 * Get widget name.
		 *
		 * Retrieve Template widget name.
		 *
		 * @access public
		 *
		 * @return string Widget name.
		 */
		public function get_name() {
			return 'litho-template';
		}

		/**
		 * Get widget title.
		 *
		 * Retrieve Template widget title.
		 *
		 * @access public
		 *
		 * @return string Widget title.
		 */
		public function get_title() {
			return esc_html__( 'Litho Template', 'litho-addons' );
		}

		/**
		 * Get widget icon.
		 *
		 * Retrieve Template widget icon.
		 *
		 * @access public
		 *
		 * @return string Widget icon.
		 */
		public function get_icon() {
			return 'eicon-document-file litho-element-icon';
		}

		/**
		 * Retrieve the widget categories.
		 *
		 * @access public
		 *
		 * @return string Widget categories.
		 */
		public function get_categories() {
			return [
				'litho',
			];
		}

		/**
		 * Get widget keywords.
		 *
		 * Retrieve the list of keywords the widget belongs to.
		 *
		 * @access public
		 *
		 * @return array Widget keywords.
		 */
		public function get_keywords() {
			return [
				'elementor',
				'template',
				'library',
				'block',
				'page',
			];
		}

		/**
		 * Register Template widget controls.
		 *
		 * Adds different input fields to allow the user to change and customize the widget settings.
		 *
		 * @access protected
		 */
		protected function register_controls() {
			$this->start_controls_section(
				'litho_section_assistant_general',
				[
					'label' => esc_html__( 'Template', 'litho-addons' ),
				]
			);
			$this->add_control(
				'litho_item_template_id',
				[
					'label'       => esc_html__( 'Choose Template', 'litho-addons' ),
					'label_block' => true,
					'type'        => Controls_Manager::SELECT2,
					'default'     => '0',
					'options'     => Elementor_Templates::get_elementor_templates_options(),
				]
			);
			$this->end_controls_section();
		}

		/**
		 * Render Template widget output on the frontend.
		 *
		 * Written in PHP and used to generate the final HTML.
		 *
		 * @since 1.0.0
		 * @access protected
		 */
		protected function render() {

			$settings = $this->get_settings_for_display();
			if ( '0' !== $settings['litho_item_template_id'] ) {
				$template_content = \Litho_Addons_Extra_Functions::litho_get_builder_content_for_display( $settings['litho_item_template_id'] );
				if ( ! empty( $template_content ) ) {
					if ( Plugin::$instance->editor->is_edit_mode() ) {
						$edit_url = add_query_arg(
							array(
								'elementor' => '',
							),
							get_permalink( $settings['litho_item_template_id'] )
						);
						echo sprintf( '<div class="edit-template-with-light-box elementor-template-edit-cover" data-template-edit-link="%s"><i aria-hidden="true" class="eicon-edit"></i><span>%s</span></div>', esc_url( $edit_url ), esc_html__( 'Edit Template', 'litho-addons' ) ); // phpcs:ignore.
					}
					echo sprintf( '%s', $template_content ); // phpcs:ignore
				} else {
					echo sprintf( '%s', no_template_content_message() ); // phpcs:ignore
				}
			} else {
				echo sprintf( '%s', no_template_content_message() ); // phpcs:ignore
			}
		}
	}
}
