<?php
/**
 * Perfomance Settings.
 *
 * @package Litho
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/* Remove URL Query Strings */
$wp_customize->add_setting(
	'litho_perfomance_url_query_string_sep',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_attr',
	),
);

$wp_customize->add_control(
	new Litho_Customize_Separator_Control(
		$wp_customize,
		'litho_perfomance_url_query_string_sep',
		array(
			'label'       => esc_html__( 'Remove URL Query Strings', 'litho' ),
			'type'        => 'litho_separator',
			'section'     => 'litho_perfomance_general_settings_section',
			'settings'    => 'litho_perfomance_url_query_string_sep',
			'description' => esc_html__( 'Some proxy caching servers and even CDNs are unable to cache static content with query strings, resulting in a significant missed opportunity for improved performance.', 'litho' ),
		),
	),
);

$wp_customize->add_setting(
	'litho_remove_url_query_string',
	array(
		'default'           => '0',
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	new Litho_Customize_Switch_Control(
		$wp_customize,
		'litho_remove_url_query_string',
		array(
			'label'       => esc_html__( 'Remove Query Strings From Assets', 'litho' ),
			'section'     => 'litho_perfomance_general_settings_section',
			'settings'    => 'litho_remove_url_query_string',
			'description' => esc_html__( 'Switch ON to remove query strings from assets URL.', 'litho' ),
			'type'        => 'litho_switch',
			'choices'     => array(
				'1' => esc_html__( 'On', 'litho' ),
				'0' => esc_html__( 'Off', 'litho' ),
			),
		)
	)
);

/* End Remove URL Query Strings */

/* Post Revisions Limit */
$wp_customize->add_setting(
	'litho_perfomance_post_revision_sep',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	),
);

$wp_customize->add_control(
	new Litho_Customize_Separator_Control(
		$wp_customize,
		'litho_perfomance_post_revision_sep',
		array(
			'label'       => esc_html__( 'Post Revisions Limit', 'litho' ),
			'type'        => 'litho_separator',
			'section'     => 'litho_perfomance_general_settings_section',
			'settings'    => 'litho_perfomance_post_revision_sep',
			'description' => esc_html__( 'WordPress post revisions track and keep all content edits, making it easier to compare, restore, and collaborate by saving each change.', 'litho' ),
		),
	),
);

$wp_customize->add_setting(
	'litho_post_revisions',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'litho_post_revisions',
	array(
		'label'       => esc_html__( 'Post Revisions', 'litho' ),
		'section'     => 'litho_perfomance_general_settings_section',
		'settings'    => 'litho_post_revisions',
		'type'        => 'text',
		'description' => esc_html__( 'Limit revisions to any number by entering it here, or disable revisions by entering "0" or leave empty field.', 'litho' ),
	)
);
/* Post Revisions Limit */

/* WordPress Image Quality Settings */
$wp_customize->add_setting(
	'litho_perfomance_jpeg_quality_sep',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_attr',
	),
);
$wp_customize->add_control(
	new Litho_Customize_Separator_Control(
		$wp_customize,
		'litho_perfomance_jpeg_quality_sep',
		array(
			'label'       => esc_html__( 'WordPress Image Quality', 'litho' ),
			'type'        => 'litho_separator',
			'section'     => 'litho_perfomance_general_settings_section',
			'settings'    => 'litho_perfomance_jpeg_quality_sep',
			'description' => sprintf(
				'%1$s <i><strong>%2$s <a target="_blank" href="%3$s" rel="noopener noreferrer">%4$s</a> %5$s </strong></i>',
				esc_html__( 'Controls the quality of the generated image sizes for every uploaded image. Ranges between 0 and 100 percent. Higher values lead to better image qualities but also higher file sizes.', 'litho' ),
				esc_html__( 'NOTE: After changing this value, please install and run the', 'litho' ),
				esc_url( network_admin_url( 'plugin-install.php?s=Regenerate+Thumbnails&tab=search&type=term' ) ),
				esc_html__( 'Regenerate Thumbnails', 'litho' ),
				esc_html__( 'plugin once.', 'litho' ),
			),
		),
	),
);

$wp_customize->add_setting(
	'litho_jpg_image_quality',
	array(
		'default'           => '',
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'litho_jpg_image_quality',
	array(
		'label'       => esc_html__( 'WordPress Image Quality', 'litho' ),
		'section'     => 'litho_perfomance_general_settings_section',
		'settings'    => 'litho_jpg_image_quality',
		'type'        => 'number',
		'description' => esc_html__( 'JPEG quality levels range from 0 (low) to 100 (high).', 'litho' ),
		'input_attrs' => array(
			'min' => 0,
			'max' => 100,
		),
	)
);
/* End WordPress Image Quality Settings */

/* WordPress Big Image Size Threshold */
$wp_customize->add_setting(
	'litho_perfomance_image_size_threshold_sep',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_attr',
	),
);
$wp_customize->add_control(
	new Litho_Customize_Separator_Control(
		$wp_customize,
		'litho_perfomance_image_size_threshold_sep',
		array(
			'label'    => esc_html__( 'WordPress Big Image Size Threshold', 'litho' ),
			'type'     => 'litho_separator',
			'section'  => 'litho_perfomance_general_settings_section',
			'settings' => 'litho_perfomance_image_size_threshold_sep',
		),
	),
);

$wp_customize->add_setting(
	'litho_big_image_size_threshold',
	array(
		'default'           => 2560,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'litho_big_image_size_threshold',
	array(
		'label'       => esc_html__( 'WordPress Big Image Size Threshold', 'litho' ),
		'section'     => 'litho_perfomance_general_settings_section',
		'settings'    => 'litho_big_image_size_threshold',
		'type'        => 'number',
		'description' => esc_html__( 'Sets the threshold for image height and width, above which WordPress will scale down newly uploaded images to this values as max-width or max-height. Set to "0" to disable the threshold completely.', 'litho' ),
		'input_attrs' => array(
			'min'  => 0,
			'max'  => 5000,
			'step' => 1,
		),
	)
);
/* End WordPress Big Image Size Threshold */

/* Litho Image Sizes Separator */
$wp_customize->add_setting(
	'litho_perfomance_image_size_sep',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_attr',
	),
);
$wp_customize->add_control(
	new Litho_Customize_Separator_Control(
		$wp_customize,
		'litho_perfomance_image_size_sep',
		array(
			'label'       => esc_html__( 'Litho Image Sizes', 'litho' ),
			'type'        => 'litho_separator',
			'section'     => 'litho_perfomance_general_settings_section',
			'settings'    => 'litho_perfomance_image_size_sep',
			'description' => sprintf(
				'%1$s <i><strong> %2$s <a target="_blank" href="%3$s" rel="noopener noreferrer">%4$s</a> %5$s</strong></i>',
				esc_html__( 'Choose the Litho image sizes that should be created for each image that is uploaded to the media library.', 'litho' ),
				esc_html__( 'NOTE: When you remove image sizes here, please check your site to make sure all layouts display correctly. After changing this value, please install and run the ', 'litho' ),
				esc_url( network_admin_url( 'plugin-install.php?s=Regenerate+Thumbnails&tab=search&type=term' ) ),
				esc_html__( 'Regenerate Thumbnails', 'litho' ),
				esc_html__( 'plugin once.', 'litho' ),
			),
		),
	),
);
/* Add setting for Image sizes */

$wp_customize->add_setting(
	'litho_custom_image_sizes',
	array(
		'default'           => '',
		'sanitize_callback' => 'litho_sanitize_image_size_callback',
	)
);

$custom_image_array = array(
	'litho-popular-posts-thumb' => esc_html__( 'Litho Popular Posts Thumb(200xAuto)', 'litho' ),
);

/**
 * Filters to modify custom image sizes.
 *
 * @since 1.0
 */
$custom_image_sizes = apply_filters( 'litho_image_sizes', $custom_image_array );

/* Add control for enable image sizes */
$wp_customize->add_control(
	new Litho_Customize_Multi_Select_Control(
		$wp_customize,
		'litho_custom_image_sizes',
		array(
			'label'    => esc_html__( 'Litho Image Sizes', 'litho' ),
			'section'  => 'litho_perfomance_general_settings_section',
			'settings' => 'litho_custom_image_sizes',
			'type'     => 'select2-multiple',
			'choices'  => $custom_image_sizes, // phpcs:ignore
		)
	)
);
if ( ! function_exists( 'litho_sanitize_image_size_callback' ) ) {
	/**
	 * Callback functions.
	 *
	 * Exolode array value
	 *
	 * @since 1.0
	 * @param object $value Customizer data.
	 * @access public
	 */
	function litho_sanitize_image_size_callback( $value ) {
		if ( is_array( $value ) ) {
			return implode( ',', array_map( 'sanitize_text_field', $value ) );
		}
		return sanitize_text_field( $value );
	}
}

/* Disable Gutenberg Styles Settings */
$wp_customize->add_setting(
	'litho_perfomance_disable_styles_separator',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_attr',
	),
);

$wp_customize->add_control(
	new Litho_Customize_Separator_Control(
		$wp_customize,
		'litho_perfomance_disable_styles_separator',
		array(
			'label'       => esc_html__( 'Disable Gutenberg Styles', 'litho' ),
			'type'        => 'litho_separator',
			'section'     => 'litho_perfomance_gutenberg_section',
			'settings'    => 'litho_perfomance_disable_styles_separator',
			'description' => esc_html__( 'Select items to disable to load the default styles of Gutenberg block libraries.', 'litho' ),
		),
	),
);

$wp_customize->add_setting(
	'litho_disable_gutenberg_styles',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_attr',
	),
);

$litho_gutenberg_styles = array(
	'wp-block-library'       => esc_html__( 'Gutenberg Library', 'litho' ),
	'wp-block-library-theme' => esc_html__( 'Gutenberg Library Theme', 'litho' ),
);

if ( is_woocommerce_activated() ) {
	$litho_gutenberg_styles['wc-blocks-style'] = esc_html__( 'Gutenberg Woocommerce', 'litho' );
}

$wp_customize->add_control(
	new Litho_Customize_Checkbox_Multiple(
		$wp_customize,
		'litho_disable_gutenberg_styles',
		array(
			'label'    => esc_html__( 'Disable Styles', 'litho' ),
			'section'  => 'litho_perfomance_gutenberg_section',
			'settings' => 'litho_disable_gutenberg_styles',
			'type'     => 'litho_checkbox_multiple',
			'choices'  => $litho_gutenberg_styles, // phpcs:ignore
		),
	),
);

/* End Disable gutenberg styles Setting */

/* Global Inline CSS */

$wp_customize->add_setting(
	'litho_enable_remove_global_styles_separator',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_attr',
	),
);

$wp_customize->add_control(
	new Litho_Customize_Separator_Control(
		$wp_customize,
		'litho_enable_remove_global_styles_separator',
		array(
			'label'    => esc_html__( 'Global Inline CSS', 'litho' ),
			'type'     => 'litho_separator',
			'section'  => 'litho_perfomance_gutenberg_section',
			'settings' => 'litho_enable_remove_global_styles_separator',
		),
	),
);

$wp_customize->add_setting(
	'litho_enable_remove_global_styles',
	array(
		'default'           => '0',
		'sanitize_callback' => 'esc_attr',
	)
);

$wp_customize->add_control(
	new Litho_Customize_Switch_Control(
		$wp_customize,
		'litho_enable_remove_global_styles',
		array(
			'label'       => esc_html__( 'Disable Gutenberg Inline CSS', 'litho' ),
			'section'     => 'litho_perfomance_gutenberg_section',
			'settings'    => 'litho_enable_remove_global_styles',
			'description' => esc_html__( 'Switch ON to disable the Gutenberg inline CSS to load.', 'litho' ),
			'type'        => 'litho_switch',
			'choices'     => array(
				'1' => esc_html__( 'On', 'litho' ),
				'0' => esc_html__( 'Off', 'litho' ),
			),
		)
	)
);

/* End Global Inline CSS */

/* Add Third Party Pligins */

if ( is_woocommerce_activated() ) {

	/* Disable cart fragments */
	$wp_customize->add_setting(
		'litho_cart_fragments_separator',
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_attr',
		),
	);

	$wp_customize->add_control(
		new Litho_Customize_Separator_Control(
			$wp_customize,
			'litho_cart_fragments_separator',
			array(
				'label'       => esc_html__( 'Disable Cart Fragments', 'litho' ),
				'type'        => 'litho_separator',
				'section'     => 'litho_add_perfomance_plugin_section',
				'settings'    => 'litho_cart_fragments_separator',
				'description' => esc_html__( 'WooCommerce uses ajax calls to update cart totals without refreshing the page. These ajax calls run on every page and can significantly increase page load times. We recommend disabling cart fragments on all non-WooCommerce pages.', 'litho' ),

			),
		),
	);

	$wp_customize->add_setting(
		'litho_disable_cart_fragments',
		array(
			'default'           => '0',
			'sanitize_callback' => 'esc_attr',
		)
	);

	$wp_customize->add_control(
		new Litho_Customize_Switch_Control(
			$wp_customize,
			'litho_disable_cart_fragments',
			array(
				'label'       => esc_html__( 'Disable Cart Fragments', 'litho' ),
				'section'     => 'litho_add_perfomance_plugin_section',
				'settings'    => 'litho_disable_cart_fragments',
				'type'        => 'litho_switch',
				'choices'     => array(
					'1' => esc_html__( 'On', 'litho' ),
					'0' => esc_html__( 'Off', 'litho' ),
				),
				'description' => sprintf(
					'%1$s <a target="_blank" href="%2$s">%3$s</a> %4$s',
					esc_html__( 'Switch ON to disable the cart fragments. After disabling cart fragments, be sure to enable the', 'litho' ),
					esc_url( admin_url( 'admin.php?page=wc-settings&tab=products' ) ),
					esc_html__( 'Redirect to the cart page after successful addition', 'litho' ),
					esc_html__( 'option in your Woocommerce settings to redirect your customers to the main cart page instead of waiting for an item to be added to the cart.', 'litho' ),
				),
			)
		)
	);
	/* End Disable cart fragments settings */

}
if ( is_elementor_activated() ) {
	/* Elementor Icons CSS */

	$wp_customize->add_setting(
		'litho_perfomance_icon_css_separator',
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_attr',
		),
	);

	$wp_customize->add_control(
		new Litho_Customize_Separator_Control(
			$wp_customize,
			'litho_perfomance_icon_css_separator',
			array(
				'label'    => esc_html__( 'Elementor Icons CSS', 'litho' ),
				'type'     => 'litho_separator',
				'section'  => 'litho_add_perfomance_plugin_section',
				'settings' => 'litho_perfomance_icon_css_separator',
			),
		),
	);

	$wp_customize->add_setting(
		'litho_elementor_icons_css_file',
		array(
			'default'           => '0',
			'sanitize_callback' => 'esc_attr',
		)
	);

	$wp_customize->add_control(
		new Litho_Customize_Switch_Control(
			$wp_customize,
			'litho_elementor_icons_css_file',
			array(
				'label'       => esc_html__( 'Disable Elementor Icons CSS', 'litho' ),
				'section'     => 'litho_add_perfomance_plugin_section',
				'settings'    => 'litho_elementor_icons_css_file',
				'description' => esc_html__( 'Switch ON to disable the default Elementor icons css library.', 'litho' ),
				'type'        => 'litho_switch',
				'choices'     => array(
					'1' => esc_html__( 'On', 'litho' ),
					'0' => esc_html__( 'Off', 'litho' ),
				),
			)
		)
	);

	/* End Elementor Icons CSS */
}

/* End Third Party Setting */

/* Start Bloat Remover Setting */

/* Wp emojis layout */
$wp_customize->add_setting(
	'litho_perfomance_wp_emojis_separator',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_attr',
	),
);

$wp_customize->add_control(
	new Litho_Customize_Separator_Control(
		$wp_customize,
		'litho_perfomance_wp_emojis_separator',
		array(
			'label'    => esc_html__( 'WP Emojis', 'litho' ),
			'type'     => 'litho_separator',
			'section'  => 'litho_bloat_settings_section',
			'settings' => 'litho_perfomance_wp_emojis_separator',
		),
	),
);

/* Wp emojis layout */

$wp_customize->add_setting(
	'litho_wp_emojis',
	array(
		'default'           => '0',
		'sanitize_callback' => 'esc_attr',
	)
);

$wp_customize->add_control(
	new Litho_Customize_Switch_Control(
		$wp_customize,
		'litho_wp_emojis',
		array(
			'label'       => esc_html__( 'Disable WP Emojis', 'litho' ),
			'section'     => 'litho_bloat_settings_section',
			'settings'    => 'litho_wp_emojis',
			'description' => esc_html__( 'Switch ON to disable the Emoji script (wp-emoji-release.min.js).', 'litho' ),
			'type'        => 'litho_switch',
			'choices'     => array(
				'1' => esc_html__( 'On', 'litho' ),
				'0' => esc_html__( 'Off', 'litho' ),
			),
		)
	)
);

/* End Wp emojis settings */

/* Disable XML RPC */

$wp_customize->add_setting(
	'litho_performance_disable_xmlrpc_sep',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_attr',
	),
);
$wp_customize->add_control(
	new Litho_Customize_Separator_Control(
		$wp_customize,
		'litho_performance_disable_xmlrpc_sep',
		array(
			'label'    => esc_html__( 'Disable XML RPC', 'litho' ),
			'type'     => 'litho_separator',
			'section'  => 'litho_bloat_settings_section',
			'settings' => 'litho_performance_disable_xmlrpc_sep',
		),
	),
);

$wp_customize->add_setting(
	'litho_disable_xmlrpc',
	array(
		'default'           => '0',
		'sanitize_callback' => 'esc_attr',
	)
);

$wp_customize->add_control(
	new Litho_Customize_Switch_Control(
		$wp_customize,
		'litho_disable_xmlrpc',
		array(
			'label'       => esc_html__( 'Disable XML RPC', 'litho' ),
			'section'     => 'litho_bloat_settings_section',
			'settings'    => 'litho_disable_xmlrpc',
			'type'        => 'litho_switch',
			'choices'     => array(
				'1' => esc_html__( 'On', 'litho' ),
				'0' => esc_html__( 'Off', 'litho' ),
			),
			'description' => esc_html__( 'Switch ON to disable WordPress XML-RPC.', 'litho' ),
		)
	)
);

/* END Disable XML RPC */

/* Litho Disable RSS Feeds */
$wp_customize->add_setting(
	'litho_performance_rss_feeds_sep',
	[
		'default'           => '',
		'sanitize_callback' => 'esc_attr',
	],
);

$wp_customize->add_control(
	new Litho_Customize_Separator_Control(
		$wp_customize,
		'litho_performance_rss_feeds_sep',
		[
			'label'    => esc_html__( 'Disable RSS Feeds', 'litho' ),
			'type'     => 'litho_separator',
			'section'  => 'litho_bloat_settings_section',
			'settings' => 'litho_performance_rss_feeds_sep',
		],
	),
);

$wp_customize->add_setting(
	'litho_disable_rss_feeds',
	[
		'default'           => '0',
		'sanitize_callback' => 'esc_attr',
	]
);

$wp_customize->add_control(
	new Litho_Customize_Switch_Control(
		$wp_customize,
		'litho_disable_rss_feeds',
		[
			'label'       => esc_html__( 'Disable RSS Feeds', 'litho' ),
			'section'     => 'litho_bloat_settings_section',
			'description' => esc_html__( 'Switch ON to disable RSS feeds.', 'litho' ),
			'settings'    => 'litho_disable_rss_feeds',
			'type'        => 'litho_switch',
			'choices'     => array(
				'1' => esc_html__( 'On', 'litho' ),
				'0' => esc_html__( 'Off', 'litho' ),
			),
		]
	)
);
/* Add setting for Disable RSS Feeds */

/* Remove RSD Link */

$wp_customize->add_setting(
	'litho_performance_remove_rsd_link_sep',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_attr',
	),
);
$wp_customize->add_control(
	new Litho_Customize_Separator_Control(
		$wp_customize,
		'litho_performance_remove_rsd_link_sep',
		array(
			'label'    => esc_html__( 'Remove WLW and RSD Link', 'litho' ),
			'type'     => 'litho_separator',
			'section'  => 'litho_bloat_settings_section',
			'settings' => 'litho_performance_remove_rsd_link_sep',
		),
	),
);

$wp_customize->add_setting(
	'litho_remove_rsd_link',
	array(
		'default'           => '0',
		'sanitize_callback' => 'esc_attr',
	)
);

$wp_customize->add_control(
	new Litho_Customize_Switch_Control(
		$wp_customize,
		'litho_remove_rsd_link',
		array(
			'label'       => esc_html__( 'Remove WLW and RSD Link', 'litho' ),
			'section'     => 'litho_bloat_settings_section',
			'settings'    => 'litho_remove_rsd_link',
			'type'        => 'litho_switch',
			'choices'     => array(
				'1' => esc_html__( 'On', 'litho' ),
				'0' => esc_html__( 'Off', 'litho' ),
			),
			'description' => esc_html__( 'Switch ON to remove WordPress WLW and RSD link.', 'litho' ),
		)
	)
);

/* END Remove RSD Link */

/* Disable jQuery Migrate */

$wp_customize->add_setting(
	'litho_performance_disable_jq_migrate_sep',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_attr',
	),
);
$wp_customize->add_control(
	new Litho_Customize_Separator_Control(
		$wp_customize,
		'litho_performance_disable_jq_migrate_sep',
		array(
			'label'       => esc_html__( 'Disable JQuery Migrate', 'litho' ),
			'type'        => 'litho_separator',
			'section'     => 'litho_bloat_settings_section',
			'settings'    => 'litho_performance_disable_jq_migrate_sep',
			'description' => esc_html__( 'If you do not use any deprecated jQuery code, you can disable this script to optimize performance.', 'litho' ),
		),
	),
);

$wp_customize->add_setting(
	'litho_disable_jq_migrate',
	array(
		'default'           => '0',
		'sanitize_callback' => 'esc_attr',
	)
);

$wp_customize->add_control(
	new Litho_Customize_Switch_Control(
		$wp_customize,
		'litho_disable_jq_migrate',
		array(
			'label'       => esc_html__( 'Disable JQuery Migrate', 'litho' ),
			'section'     => 'litho_bloat_settings_section',
			'settings'    => 'litho_disable_jq_migrate',
			'type'        => 'litho_switch',
			'choices'     => array(
				'1' => esc_html__( 'On', 'litho' ),
				'0' => esc_html__( 'Off', 'litho' ),
			),
			'description' => esc_html__( 'Switch ON to Disable jQuery Migrate for better speed.', 'litho' ),
		)
	)
);

/* END Disable jQuery Migrate */

/* Disable Dashicons Icons */

$wp_customize->add_setting(
	'litho_performance_disable_dashicons_sep',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_attr',
	),
);
$wp_customize->add_control(
	new Litho_Customize_Separator_Control(
		$wp_customize,
		'litho_performance_disable_dashicons_sep',
		array(
			'label'    => esc_html__( 'Disable Dashicons', 'litho' ),
			'type'     => 'litho_separator',
			'section'  => 'litho_bloat_settings_section',
			'settings' => 'litho_performance_disable_dashicons_sep',
		),
	),
);

$wp_customize->add_setting(
	'litho_disable_dashicons',
	array(
		'default'           => '0',
		'sanitize_callback' => 'esc_attr',
	)
);

$wp_customize->add_control(
	new Litho_Customize_Switch_Control(
		$wp_customize,
		'litho_disable_dashicons',
		array(
			'label'       => esc_html__( 'Disable Dashicons', 'litho' ),
			'section'     => 'litho_bloat_settings_section',
			'settings'    => 'litho_disable_dashicons',
			'type'        => 'litho_switch',
			'choices'     => array(
				'1' => esc_html__( 'On', 'litho' ),
				'0' => esc_html__( 'Off', 'litho' ),
			),
			'description' => esc_html__( 'Switch ON to disable dashicons which are used on WordPress admin and might not be used on frontend.', 'litho' ),
		)
	)
);

/* END Disable Dashicons */

/* Disable Self Pings */
$wp_customize->add_setting(
	'litho_performance_disable_self_pings_sep',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_attr',
	),
);
$wp_customize->add_control(
	new Litho_Customize_Separator_Control(
		$wp_customize,
		'litho_performance_disable_self_pings_sep',
		array(
			'label'    => esc_html__( 'Disable Self Pings', 'litho' ),
			'type'     => 'litho_separator',
			'section'  => 'litho_bloat_settings_section',
			'settings' => 'litho_performance_disable_self_pings_sep',
		),
	),
);

$wp_customize->add_setting(
	'litho_disable_self_pings',
	array(
		'default'           => '0',
		'sanitize_callback' => 'esc_attr',
	)
);

$wp_customize->add_control(
	new Litho_Customize_Switch_Control(
		$wp_customize,
		'litho_disable_self_pings',
		array(
			'label'       => esc_html__( 'Disable Self Pingbacks', 'litho' ),
			'section'     => 'litho_bloat_settings_section',
			'settings'    => 'litho_disable_self_pings',
			'type'        => 'litho_switch',
			'choices'     => array(
				'1' => esc_html__( 'On', 'litho' ),
				'0' => esc_html__( 'Off', 'litho' ),
			),
			'description' => esc_html__( 'Switch ON to disable self pingbacks from the website.', 'litho' ),
		)
	)
);

/* END Disable Self Pings */

/* Remove Shortlink */

$wp_customize->add_setting(
	'litho_performance_remove_shortlink_sep',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_attr',
	),
);
$wp_customize->add_control(
	new Litho_Customize_Separator_Control(
		$wp_customize,
		'litho_performance_remove_shortlink_sep',
		array(
			'label'    => esc_html__( 'Remove Shortlink', 'litho' ),
			'type'     => 'litho_separator',
			'section'  => 'litho_bloat_settings_section',
			'settings' => 'litho_performance_remove_shortlink_sep',
		),
	),
);

$wp_customize->add_setting(
	'litho_remove_shortlink',
	array(
		'default'           => '0',
		'sanitize_callback' => 'esc_attr',
	)
);

$wp_customize->add_control(
	new Litho_Customize_Switch_Control(
		$wp_customize,
		'litho_remove_shortlink',
		array(
			'label'       => esc_html__( 'Remove Shortlink', 'litho' ),
			'section'     => 'litho_bloat_settings_section',
			'settings'    => 'litho_remove_shortlink',
			'type'        => 'litho_switch',
			'choices'     => array(
				'1' => esc_html__( 'On', 'litho' ),
				'0' => esc_html__( 'Off', 'litho' ),
			),
			'description' => esc_html__( 'Switch ON to remove the rel=shortlink from site.', 'litho' ),
		)
	)
);

/* END Remove Shortlink */

/* Remove WordPress Version */

$wp_customize->add_setting(
	'litho_performance_remove_wp_version_sep',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_attr',
	),
);
$wp_customize->add_control(
	new Litho_Customize_Separator_Control(
		$wp_customize,
		'litho_performance_remove_wp_version_sep',
		array(
			'label'    => esc_html__( 'Remove WordPress Version', 'litho' ),
			'type'     => 'litho_separator',
			'section'  => 'litho_bloat_settings_section',
			'settings' => 'litho_performance_remove_wp_version_sep',
		),
	),
);

$wp_customize->add_setting(
	'litho_remove_wp_version_generator',
	array(
		'default'           => '0',
		'sanitize_callback' => 'esc_attr',
	)
);

$wp_customize->add_control(
	new Litho_Customize_Switch_Control(
		$wp_customize,
		'litho_remove_wp_version_generator',
		array(
			'label'       => esc_html__( 'Remove WordPress Version', 'litho' ),
			'section'     => 'litho_bloat_settings_section',
			'settings'    => 'litho_remove_wp_version_generator',
			'type'        => 'litho_switch',
			'choices'     => array(
				'1' => esc_html__( 'On', 'litho' ),
				'0' => esc_html__( 'Off', 'litho' ),
			),
			'description' => esc_html__( 'Switch ON to remove the WordPress version generator from the site.', 'litho' ),
		)
	)
);

/* END Remove WordPress Version */

/* Control Heartbeat API */

$wp_customize->add_setting(
	'litho_performance_control_heartbeat_sep',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_attr',
	),
);
$wp_customize->add_control(
	new Litho_Customize_Separator_Control(
		$wp_customize,
		'litho_performance_control_heartbeat_sep',
		array(
			'label'    => esc_html__( 'Control Heartbeat API', 'litho' ),
			'type'     => 'litho_separator',
			'section'  => 'litho_bloat_settings_section',
			'settings' => 'litho_performance_control_heartbeat_sep',
		),
	),
);

$wp_customize->add_setting(
	'litho_control_heartbeat',
	array(
		'default'           => '0',
		'sanitize_callback' => 'esc_attr',
	)
);

$wp_customize->add_control(
	new Litho_Customize_Switch_Control(
		$wp_customize,
		'litho_control_heartbeat',
		array(
			'label'       => esc_html__( 'Enable Control Heartbeat API', 'litho' ),
			'section'     => 'litho_bloat_settings_section',
			'settings'    => 'litho_control_heartbeat',
			'type'        => 'litho_switch',
			'choices'     => array(
				'1' => esc_html__( 'On', 'litho' ),
				'0' => esc_html__( 'Off', 'litho' ),
			),
			'description' => esc_html__( 'Switch ON to control heartbeat API.', 'litho' ),
		)
	)
);

$wp_customize->add_setting(
	'litho_heartbeat_interval',
	array(
		'default'           => '60',
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	'litho_heartbeat_interval',
	array(
		'label'           => esc_html__( 'Set Heartbeat Frequency', 'litho' ),
		'section'         => 'litho_bloat_settings_section',
		'settings'        => 'litho_heartbeat_interval',
		'type'            => 'number',
		'input_attrs'     => array(
			'min' => 15,
			'max' => 120,
		),
		'active_callback' => 'litho_control_heartbeat',
	)
);

/* END Control Heartbeat API */

// Callback functions.
if ( ! function_exists( 'litho_control_heartbeat' ) ) {
	/**
	 * Callback functions.
	 *
	 * Initializing the Elementor modules manager.
	 *
	 * @since 1.0
	 * @param object $control Customizer data.
	 * @access public
	 */
	function litho_control_heartbeat( $control ) {
		if ( '1' === $control->manager->get_setting( 'litho_control_heartbeat' )->value() ) {
			return true;
		} else {
			return false;
		}
	}
}
/* End Bloat Remover Setting */

/* Start Advanced Setting */

/* Prefetch DNS Requests */
$wp_customize->add_setting(
	'litho_perfomance_prefetch_separator',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_attr',
	),
);

$wp_customize->add_control(
	new Litho_Customize_Separator_Control(
		$wp_customize,
		'litho_perfomance_prefetch_separator',
		array(
			'label'       => esc_html__( 'Prefetch DNS Requests', 'litho' ),
			'type'        => 'litho_separator',
			'section'     => 'litho_advanced_settings_section',
			'settings'    => 'litho_perfomance_prefetch_separator',
			'description' => esc_html__( 'Speeds up web pages by pre-resolving DNS. In essence it tells a browser it should resolve the DNS of a specific domain prior to it being explicitly called – very useful if you use third party services. Add hosts with no http or https. e.g. //fonts.googleapis.com.', 'litho' ),
		),
	),
);

$wp_customize->add_setting(
	'litho_prefetch_dns_urls',
	array(
		'default'           => '',
		'sanitize_callback' => 'wp_kses',
	)
);

$wp_customize->add_control(
	new Litho_Customizer_Prefetch_Url(
		$wp_customize,
		'litho_prefetch_dns_urls',
		array(
			'label'   => esc_html__( 'Prefetch DNS Requests', 'litho' ),
			'type'    => 'textarea',
			'section' => 'litho_advanced_settings_section',
		)
	)
);

/* End Prefetch DNS Requests */


/* Preconnect */
$wp_customize->add_setting(
	'litho_perfomance_preconnect_separator',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_attr',
	),
);

$wp_customize->add_control(
	new Litho_Customize_Separator_Control(
		$wp_customize,
		'litho_perfomance_preconnect_separator',
		array(
			'label'       => esc_html__( 'Preconnect 3rd Party Domains', 'litho' ),
			'type'        => 'litho_separator',
			'section'     => 'litho_advanced_settings_section',
			'settings'    => 'litho_perfomance_preconnect_separator',
			'description' => esc_html__( 'If you load resources from other domains, using Preconnect can provide a faster page loading experience for your users. It tells the browser to set up early connections before an HTTP request is actually sent to your server., and includes DNS lookup, TCP handshake, TLS negotiation, etc. Add hosts with no http or https. e.g. //cdn.google.com.', 'litho' ),
		),
	),
);

$wp_customize->add_setting(
	'litho_preconnect_urls',
	array(
		'default'           => '',
		'sanitize_callback' => 'wp_kses',
	)
);

$wp_customize->add_control(
	new Litho_Customizer_Preconnect_Domain(
		$wp_customize,
		'litho_preconnect_urls',
		array(
			'label'   => esc_html__( 'Preconnect', 'litho' ),
			'type'    => 'textarea',
			'section' => 'litho_advanced_settings_section',
		)
	)
);

/* End Preconnect */

/* End Advanced Setting */
