<?php
namespace LithoAddons\Classes;

use Elementor\Controls_Manager;

/**
 * Register Styles & Scripts
 *
 * @package Litho
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// If class `Register_Styles_Scripts` doesn't exists yet.
if ( ! class_exists( 'LithoAddons\Classes\Register_Styles_Scripts' ) ) {

	/**
	 * Define `Register_Styles_Scripts` class
	 */
	class Register_Styles_Scripts {

		/**
		 * Constructor
		 */
		public function __construct() {
			add_action( 'elementor/frontend/after_enqueue_scripts', [ $this, 'litho_register_scripts' ], 5 );
			add_action( 'wp_enqueue_scripts', [ $this, 'litho_register_styles' ], 5 );
		}

		/**
		 * Register Scripts
		 */
		public function litho_register_scripts() {
			wp_register_script(
				'litho-addons-accordion',
				LITHO_ADDONS_INCLUDES_DIR . '/assets/js/accordion.js',
				[],
				LITHO_ADDONS_PLUGIN_VERSION,
				true
			);

			wp_register_script(
				'litho-addons-drop-cap',
				LITHO_ADDONS_INCLUDES_DIR . '/assets/js/drop-cap.js',
				[],
				LITHO_ADDONS_PLUGIN_VERSION,
				true
			);

			wp_register_script(
				'litho-addons-progressbar',
				LITHO_ADDONS_INCLUDES_DIR . '/assets/js/progressbar.js',
				[],
				LITHO_ADDONS_PLUGIN_VERSION,
				true
			);

			wp_register_script(
				'litho-addons-image-comparison',
				LITHO_ADDONS_INCLUDES_DIR . '/assets/js/images-comparison.js',
				[],
				LITHO_ADDONS_PLUGIN_VERSION,
				true
			);
		 }

		/**
		 * Register Styles
		 */
		public function litho_register_styles() {
			wp_register_style(
				'rotate-text',
				LITHO_ADDONS_INCLUDES_DIR . '/assets/css/rotate-text.css',
				[],
				LITHO_ADDONS_PLUGIN_VERSION
			);
			wp_register_style(
				'litho-addons-image-comparison',
				LITHO_ADDONS_INCLUDES_DIR . '/assets/css/images-comparison.css',
				[],
				LITHO_ADDONS_PLUGIN_VERSION
			);
		}
	}
}

new Register_Styles_Scripts();
