( function( $ ) {
    "use strict";

    var LithoAddonsInit = {
        settings: {
            selectors: {
                paragraph: 'p:first',
            },
            classes: {
                dropCap: 'elementor-drop-cap',
                dropCapLetter: 'elementor-drop-cap-letter',
            },
        },
        init: function() {
            elementorFrontend.hooks.addAction( 'frontend/element_ready/litho-drop-cap.default', LithoAddonsInit.dropCapInit );
        },
        dropCapInit: function( $scope ) {
            const selectors  = LithoAddonsInit.settings.selectors;
            const classes    = LithoAddonsInit.settings.classes;
            const $paragraph = $scope.find( selectors.paragraph );

            if ( ! $paragraph.length ) {
                return;
            }

            const $dropCap       = $( '<span>', { class: classes.dropCap } );
            const $dropCapLetter = $( '<span>', { class: classes.dropCapLetter } );
            $dropCap.append( $dropCapLetter );

            const paragraphContent = $paragraph.html().replace( /&nbsp;/g, ' ' );
            const firstLetterMatch = paragraphContent.match( /^ *([^ ] ?)/ );

            if ( ! firstLetterMatch ) {
                return;
            }

            const firstLetter        = firstLetterMatch[ 1 ];
            const trimmedFirstLetter = firstLetter.trim();

            if ( '<' === trimmedFirstLetter ) {
                return;
            }

            $dropCapLetter.text( trimmedFirstLetter );

            const restoredParagraphContent = paragraphContent
                .slice( firstLetter.length )
                .replace( /^ */, ( match ) => {
                    return new Array( match.length + 1 ).join( '&nbsp;' );
                } );

            var drop_cap_value = ( $scope.find( '.elementor-drop-cap-yes' ) );

            if ( drop_cap_value.length > 0 ) {
                $paragraph.html( restoredParagraphContent ).prepend( $dropCap );
            }
        },
    };

    $( window ).on( 'elementor/frontend/init', LithoAddonsInit.init );

})( jQuery );
