<?php
/**
 * Customizer Control: Prefetch Url
 *
 * @package Litho
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( class_exists( 'WP_Customize_Control' ) ) {

	class Litho_Customizer_Preconnect_Domain extends WP_Customize_Control {

		public $type = 'preconnect_domain';
		/**
		 * Render Preconnect Function.
		 */
		public function render_content() {
			$resources = json_decode( $this->value(), true ) ? json_decode( $this->value(), true ) : [];

			if ( empty( $resources ) ) {
				$resources = [
					[
						'url'       => '',
						'isChecked' => 0,
					],
				];
			}
			?>
			<div id="preconnect-container">
				<?php
				foreach ( $resources as $resource ) {
					?>
					<div class="preconnect-item box-item">
						<input type="text" class="preconnect-domain" value="<?php echo esc_attr( $resource['url'] ); ?>" placeholder="e.g., //fonts.googleapis.com" />
						<div class="check-crossorigin">
							<input type="checkbox" id="preconnect_domain" name="preconnect_domain" value="1" <?php checked( $resource['isChecked'], 1 ); ?> />
							<label><?php echo esc_html__( 'Crossorigin', 'litho' ); ?></label>
						</div>
						<button type="button" class="button remove-preconnect remove-text-box"><?php echo esc_html__( 'Remove', 'litho' ); ?></button>
					</div>
					<?php
				}
				?>
			</div>
			<button type="button" class="button add-preconnect add-button"><?php echo esc_html__( 'Add New', 'litho' ); ?></button>
			<textarea class="preconnect-hidden-val" <?php $this->link(); ?>>
				<?php echo esc_textarea( wp_json_encode( $resources ) ); ?>
			</textarea>
			<?php
		}
	}
}
