<?php
/**
 * Customizer Control: Prefetch Url
 *
 * @package Litho
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( class_exists( 'WP_Customize_Control' ) ) {

	class Litho_Customizer_Prefetch_Url extends WP_Customize_Control {

		public $type = 'prefetch_url';
		/**
		 * Render Prefetch Function.
		 */
		public function render_content() {
			$resources = json_decode( $this->value(), true ) ? json_decode( $this->value(), true ) : [];

			if ( empty( $resources ) ) {
				$resources = [ [ 'url' => '' ] ];
			}
			?>
			<div id="prefetch-container">
				<?php
				foreach ( $resources as $resource ) {
					?>
					<div class="prefetch-item box-item">
						<input type="text" class="prefetch-url" value="<?php echo esc_attr( $resource['url'] ); ?>" placeholder="e.g., //fonts.googleapis.com" />
						<button type="button" class="button remove-prefetch remove-text-box"><?php echo esc_html__( 'Remove', 'litho' ); ?></button>
					</div>
					<?php
				}
				?>
			</div>
			<button type="button" class="button add-prefetch add-button"><?php echo esc_html__( 'Add New', 'litho' ); ?></button>
			<textarea class="prefetch-hidden-val" <?php $this->link(); ?>>
				<?php echo esc_textarea( wp_json_encode( $resources ) ); ?>
			</textarea>
			<?php
		}
	}
}
