<?php
/**
 * Icons
 *
 * @package Litho
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'litho_et_line_icons' ) ) {
	/**
	 * Return Et Line Icons
	 */
	function litho_et_line_icons() {

		$litho_icons = array( 'icon-mobile', 'icon-laptop', 'icon-desktop', 'icon-tablicon', 'icon-phone', 'icon-document', 'icon-documents', 'icon-search', 'icon-clipboard', 'icon-newspaper', 'icon-notebook', 'icon-book-open', 'icon-browser', 'icon-calendar', 'icon-presentation', 'icon-picture', 'icon-pictures', 'icon-video', 'icon-camera', 'icon-printer', 'icon-toolbox', 'icon-briefcase', 'icon-wallicon', 'icon-gift', 'icon-bargraph', 'icon-grid', 'icon-expand', 'icon-focus', 'icon-edit', 'icon-adjustments', 'icon-ribbon', 'icon-hourglass', 'icon-lock', 'icon-megaphone', 'icon-shield', 'icon-trophy', 'icon-flag', 'icon-map', 'icon-puzzle', 'icon-baskicon', 'icon-envelope', 'icon-streiconsign', 'icon-telescope', 'icon-gears', 'icon-key', 'icon-paperclip', 'icon-attachment', 'icon-priciconags', 'icon-lightbulb', 'icon-layers', 'icon-pencil', 'icon-tools', 'icon-tools-2', 'icon-scissors', 'icon-paintbrush', 'icon-magnifying-glass', 'icon-circle-compass', 'icon-linegraph', 'icon-mic', 'icon-strategy', 'icon-beaker', 'icon-caution', 'icon-recycle', 'icon-anchor', 'icon-profile-male', 'icon-profile-female', 'icon-bike', 'icon-wine', 'icon-hotairballoon', 'icon-globe', 'icon-genius', 'icon-map-pin', 'icon-dial', 'icon-chat', 'icon-heart', 'icon-cloud', 'icon-upload', 'icon-download', 'icon-targicon', 'icon-hazardous', 'icon-piechart', 'icon-speedomiconer', 'icon-global', 'icon-compass', 'icon-lifesaver', 'icon-clock', 'icon-aperture', 'icon-quote', 'icon-scope', 'icon-alarmclock', 'icon-refresh', 'icon-happy', 'icon-sad', 'icon-facebook', 'icon-twitter', 'icon-googleplus', 'icon-rss', 'icon-tumblr', 'icon-linkedin', 'icon-dribbble' );

		return apply_filters( 'litho_et_line_icons', $litho_icons ); // phpcs:ignore
	}
}

if ( ! function_exists( 'litho_fontawesome_solid' ) ) {
	/**
	 * Return Font Awesome Solid Icons
	 */
	function litho_fontawesome_solid() {

		$litho_fa_icons_solid = array( "fa-0", "fa-1", "fa-2", "fa-3", "fa-4", "fa-5", "fa-6", "fa-7", "fa-8", "fa-9", "fa-fill-drip", "fa-arrows-to-circle", "fa-circle-chevron-right", "fa-at", "fa-trash-can", "fa-text-height", "fa-user-xmark", "fa-stethoscope", "fa-message", "fa-info", "fa-down-left-and-up-right-to-center", "fa-explosion", "fa-file-lines", "fa-wave-square", "fa-ring", "fa-building-un", "fa-dice-three", "fa-calendar-days", "fa-anchor-circle-check", "fa-building-circle-arrow-right", "fa-volleyball", "fa-arrows-up-to-line", "fa-sort-down", "fa-circle-minus", "fa-door-open", "fa-right-from-bracket", "fa-atom", "fa-soap", "fa-icons", "fa-microphone-lines-slash", "fa-bridge-circle-check", "fa-pump-medical", "fa-fingerprint", "fa-hand-point-right", "fa-magnifying-glass-location", "fa-forward-step", "fa-face-smile-beam", "fa-flag-checkered", "fa-football", "fa-school-circle-exclamation", "fa-crop", "fa-angles-down", "fa-users-rectangle", "fa-people-roof", "fa-people-line", "fa-beer-mug-empty", "fa-diagram-predecessor", "fa-arrow-up-long", "fa-fire-flame-simple", "fa-person", "fa-laptop", "fa-file-csv", "fa-menorah", "fa-truck-plane", "fa-record-vinyl", "fa-face-grin-stars", "fa-bong", "fa-spaghetti-monster-flying", "fa-arrow-down-up-across-line", "fa-spoon", "fa-jar-wheat", "fa-envelopes-bulk", "fa-file-circle-exclamation", "fa-circle-h", "fa-pager", "fa-address-book", "fa-strikethrough", "fa-k", "fa-landmark-flag", "fa-pencil", "fa-backward", "fa-caret-right", "fa-comments", "fa-paste", "fa-code-pull-request", "fa-clipboard-list", "fa-truck-ramp-box", "fa-user-check", "fa-vial-virus", "fa-sheet-plastic", "fa-blog", "fa-user-ninja", "fa-person-arrow-up-from-line", "fa-scroll-torah", "fa-broom-ball", "fa-toggle-off", "fa-box-archive", "fa-person-drowning", "fa-arrow-down-9-1", "fa-face-grin-tongue-squint", "fa-spray-can", "fa-truck-monster", "fa-w", "fa-earth-africa", "fa-rainbow", "fa-circle-notch", "fa-tablet-screen-button", "fa-paw", "fa-cloud", "fa-trowel-bricks", "fa-face-flushed", "fa-hospital-user", "fa-tent-arrow-left-right", "fa-gavel", "fa-binoculars", "fa-microphone-slash", "fa-box-tissue", "fa-motorcycle", "fa-bell-concierge", "fa-pen-ruler", "fa-people-arrows", "fa-mars-and-venus-burst", "fa-square-caret-right", "fa-scissors", "fa-sun-plant-wilt", "fa-toilets-portable", "fa-hockey-puck", "fa-table", "fa-magnifying-glass-arrow-right", "fa-tachograph-digital", "fa-users-slash", "fa-clover", "fa-reply", "fa-star-and-crescent", "fa-house-fire", "fa-square-minus", "fa-helicopter", "fa-compass", "fa-square-caret-down", "fa-file-circle-question", "fa-laptop-code", "fa-swatchbook", "fa-prescription-bottle", "fa-bars", "fa-people-group", "fa-hourglass-end", "fa-heart-crack", "fa-square-up-right", "fa-face-kiss-beam", "fa-film", "fa-ruler-horizontal", "fa-people-robbery", "fa-lightbulb", "fa-caret-left", "fa-circle-exclamation", "fa-school-circle-xmark", "fa-arrow-right-from-bracket", "fa-circle-chevron-down", "fa-unlock-keyhole", "fa-cloud-showers-heavy", "fa-headphones-simple", "fa-sitemap", "fa-circle-dollar-to-slot", "fa-memory", "fa-road-spikes", "fa-fire-burner", "fa-flag", "fa-hanukiah", "fa-feather", "fa-volume-low", "fa-comment-slash", "fa-cloud-sun-rain", "fa-compress", "fa-wheat-awn", "fa-ankh", "fa-hands-holding-child", "fa-asterisk", "fa-square-check", "fa-peseta-sign", "fa-heading", "fa-ghost", "fa-list", "fa-square-phone-flip", "fa-cart-plus", "fa-gamepad", "fa-circle-dot", "fa-face-dizzy", "fa-egg", "fa-house-medical-circle-xmark", "fa-campground", "fa-folder-plus", "fa-futbol", "fa-paintbrush", "fa-lock", "fa-gas-pump", "fa-hot-tub-person", "fa-map-location", "fa-house-flood-water", "fa-tree", "fa-bridge-lock", "fa-sack-dollar", "fa-pen-to-square", "fa-car-side", "fa-share-nodes", "fa-heart-circle-minus", "fa-hourglass-half", "fa-microscope", "fa-sink", "fa-bag-shopping", "fa-arrow-down-z-a", "fa-mitten", "fa-person-rays", "fa-users", "fa-eye-slash", "fa-flask-vial", "fa-hand", "fa-om", "fa-worm", "fa-house-circle-xmark", "fa-plug", "fa-chevron-up", "fa-hand-spock", "fa-stopwatch", "fa-face-kiss", "fa-bridge-circle-xmark", "fa-face-grin-tongue", "fa-chess-bishop", "fa-face-grin-wink", "fa-ear-deaf", "fa-road-circle-check", "fa-dice-five", "fa-square-rss", "fa-land-mine-on", "fa-i-cursor", "fa-stamp", "fa-stairs", "fa-i", "fa-hryvnia-sign", "fa-pills", "fa-face-grin-wide", "fa-tooth", "fa-v", "fa-bangladeshi-taka-sign", "fa-bicycle", "fa-staff-snake", "fa-head-side-cough-slash", "fa-truck-medical", "fa-wheat-awn-circle-exclamation", "fa-snowman", "fa-mortar-pestle", "fa-road-barrier", "fa-school", "fa-igloo", "fa-joint", "fa-angle-right", "fa-horse", "fa-q", "fa-g", "fa-notes-medical", "fa-temperature-half", "fa-dong-sign", "fa-capsules", "fa-poo-storm", "fa-face-frown-open", "fa-hand-point-up", "fa-money-bill", "fa-bookmark", "fa-align-justify", "fa-umbrella-beach", "fa-helmet-un", "fa-bullseye", "fa-bacon", "fa-hand-point-down", "fa-arrow-up-from-bracket", "fa-folder", "fa-file-waveform", "fa-radiation", "fa-chart-simple", "fa-mars-stroke", "fa-vial", "fa-gauge", "fa-wand-magic-sparkles", "fa-e", "fa-pen-clip", "fa-bridge-circle-exclamation", "fa-user", "fa-school-circle-check", "fa-dumpster", "fa-van-shuttle", "fa-building-user", "fa-square-caret-left", "fa-highlighter", "fa-key", "fa-bullhorn", "fa-globe", "fa-synagogue", "fa-person-half-dress", "fa-road-bridge", "fa-location-arrow", "fa-c", "fa-tablet-button", "fa-building-lock", "fa-pizza-slice", "fa-money-bill-wave", "fa-chart-area", "fa-house-flag", "fa-person-circle-minus", "fa-ban", "fa-camera-rotate", "fa-spray-can-sparkles", "fa-star", "fa-repeat", "fa-cross", "fa-box", "fa-venus-mars", "fa-arrow-pointer", "fa-maximize", "fa-charging-station", "fa-shapes", "fa-shuffle", "fa-person-running", "fa-mobile-retro", "fa-grip-lines-vertical", "fa-spider", "fa-hands-bound", "fa-file-invoice-dollar", "fa-plane-circle-exclamation", "fa-x-ray", "fa-spell-check", "fa-slash", "fa-computer-mouse", "fa-arrow-right-to-bracket", "fa-shop-slash", "fa-server", "fa-virus-covid-slash", "fa-shop-lock", "fa-hourglass-start", "fa-blender-phone", "fa-building-wheat", "fa-person-breastfeeding", "fa-right-to-bracket", "fa-venus", "fa-passport", "fa-heart-pulse", "fa-people-carry-box", "fa-temperature-high", "fa-microchip", "fa-crown", "fa-weight-hanging", "fa-xmarks-lines", "fa-file-prescription", "fa-weight-scale", "fa-user-group", "fa-arrow-up-a-z", "fa-chess-knight", "fa-face-laugh-squint", "fa-wheelchair", "fa-circle-arrow-up", "fa-toggle-on", "fa-person-walking", "fa-l", "fa-fire", "fa-bed-pulse", "fa-shuttle-space", "fa-face-laugh", "fa-folder-open", "fa-heart-circle-plus", "fa-code-fork", "fa-city", "fa-microphone-lines", "fa-pepper-hot", "fa-unlock", "fa-colon-sign", "fa-headset", "fa-store-slash", "fa-road-circle-xmark", "fa-user-minus", "fa-mars-stroke-up", "fa-champagne-glasses", "fa-clipboard", "fa-house-circle-exclamation", "fa-file-arrow-up", "fa-wifi", "fa-bath", "fa-underline", "fa-user-pen", "fa-signature", "fa-stroopwafel", "fa-bold", "fa-anchor-lock", "fa-building-ngo", "fa-manat-sign", "fa-not-equal", "fa-border-top-left", "fa-map-location-dot", "fa-jedi", "fa-square-poll-vertical", "fa-mug-hot", "fa-car-battery", "fa-gift", "fa-dice-two", "fa-chess-queen", "fa-glasses", "fa-chess-board", "fa-building-circle-check", "fa-person-chalkboard", "fa-mars-stroke-right", "fa-hand-back-fist", "fa-square-caret-up", "fa-cloud-showers-water", "fa-chart-bar", "fa-hands-bubbles", "fa-less-than-equal", "fa-train", "fa-eye-low-vision", "fa-crow", "fa-sailboat", "fa-window-restore", "fa-square-plus", "fa-torii-gate", "fa-frog", "fa-bucket", "fa-image", "fa-microphone", "fa-cow", "fa-caret-up", "fa-screwdriver", "fa-folder-closed", "fa-house-tsunami", "fa-square-nfi", "fa-arrow-up-from-ground-water", "fa-martini-glass", "fa-rotate-left", "fa-table-columns", "fa-lemon", "fa-head-side-mask", "fa-handshake", "fa-gem", "fa-dolly", "fa-smoking", "fa-minimize", "fa-monument", "fa-snowplow", "fa-angles-right", "fa-cannabis", "fa-circle-play", "fa-tablets", "fa-ethernet", "fa-euro-sign", "fa-chair", "fa-circle-check", "fa-circle-stop", "fa-compass-drafting", "fa-plate-wheat", "fa-icicles", "fa-person-shelter", "fa-neuter", "fa-id-badge", "fa-marker", "fa-face-laugh-beam", "fa-helicopter-symbol", "fa-universal-access", "fa-circle-chevron-up", "fa-lari-sign", "fa-volcano", "fa-person-walking-dashed-line-arrow-right", "fa-sterling-sign", "fa-viruses", "fa-square-person-confined", "fa-user-tie", "fa-arrow-down-long", "fa-tent-arrow-down-to-line", "fa-certificate", "fa-reply-all", "fa-suitcase", "fa-person-skating", "fa-filter-circle-dollar", "fa-camera-retro", "fa-circle-arrow-down", "fa-file-import", "fa-square-arrow-up-right", "fa-box-open", "fa-scroll", "fa-spa", "fa-location-pin-lock", "fa-pause", "fa-hill-avalanche", "fa-temperature-empty", "fa-bomb", "fa-registered", "fa-address-card", "fa-scale-unbalanced-flip", "fa-subscript", "fa-diamond-turn-right", "fa-burst", "fa-house-laptop", "fa-face-tired", "fa-money-bills", "fa-smog", "fa-crutch", "fa-font-awesome", "fa-cloud-arrow-up", "fa-palette", "fa-arrows-turn-right", "fa-vest", "fa-ferry", "fa-arrows-down-to-people", "fa-seedling", "fa-left-right", "fa-boxes-packing", "fa-circle-arrow-left", "fa-group-arrows-rotate", "fa-bowl-food", "fa-candy-cane", "fa-arrow-down-wide-short", "fa-cloud-bolt", "fa-text-slash", "fa-face-smile-wink", "fa-file-word", "fa-file-powerpoint", "fa-arrows-left-right", "fa-house-lock", "fa-cloud-arrow-down", "fa-children", "fa-chalkboard", "fa-user-large-slash", "fa-envelope-open", "fa-handshake-simple-slash", "fa-mattress-pillow", "fa-guarani-sign", "fa-arrows-rotate", "fa-fire-extinguisher", "fa-cruzeiro-sign", "fa-greater-than-equal", "fa-shield-halved", "fa-book-atlas", "fa-virus", "fa-envelope-circle-check", "fa-layer-group", "fa-arrows-to-dot", "fa-archway", "fa-heart-circle-check", "fa-house-chimney-crack", "fa-file-zipper", "fa-square", "fa-martini-glass-empty", "fa-couch", "fa-cedi-sign", "fa-italic", "fa-church", "fa-comments-dollar", "fa-democrat", "fa-z", "fa-person-skiing", "fa-road-lock", "fa-a", "fa-temperature-arrow-down", "fa-feather-pointed", "fa-p", "fa-snowflake", "fa-newspaper", "fa-rectangle-ad", "fa-circle-arrow-right", "fa-filter-circle-xmark", "fa-locust", "fa-sort", "fa-list-ol", "fa-person-dress-burst", "fa-money-check-dollar", "fa-bread-slice", "fa-language", "fa-face-kiss-wink-heart", "fa-filter", "fa-question", "fa-file-signature", "fa-up-down-left-right", "fa-house-chimney-user", "fa-hand-holding-heart", "fa-puzzle-piece", "fa-money-check", "fa-star-half-stroke", "fa-code", "fa-whiskey-glass", "fa-building-circle-exclamation", "fa-magnifying-glass-chart", "fa-arrow-up-right-from-square", "fa-cubes-stacked", "fa-won-sign", "fa-virus-covid", "fa-austral-sign", "fa-f", "fa-leaf", "fa-road", "fa-taxi", "fa-person-circle-plus", "fa-chart-pie", "fa-bolt-lightning", "fa-sack-xmark", "fa-file-excel", "fa-file-contract", "fa-fish-fins", "fa-building-flag", "fa-face-grin-beam", "fa-object-ungroup", "fa-poop", "fa-location-pin", "fa-kaaba", "fa-toilet-paper", "fa-helmet-safety", "fa-eject", "fa-circle-right", "fa-plane-circle-check", "fa-face-rolling-eyes", "fa-object-group", "fa-chart-line", "fa-mask-ventilator", "fa-arrow-right", "fa-signs-post", "fa-cash-register", "fa-person-circle-question", "fa-h", "fa-tarp", "fa-screwdriver-wrench", "fa-arrows-to-eye", "fa-plug-circle-bolt", "fa-heart", "fa-mars-and-venus", "fa-house-user", "fa-dumpster-fire", "fa-house-crack", "fa-martini-glass-citrus", "fa-face-surprise", "fa-bottle-water", "fa-circle-pause", "fa-toilet-paper-slash", "fa-apple-whole", "fa-kitchen-set", "fa-r", "fa-temperature-quarter", "fa-cube", "fa-bitcoin-sign", "fa-shield-dog", "fa-solar-panel", "fa-lock-open", "fa-elevator", "fa-money-bill-transfer", "fa-money-bill-trend-up", "fa-house-flood-water-circle-arrow-right", "fa-square-poll-horizontal", "fa-circle", "fa-backward-fast", "fa-recycle", "fa-user-astronaut", "fa-plane-slash", "fa-trademark", "fa-basketball", "fa-satellite-dish", "fa-circle-up", "fa-mobile-screen-button", "fa-volume-high", "fa-users-rays", "fa-wallet", "fa-clipboard-check", "fa-file-audio", "fa-burger", "fa-wrench", "fa-bugs", "fa-rupee-sign", "fa-file-image", "fa-circle-question", "fa-plane-departure", "fa-handshake-slash", "fa-book-bookmark", "fa-code-branch", "fa-hat-cowboy", "fa-bridge", "fa-phone-flip", "fa-truck-front", "fa-cat", "fa-anchor-circle-exclamation", "fa-truck-field", "fa-route", "fa-clipboard-question", "fa-panorama", "fa-comment-medical", "fa-teeth-open", "fa-file-circle-minus", "fa-tags", "fa-wine-glass", "fa-forward-fast", "fa-face-meh-blank", "fa-square-parking", "fa-house-signal", "fa-bars-progress", "fa-faucet-drip", "fa-cart-flatbed", "fa-ban-smoking", "fa-terminal", "fa-mobile-button", "fa-house-medical-flag", "fa-basket-shopping", "fa-tape", "fa-bus-simple", "fa-eye", "fa-face-sad-cry", "fa-audio-description", "fa-person-military-to-person", "fa-file-shield", "fa-user-slash", "fa-pen", "fa-tower-observation", "fa-file-code", "fa-signal", "fa-bus", "fa-heart-circle-xmark", "fa-house-chimney", "fa-window-maximize", "fa-face-frown", "fa-prescription", "fa-shop", "fa-floppy-disk", "fa-vihara", "fa-scale-unbalanced", "fa-sort-up", "fa-comment-dots", "fa-plant-wilt", "fa-diamond", "fa-face-grin-squint", "fa-hand-holding-dollar", "fa-bacterium", "fa-hand-pointer", "fa-drum-steelpan", "fa-hand-scissors", "fa-hands-praying", "fa-arrow-rotate-right", "fa-biohazard", "fa-location-crosshairs", "fa-mars-double", "fa-child-dress", "fa-users-between-lines", "fa-lungs-virus", "fa-face-grin-tears", "fa-phone", "fa-calendar-xmark", "fa-child-reaching", "fa-head-side-virus", "fa-user-gear", "fa-arrow-up-1-9", "fa-door-closed", "fa-shield-virus", "fa-dice-six", "fa-mosquito-net", "fa-bridge-water", "fa-person-booth", "fa-text-width", "fa-hat-wizard", "fa-pen-fancy", "fa-person-digging", "fa-trash", "fa-gauge-simple", "fa-book-medical", "fa-poo", "fa-quote-right", "fa-shirt", "fa-cubes", "fa-divide", "fa-tenge-sign", "fa-headphones", "fa-hands-holding", "fa-hands-clapping", "fa-republican", "fa-arrow-left", "fa-person-circle-xmark", "fa-ruler", "fa-align-left", "fa-dice-d6", "fa-restroom", "fa-j", "fa-users-viewfinder", "fa-file-video", "fa-up-right-from-square", "fa-table-cells", "fa-file-pdf", "fa-book-bible", "fa-o", "fa-suitcase-medical", "fa-user-secret", "fa-otter", "fa-person-dress", "fa-comment-dollar", "fa-business-time", "fa-table-cells-large", "fa-book-tanakh", "fa-phone-volume", "fa-hat-cowboy-side", "fa-clipboard-user", "fa-child", "fa-lira-sign", "fa-satellite", "fa-plane-lock", "fa-tag", "fa-comment", "fa-cake-candles", "fa-envelope", "fa-angles-up", "fa-paperclip", "fa-arrow-right-to-city", "fa-ribbon", "fa-lungs", "fa-arrow-up-9-1", "fa-litecoin-sign", "fa-border-none", "fa-circle-nodes", "fa-parachute-box", "fa-indent", "fa-truck-field-un", "fa-hourglass", "fa-mountain", "fa-user-doctor", "fa-circle-info", "fa-cloud-meatball", "fa-camera", "fa-square-virus", "fa-meteor", "fa-car-on", "fa-sleigh", "fa-arrow-down-1-9", "fa-hand-holding-droplet", "fa-water", "fa-calendar-check", "fa-braille", "fa-prescription-bottle-medical", "fa-landmark", "fa-truck", "fa-crosshairs", "fa-person-cane", "fa-tent", "fa-vest-patches", "fa-check-double", "fa-arrow-down-a-z", "fa-money-bill-wheat", "fa-cookie", "fa-arrow-rotate-left", "fa-hard-drive", "fa-face-grin-squint-tears", "fa-dumbbell", "fa-rectangle-list", "fa-tarp-droplet", "fa-house-medical-circle-check", "fa-person-skiing-nordic", "fa-calendar-plus", "fa-plane-arrival", "fa-circle-left", "fa-train-subway", "fa-chart-gantt", "fa-indian-rupee-sign", "fa-crop-simple", "fa-money-bill-1", "fa-left-long", "fa-dna", "fa-virus-slash", "fa-minus", "fa-chess", "fa-arrow-left-long", "fa-plug-circle-check", "fa-street-view", "fa-franc-sign", "fa-volume-off", "fa-hands-asl-interpreting", "fa-gear", "fa-droplet-slash", "fa-mosque", "fa-mosquito", "fa-star-of-david", "fa-person-military-rifle", "fa-cart-shopping", "fa-vials", "fa-plug-circle-plus", "fa-place-of-worship", "fa-grip-vertical", "fa-arrow-turn-up", "fa-u", "fa-square-root-variable", "fa-clock", "fa-backward-step", "fa-pallet", "fa-faucet", "fa-baseball-bat-ball", "fa-s", "fa-timeline", "fa-keyboard", "fa-caret-down", "fa-house-chimney-medical", "fa-temperature-three-quarters", "fa-mobile-screen", "fa-plane-up", "fa-piggy-bank", "fa-battery-half", "fa-mountain-city", "fa-coins", "fa-khanda", "fa-sliders", "fa-folder-tree", "fa-network-wired", "fa-map-pin", "fa-hamsa", "fa-cent-sign", "fa-flask", "fa-person-pregnant", "fa-wand-sparkles", "fa-ellipsis-vertical", "fa-ticket", "fa-power-off", "fa-right-long", "fa-flag-usa", "fa-laptop-file", "fa-tty", "fa-diagram-next", "fa-person-rifle", "fa-house-medical-circle-exclamation", "fa-closed-captioning", "fa-person-hiking", "fa-venus-double", "fa-images", "fa-calculator", "fa-people-pulling", "fa-n", "fa-cable-car", "fa-cloud-rain", "fa-building-circle-xmark", "fa-ship", "fa-arrows-down-to-line", "fa-download", "fa-face-grin", "fa-delete-left", "fa-eye-dropper", "fa-file-circle-check", "fa-forward", "fa-mobile", "fa-face-meh", "fa-align-center", "fa-book-skull", "fa-id-card", "fa-outdent", "fa-heart-circle-exclamation", "fa-house", "fa-calendar-week", "fa-laptop-medical", "fa-b", "fa-file-medical", "fa-dice-one", "fa-kiwi-bird", "fa-arrow-right-arrow-left", "fa-rotate-right", "fa-utensils", "fa-arrow-up-wide-short", "fa-mill-sign", "fa-bowl-rice", "fa-skull", "fa-tower-broadcast", "fa-truck-pickup", "fa-up-long", "fa-stop", "fa-code-merge", "fa-upload", "fa-hurricane", "fa-mound", "fa-toilet-portable", "fa-compact-disc", "fa-file-arrow-down", "fa-caravan", "fa-shield-cat", "fa-bolt", "fa-glass-water", "fa-oil-well", "fa-vault", "fa-mars", "fa-toilet", "fa-plane-circle-xmark", "fa-yen-sign", "fa-ruble-sign", "fa-sun", "fa-guitar", "fa-face-laugh-wink", "fa-horse-head", "fa-bore-hole", "fa-industry", "fa-circle-down", "fa-arrows-turn-to-dots", "fa-florin-sign", "fa-arrow-down-short-wide", "fa-less-than", "fa-angle-down", "fa-car-tunnel", "fa-head-side-cough", "fa-grip-lines", "fa-thumbs-down", "fa-user-lock", "fa-arrow-right-long", "fa-anchor-circle-xmark", "fa-ellipsis", "fa-chess-pawn", "fa-kit-medical", "fa-person-through-window", "fa-toolbox", "fa-hands-holding-circle", "fa-bug", "fa-credit-card", "fa-car", "fa-hand-holding-hand", "fa-book-open-reader", "fa-mountain-sun", "fa-arrows-left-right-to-line", "fa-dice-d20", "fa-truck-droplet", "fa-file-circle-xmark", "fa-temperature-arrow-up", "fa-medal", "fa-bed", "fa-square-h", "fa-podcast", "fa-temperature-full", "fa-bell", "fa-superscript", "fa-plug-circle-xmark", "fa-star-of-life", "fa-phone-slash", "fa-paint-roller", "fa-handshake-angle", "fa-location-dot", "fa-file", "fa-greater-than", "fa-person-swimming", "fa-arrow-down", "fa-droplet", "fa-eraser", "fa-earth-americas", "fa-person-burst", "fa-dove", "fa-battery-empty", "fa-socks", "fa-inbox", "fa-section", "fa-gauge-high", "fa-envelope-open-text", "fa-hospital", "fa-wine-bottle", "fa-chess-rook", "fa-bars-staggered", "fa-dharmachakra", "fa-hotdog", "fa-person-walking-with-cane", "fa-drum", "fa-ice-cream", "fa-heart-circle-bolt", "fa-fax", "fa-paragraph", "fa-check-to-slot", "fa-star-half", "fa-boxes-stacked", "fa-link", "fa-ear-listen", "fa-tree-city", "fa-play", "fa-font", "fa-rupiah-sign", "fa-magnifying-glass", "fa-table-tennis-paddle-ball", "fa-person-dots-from-line", "fa-trash-can-arrow-up", "fa-naira-sign", "fa-cart-arrow-down", "fa-walkie-talkie", "fa-file-pen", "fa-receipt", "fa-square-pen", "fa-suitcase-rolling", "fa-person-circle-exclamation", "fa-chevron-down", "fa-battery-full", "fa-skull-crossbones", "fa-code-compare", "fa-list-ul", "fa-school-lock", "fa-tower-cell", "fa-down-long", "fa-ranking-star", "fa-chess-king", "fa-person-harassing", "fa-brazilian-real-sign", "fa-landmark-dome", "fa-arrow-up", "fa-tv", "fa-shrimp", "fa-list-check", "fa-jug-detergent", "fa-circle-user", "fa-user-shield", "fa-wind", "fa-car-burst", "fa-y", "fa-person-snowboarding", "fa-truck-fast", "fa-fish", "fa-user-graduate", "fa-circle-half-stroke", "fa-clapperboard", "fa-circle-radiation", "fa-baseball", "fa-jet-fighter-up", "fa-diagram-project", "fa-copy", "fa-volume-xmark", "fa-hand-sparkles", "fa-grip", "fa-share-from-square", "fa-child-combatant", "fa-gun", "fa-square-phone", "fa-plus", "fa-expand", "fa-computer", "fa-xmark", "fa-arrows-up-down-left-right", "fa-chalkboard-user", "fa-peso-sign", "fa-building-shield", "fa-baby", "fa-users-line", "fa-quote-left", "fa-tractor", "fa-trash-arrow-up", "fa-arrow-down-up-lock", "fa-lines-leaning", "fa-ruler-combined", "fa-copyright", "fa-equals", "fa-blender", "fa-teeth", "fa-shekel-sign", "fa-map", "fa-rocket", "fa-photo-film", "fa-folder-minus", "fa-store", "fa-arrow-trend-up", "fa-plug-circle-minus", "fa-sign-hanging", "fa-bezier-curve", "fa-bell-slash", "fa-tablet", "fa-school-flag", "fa-fill", "fa-angle-up", "fa-drumstick-bite", "fa-holly-berry", "fa-chevron-left", "fa-bacteria", "fa-hand-lizard", "fa-notdef", "fa-disease", "fa-briefcase-medical", "fa-genderless", "fa-chevron-right", "fa-retweet", "fa-car-rear", "fa-pump-soap", "fa-video-slash", "fa-battery-quarter", "fa-radio", "fa-baby-carriage", "fa-traffic-light", "fa-thermometer", "fa-vr-cardboard", "fa-hand-middle-finger", "fa-percent", "fa-truck-moving", "fa-glass-water-droplet", "fa-display", "fa-face-smile", "fa-thumbtack", "fa-trophy", "fa-person-praying", "fa-hammer", "fa-hand-peace", "fa-rotate", "fa-spinner", "fa-robot", "fa-peace", "fa-gears", "fa-warehouse", "fa-arrow-up-right-dots", "fa-splotch", "fa-face-grin-hearts", "fa-dice-four", "fa-sim-card", "fa-transgender", "fa-mercury", "fa-arrow-turn-down", "fa-person-falling-burst", "fa-award", "fa-ticket-simple", "fa-building", "fa-angles-left", "fa-qrcode", "fa-clock-rotate-left", "fa-face-grin-beam-sweat", "fa-file-export", "fa-shield", "fa-arrow-up-short-wide", "fa-house-medical", "fa-golf-ball-tee", "fa-circle-chevron-left", "fa-house-chimney-window", "fa-pen-nib", "fa-tent-arrow-turn-left", "fa-tents", "fa-wand-magic", "fa-dog", "fa-carrot", "fa-moon", "fa-wine-glass-empty", "fa-cheese", "fa-yin-yang", "fa-music", "fa-code-commit", "fa-temperature-low", "fa-person-biking", "fa-broom", "fa-shield-heart", "fa-gopuram", "fa-earth-oceania", "fa-square-xmark", "fa-hashtag", "fa-up-right-and-down-left-from-center", "fa-oil-can", "fa-t", "fa-hippo", "fa-chart-column", "fa-infinity", "fa-vial-circle-check", "fa-person-arrow-down-to-line", "fa-voicemail", "fa-fan", "fa-person-walking-luggage", "fa-up-down", "fa-cloud-moon-rain", "fa-calendar", "fa-trailer", "fa-bahai", "fa-sd-card", "fa-dragon", "fa-shoe-prints", "fa-circle-plus", "fa-face-grin-tongue-wink", "fa-hand-holding", "fa-plug-circle-exclamation", "fa-link-slash", "fa-clone", "fa-person-walking-arrow-loop-left", "fa-arrow-up-z-a", "fa-fire-flame-curved", "fa-tornado", "fa-file-circle-plus", "fa-book-quran", "fa-anchor", "fa-border-all", "fa-face-angry", "fa-cookie-bite", "fa-arrow-trend-down", "fa-rss", "fa-draw-polygon", "fa-scale-balanced", "fa-gauge-simple-high", "fa-shower", "fa-desktop", "fa-m", "fa-table-list", "fa-comment-sms", "fa-book", "fa-user-plus", "fa-check", "fa-battery-three-quarters", "fa-house-circle-check", "fa-angle-left", "fa-diagram-successor", "fa-truck-arrow-right", "fa-arrows-split-up-and-left", "fa-hand-fist", "fa-cloud-moon", "fa-briefcase", "fa-person-falling", "fa-image-portrait", "fa-user-tag", "fa-rug", "fa-earth-europe", "fa-cart-flatbed-suitcase", "fa-rectangle-xmark", "fa-baht-sign", "fa-book-open", "fa-book-journal-whills", "fa-handcuffs", "fa-triangle-exclamation", "fa-database", "fa-share", "fa-bottle-droplet", "fa-mask-face", "fa-hill-rockslide", "fa-right-left", "fa-paper-plane", "fa-road-circle-exclamation", "fa-dungeon", "fa-align-right", "fa-money-bill-1-wave", "fa-life-ring", "fa-hands", "fa-calendar-day", "fa-water-ladder", "fa-arrows-up-down", "fa-face-grimace", "fa-wheelchair-move", "fa-turn-down", "fa-person-walking-arrow-right", "fa-square-envelope", "fa-dice", "fa-bowling-ball", "fa-brain", "fa-bandage", "fa-calendar-minus", "fa-circle-xmark", "fa-gifts", "fa-hotel", "fa-earth-asia", "fa-id-card-clip", "fa-magnifying-glass-plus", "fa-thumbs-up", "fa-user-clock", "fa-hand-dots", "fa-file-invoice", "fa-window-minimize", "fa-mug-saucer", "fa-brush", "fa-mask", "fa-magnifying-glass-minus", "fa-ruler-vertical", "fa-user-large", "fa-train-tram", "fa-user-nurse", "fa-syringe", "fa-cloud-sun", "fa-stopwatch-20", "fa-square-full", "fa-magnet", "fa-jar", "fa-note-sticky", "fa-bug-slash", "fa-arrow-up-from-water-pump", "fa-bone", "fa-user-injured", "fa-face-sad-tear", "fa-plane", "fa-tent-arrows-down", "fa-exclamation", "fa-arrows-spin", "fa-print", "fa-turkish-lira-sign", "fa-dollar-sign", "fa-x", "fa-magnifying-glass-dollar", "fa-users-gear", "fa-person-military-pointing", "fa-building-columns", "fa-umbrella", "fa-trowel", "fa-d", "fa-stapler", "fa-masks-theater", "fa-kip-sign", "fa-hand-point-left", "fa-handshake-simple", "fa-jet-fighter", "fa-square-share-nodes", "fa-barcode", "fa-plus-minus", "fa-video", "fa-graduation-cap", "fa-hand-holding-medical", "fa-person-circle-check", "fa-turn-up", "fa-bus-side", "fa-mobile-vibrate", "fa-non-binary", "fa-pentagon", "fa-septagon", "fa-single-quote-left", "fa-single-quote-right", "fa-spiral" );

		return apply_filters( 'litho_fontawesome_solid_icons', $litho_fa_icons_solid );// phpcs:ignore
	}
}

if ( ! function_exists( 'litho_fontawesome_reg' ) ) {
	/**
	 * Return Font Awesome Regular Icons
	 */
	function litho_fontawesome_reg() {

		$litho_fa_icons_reg = array( "fa-trash-can", "fa-message", "fa-file-lines", "fa-calendar-days", "fa-hand-point-right", "fa-face-smile-beam", "fa-face-grin-stars", "fa-address-book", "fa-comments", "fa-paste", "fa-face-grin-tongue-squint", "fa-face-flushed", "fa-square-caret-right", "fa-square-minus", "fa-compass", "fa-square-caret-down", "fa-face-kiss-beam", "fa-lightbulb", "fa-flag", "fa-square-check", "fa-circle-dot", "fa-face-dizzy", "fa-futbol", "fa-pen-to-square", "fa-hourglass-half", "fa-eye-slash", "fa-hand", "fa-hand-spock", "fa-face-kiss", "fa-face-grin-tongue", "fa-chess-bishop", "fa-face-grin-wink", "fa-face-grin-wide", "fa-face-frown-open", "fa-hand-point-up", "fa-bookmark", "fa-hand-point-down", "fa-folder", "fa-user", "fa-square-caret-left", "fa-star", "fa-chess-knight", "fa-face-laugh-squint", "fa-face-laugh", "fa-folder-open", "fa-clipboard", "fa-chess-queen", "fa-hand-back-fist", "fa-square-caret-up", "fa-chart-bar", "fa-window-restore", "fa-square-plus", "fa-image", "fa-folder-closed", "fa-lemon", "fa-handshake", "fa-gem", "fa-circle-play", "fa-circle-check", "fa-circle-stop", "fa-id-badge", "fa-face-laugh-beam", "fa-registered", "fa-address-card", "fa-face-tired", "fa-font-awesome", "fa-face-smile-wink", "fa-file-word", "fa-file-powerpoint", "fa-envelope-open", "fa-file-zipper", "fa-square", "fa-snowflake", "fa-newspaper", "fa-face-kiss-wink-heart", "fa-star-half-stroke", "fa-file-excel", "fa-face-grin-beam", "fa-object-ungroup", "fa-circle-right", "fa-face-rolling-eyes", "fa-object-group", "fa-heart", "fa-face-surprise", "fa-circle-pause", "fa-circle", "fa-circle-up", "fa-file-audio", "fa-file-image", "fa-circle-question", "fa-face-meh-blank", "fa-eye", "fa-face-sad-cry", "fa-file-code", "fa-window-maximize", "fa-face-frown", "fa-floppy-disk", "fa-comment-dots", "fa-face-grin-squint", "fa-hand-pointer", "fa-hand-scissors", "fa-face-grin-tears", "fa-calendar-xmark", "fa-file-video", "fa-file-pdf", "fa-comment", "fa-envelope", "fa-hourglass", "fa-calendar-check", "fa-hard-drive", "fa-face-grin-squint-tears", "fa-rectangle-list", "fa-calendar-plus", "fa-circle-left", "fa-money-bill-1", "fa-clock", "fa-keyboard", "fa-closed-captioning", "fa-images", "fa-face-grin", "fa-face-meh", "fa-id-card", "fa-sun", "fa-face-laugh-wink", "fa-circle-down", "fa-thumbs-down", "fa-chess-pawn", "fa-credit-card", "fa-bell", "fa-file", "fa-hospital", "fa-chess-rook", "fa-star-half", "fa-chess-king", "fa-circle-user", "fa-copy", "fa-share-from-square", "fa-copyright", "fa-map", "fa-bell-slash", "fa-hand-lizard", "fa-face-smile", "fa-hand-peace", "fa-face-grin-hearts", "fa-building", "fa-face-grin-beam-sweat", "fa-moon", "fa-calendar", "fa-face-grin-tongue-wink", "fa-clone", "fa-face-angry", "fa-rectangle-xmark", "fa-paper-plane", "fa-life-ring", "fa-face-grimace", "fa-calendar-minus", "fa-circle-xmark", "fa-thumbs-up", "fa-window-minimize", "fa-square-full", "fa-note-sticky", "fa-face-sad-tear", "fa-hand-point-left" );

		return apply_filters( 'litho_fontawesome_regular_icons', $litho_fa_icons_reg );// phpcs:ignore
	}
}

if ( ! function_exists( 'litho_fontawesome_brand' ) ) {
	/**
	 * Return Font Awesome Brand Icons
	 */
	function litho_fontawesome_brand() {

		$litho_fa_icons_brand = array( "fa-monero", "fa-hooli", "fa-yelp", "fa-cc-visa", "fa-lastfm", "fa-shopware", "fa-creative-commons-nc", "fa-aws", "fa-redhat", "fa-yoast", "fa-cloudflare", "fa-ups", "fa-wpexplorer", "fa-dyalog", "fa-bity", "fa-stackpath", "fa-buysellads", "fa-first-order", "fa-modx", "fa-guilded", "fa-vnv", "fa-square-js", "fa-microsoft", "fa-qq", "fa-orcid", "fa-java", "fa-invision", "fa-creative-commons-pd-alt", "fa-centercode", "fa-glide-g", "fa-drupal", "fa-hire-a-helper", "fa-creative-commons-by", "fa-unity", "fa-whmcs", "fa-rocketchat", "fa-vk", "fa-untappd", "fa-mailchimp", "fa-css3-alt", "fa-square-reddit", "fa-vimeo-v", "fa-contao", "fa-square-font-awesome", "fa-deskpro", "fa-sistrix", "fa-square-instagram", "fa-battle-net", "fa-the-red-yeti", "fa-square-hacker-news", "fa-edge", "fa-threads", "fa-napster", "fa-square-snapchat", "fa-google-plus-g", "fa-artstation", "fa-markdown", "fa-sourcetree", "fa-google-plus", "fa-diaspora", "fa-foursquare", "fa-stack-overflow", "fa-github-alt", "fa-phoenix-squadron", "fa-pagelines", "fa-algolia", "fa-red-river", "fa-creative-commons-sa", "fa-safari", "fa-google", "fa-square-font-awesome-stroke", "fa-atlassian", "fa-linkedin-in", "fa-digital-ocean", "fa-nimblr", "fa-chromecast", "fa-evernote", "fa-hacker-news", "fa-creative-commons-sampling", "fa-adversal", "fa-creative-commons", "fa-watchman-monitoring", "fa-fonticons", "fa-weixin", "fa-shirtsinbulk", "fa-codepen", "fa-git-alt", "fa-lyft", "fa-rev", "fa-windows", "fa-wizards-of-the-coast", "fa-square-viadeo", "fa-meetup", "fa-centos", "fa-adn", "fa-cloudsmith", "fa-pied-piper-alt", "fa-square-dribbble", "fa-codiepie", "fa-node", "fa-mix", "fa-steam", "fa-cc-apple-pay", "fa-scribd", "fa-debian", "fa-openid", "fa-instalod", "fa-expeditedssl", "fa-sellcast", "fa-square-twitter", "fa-r-project", "fa-delicious", "fa-freebsd", "fa-vuejs", "fa-accusoft", "fa-ioxhost", "fa-fonticons-fi", "fa-app-store", "fa-cc-mastercard", "fa-itunes-note", "fa-golang", "fa-kickstarter", "fa-grav", "fa-weibo", "fa-uncharted", "fa-firstdraft", "fa-square-youtube", "fa-wikipedia-w", "fa-wpressr", "fa-angellist", "fa-galactic-republic", "fa-nfc-directional", "fa-skype", "fa-joget", "fa-fedora", "fa-stripe-s", "fa-meta", "fa-laravel", "fa-hotjar", "fa-bluetooth-b", "fa-sticker-mule", "fa-creative-commons-zero", "fa-hips", "fa-behance", "fa-reddit", "fa-discord", "fa-chrome", "fa-app-store-ios", "fa-cc-discover", "fa-wpbeginner", "fa-confluence", "fa-mdb", "fa-dochub", "fa-accessible-icon", "fa-ebay", "fa-amazon", "fa-unsplash", "fa-yarn", "fa-square-steam", "fa-500px", "fa-square-vimeo", "fa-asymmetrik", "fa-font-awesome", "fa-gratipay", "fa-apple", "fa-hive", "fa-gitkraken", "fa-keybase", "fa-apple-pay", "fa-padlet", "fa-amazon-pay", "fa-square-github", "fa-stumbleupon", "fa-fedex", "fa-phoenix-framework", "fa-shopify", "fa-neos", "fa-square-threads", "fa-hackerrank", "fa-researchgate", "fa-swift", "fa-angular", "fa-speakap", "fa-angrycreative", "fa-y-combinator", "fa-empire", "fa-envira", "fa-square-gitlab", "fa-studiovinari", "fa-pied-piper", "fa-wordpress", "fa-product-hunt", "fa-firefox", "fa-linode", "fa-goodreads", "fa-square-odnoklassniki", "fa-jsfiddle", "fa-sith", "fa-themeisle", "fa-page4", "fa-hashnode", "fa-react", "fa-cc-paypal", "fa-squarespace", "fa-cc-stripe", "fa-creative-commons-share", "fa-bitcoin", "fa-keycdn", "fa-opera", "fa-itch-io", "fa-umbraco", "fa-galactic-senate", "fa-ubuntu", "fa-draft2digital", "fa-stripe", "fa-houzz", "fa-gg", "fa-dhl", "fa-square-pinterest", "fa-xing", "fa-blackberry", "fa-creative-commons-pd", "fa-playstation", "fa-quinscape", "fa-less", "fa-blogger-b", "fa-opencart", "fa-vine", "fa-paypal", "fa-gitlab", "fa-typo3", "fa-reddit-alien", "fa-yahoo", "fa-dailymotion", "fa-affiliatetheme", "fa-pied-piper-pp", "fa-bootstrap", "fa-odnoklassniki", "fa-nfc-symbol", "fa-ethereum", "fa-speaker-deck", "fa-creative-commons-nc-eu", "fa-patreon", "fa-avianex", "fa-ello", "fa-gofore", "fa-bimobject", "fa-facebook-f", "fa-square-google-plus", "fa-mandalorian", "fa-first-order-alt", "fa-osi", "fa-google-wallet", "fa-d-and-d-beyond", "fa-periscope", "fa-fulcrum", "fa-cloudscale", "fa-forumbee", "fa-mizuni", "fa-schlix", "fa-square-xing", "fa-bandcamp", "fa-wpforms", "fa-cloudversify", "fa-usps", "fa-megaport", "fa-magento", "fa-spotify", "fa-optin-monster", "fa-fly", "fa-aviato", "fa-itunes", "fa-cuttlefish", "fa-blogger", "fa-flickr", "fa-viber", "fa-soundcloud", "fa-digg", "fa-tencent-weibo", "fa-symfony", "fa-maxcdn", "fa-etsy", "fa-facebook-messenger", "fa-audible", "fa-think-peaks", "fa-bilibili", "fa-erlang", "fa-x-twitter", "fa-cotton-bureau", "fa-dashcube", "fa-42-group", "fa-stack-exchange", "fa-elementor", "fa-square-pied-piper", "fa-creative-commons-nd", "fa-palfed", "fa-superpowers", "fa-resolving", "fa-xbox", "fa-searchengin", "fa-tiktok", "fa-square-facebook", "fa-renren", "fa-linux", "fa-glide", "fa-linkedin", "fa-hubspot", "fa-deploydog", "fa-twitch", "fa-ravelry", "fa-mixer", "fa-square-lastfm", "fa-vimeo", "fa-mendeley", "fa-uniregistry", "fa-figma", "fa-creative-commons-remix", "fa-cc-amazon-pay", "fa-dropbox", "fa-instagram", "fa-cmplid", "fa-facebook", "fa-gripfire", "fa-jedi-order", "fa-uikit", "fa-fort-awesome-alt", "fa-phabricator", "fa-ussunnah", "fa-earlybirds", "fa-trade-federation", "fa-autoprefixer", "fa-whatsapp", "fa-slideshare", "fa-google-play", "fa-viadeo", "fa-line", "fa-google-drive", "fa-servicestack", "fa-simplybuilt", "fa-bitbucket", "fa-imdb", "fa-deezer", "fa-raspberry-pi", "fa-jira", "fa-docker", "fa-screenpal", "fa-bluetooth", "fa-gitter", "fa-d-and-d", "fa-microblog", "fa-cc-diners-club", "fa-gg-circle", "fa-pied-piper-hat", "fa-kickstarter-k", "fa-yandex", "fa-readme", "fa-html5", "fa-sellsy", "fa-sass", "fa-wirsindhandwerk", "fa-buromobelexperte", "fa-salesforce", "fa-octopus-deploy", "fa-medapps", "fa-ns8", "fa-pinterest-p", "fa-apper", "fa-fort-awesome", "fa-waze", "fa-cc-jcb", "fa-snapchat", "fa-fantasy-flight-games", "fa-rust", "fa-wix", "fa-square-behance", "fa-supple", "fa-rebel", "fa-css3", "fa-staylinked", "fa-kaggle", "fa-space-awesome", "fa-deviantart", "fa-cpanel", "fa-goodreads-g", "fa-square-git", "fa-square-tumblr", "fa-trello", "fa-creative-commons-nc-jp", "fa-get-pocket", "fa-perbyte", "fa-grunt", "fa-weebly", "fa-connectdevelop", "fa-leanpub", "fa-black-tie", "fa-themeco", "fa-python", "fa-android", "fa-bots", "fa-free-code-camp", "fa-hornbill", "fa-js", "fa-ideal", "fa-git", "fa-dev", "fa-sketch", "fa-yandex-international", "fa-cc-amex", "fa-uber", "fa-github", "fa-php", "fa-alipay", "fa-youtube", "fa-skyatlas", "fa-firefox-browser", "fa-replyd", "fa-suse", "fa-jenkins", "fa-twitter", "fa-rockrms", "fa-pinterest", "fa-buffer", "fa-npm", "fa-yammer", "fa-btc", "fa-dribbble", "fa-stumbleupon-circle", "fa-internet-explorer", "fa-stubber", "fa-telegram", "fa-old-republic", "fa-odysee", "fa-square-whatsapp", "fa-node-js", "fa-edge-legacy", "fa-slack", "fa-medrt", "fa-usb", "fa-tumblr", "fa-vaadin", "fa-quora", "fa-square-x-twitter", "fa-reacteurope", "fa-medium", "fa-amilia", "fa-mixcloud", "fa-flipboard", "fa-viacoin", "fa-critical-role", "fa-sitrox", "fa-discourse", "fa-joomla", "fa-mastodon", "fa-airbnb", "fa-wolf-pack-battalion", "fa-buy-n-large", "fa-gulp", "fa-creative-commons-sampling-plus", "fa-strava", "fa-ember", "fa-canadian-maple-leaf", "fa-teamspeak", "fa-pushed", "fa-wordpress-simple", "fa-nutritionix", "fa-wodu", "fa-google-pay", "fa-intercom", "fa-zhihu", "fa-korvue", "fa-pix", "fa-steam-symbol", "fa-cash-app", "fa-disqus", "fa-duolingo", "fa-eleventy", "fa-kakao-talk", "fa-linktree", "fa-lumon", "fa-lumon-drop", "fa-notion", "fa-openai", "fa-pandora", "fa-pixelfed", "fa-square-figma", "fa-square-linkedin", "fa-tex", "fa-tidal", "fa-vsco", "fa-w3c" );

		return apply_filters( 'litho_fontawesome_brand_icons', $litho_fa_icons_brand );// phpcs:ignore
	}
}

if ( ! function_exists( 'litho_fontawesome_light' ) ) {
	/**
	 * Return Font Awesome Light Icons
	 */
	function litho_fontawesome_light() {
		$litho_fa_icons_light = array();
		return apply_filters( 'litho_fontawesome_light_icons', $litho_fa_icons_light );// phpcs:ignore
	}
}

if ( ! function_exists( 'litho_themify_icons' ) ) {
	/**
	 * Return Themefy Icons
	 */
	function litho_themify_icons() {

		$litho_ti_icons = array( 'ti-arrow-up', 'ti-arrow-right', 'ti-arrow-left', 'ti-arrow-down', 'ti-arrows-vertical', 'ti-arrows-horizontal', 'ti-angle-up', 'ti-angle-right', 'ti-angle-left', 'ti-angle-down', 'ti-angle-double-up', 'ti-angle-double-right', 'ti-angle-double-left', 'ti-angle-double-down', 'ti-move', 'ti-fullscreen', 'ti-arrow-top-right', 'ti-arrow-top-left', 'ti-arrow-circle-up', 'ti-arrow-circle-right', 'ti-arrow-circle-left', 'ti-arrow-circle-down', 'ti-arrows-corner', 'ti-split-v', 'ti-split-v-alt', 'ti-split-h', 'ti-hand-point-up', 'ti-hand-point-right', 'ti-hand-point-left', 'ti-hand-point-down', 'ti-back-right', 'ti-back-left', 'ti-exchange-vertical', 'ti-wand', 'ti-save', 'ti-save-alt', 'ti-direction', 'ti-direction-alt', 'ti-user', 'ti-link', 'ti-unlink', 'ti-trash', 'ti-target', 'ti-tag', 'ti-desktop', 'ti-tablet', 'ti-mobile', 'ti-email', 'ti-star', 'ti-spray', 'ti-signal', 'ti-shopping-cart', 'ti-shopping-cart-full', 'ti-settings', 'ti-search', 'ti-zoom-in', 'ti-zoom-out', 'ti-cut', 'ti-ruler', 'ti-ruler-alt-2', 'ti-ruler-pencil', 'ti-ruler-alt', 'ti-bookmark', 'ti-bookmark-alt', 'ti-reload', 'ti-plus', 'ti-minus', 'ti-close', 'ti-pin', 'ti-pencil', 'ti-pencil-alt', 'ti-paint-roller', 'ti-paint-bucket', 'ti-na', 'ti-medall', 'ti-medall-alt', 'ti-marker', 'ti-marker-alt', 'ti-lock', 'ti-unlock', 'ti-location-arrow', 'ti-layout', 'ti-layers', 'ti-layers-alt', 'ti-key', 'ti-image', 'ti-heart', 'ti-heart-broken', 'ti-hand-stop', 'ti-hand-open', 'ti-hand-drag', 'ti-flag', 'ti-flag-alt', 'ti-flag-alt-2', 'ti-eye', 'ti-import', 'ti-export', 'ti-cup', 'ti-crown', 'ti-comments', 'ti-comment', 'ti-comment-alt', 'ti-thought', 'ti-clip', 'ti-check', 'ti-check-box', 'ti-camera', 'ti-announcement', 'ti-brush', 'ti-brush-alt', 'ti-palette', 'ti-briefcase', 'ti-bolt', 'ti-bolt-alt', 'ti-blackboard', 'ti-bag', 'ti-world', 'ti-wheelchair', 'ti-car', 'ti-truck', 'ti-timer', 'ti-ticket', 'ti-thumb-up', 'ti-thumb-down', 'ti-stats-up', 'ti-stats-down', 'ti-shine', 'ti-shift-right', 'ti-shift-left', 'ti-shift-right-alt', 'ti-shift-left-alt', 'ti-shield', 'ti-notepad', 'ti-server', 'ti-pulse', 'ti-printer', 'ti-power-off', 'ti-plug', 'ti-pie-chart', 'ti-panel', 'ti-package', 'ti-music', 'ti-music-alt', 'ti-mouse', 'ti-mouse-alt', 'ti-money', 'ti-microphone', 'ti-menu', 'ti-menu-alt', 'ti-map', 'ti-map-alt', 'ti-location-pin', 'ti-light-bulb', 'ti-info', 'ti-infinite', 'ti-id-badge', 'ti-hummer', 'ti-home', 'ti-help', 'ti-headphone', 'ti-harddrives', 'ti-harddrive', 'ti-gift', 'ti-game', 'ti-filter', 'ti-files', 'ti-file', 'ti-zip', 'ti-folder', 'ti-envelope', 'ti-dashboard', 'ti-cloud', 'ti-cloud-up', 'ti-cloud-down', 'ti-clipboard', 'ti-calendar', 'ti-book', 'ti-bell', 'ti-basketball', 'ti-bar-chart', 'ti-bar-chart-alt', 'ti-archive', 'ti-anchor', 'ti-alert', 'ti-alarm-clock', 'ti-agenda', 'ti-write', 'ti-wallet', 'ti-video-clapper', 'ti-video-camera', 'ti-vector', 'ti-support', 'ti-stamp', 'ti-slice', 'ti-shortcode', 'ti-receipt', 'ti-pin2', 'ti-pin-alt', 'ti-pencil-alt2', 'ti-eraser', 'ti-more', 'ti-more-alt', 'ti-microphone-alt', 'ti-magnet', 'ti-line-double', 'ti-line-dotted', 'ti-line-dashed', 'ti-ink-pen', 'ti-info-alt', 'ti-help-alt', 'ti-headphone-alt', 'ti-gallery', 'ti-face-smile', 'ti-face-sad', 'ti-credit-card', 'ti-comments-smiley', 'ti-time', 'ti-share', 'ti-share-alt', 'ti-rocket', 'ti-new-window', 'ti-rss', 'ti-rss-alt', 'ti-control-stop', 'ti-control-shuffle', 'ti-control-play', 'ti-control-pause', 'ti-control-forward', 'ti-control-backward', 'ti-volume', 'ti-control-skip-forward', 'ti-control-skip-backward', 'ti-control-record', 'ti-control-eject', 'ti-paragraph', 'ti-uppercase', 'ti-underline', 'ti-text', 'ti-Italic', 'ti-smallcap', 'ti-list', 'ti-list-ol', 'ti-align-right', 'ti-align-left', 'ti-align-justify', 'ti-align-center', 'ti-quote-right', 'ti-quote-left', 'ti-layout-width-full', 'ti-layout-width-default', 'ti-layout-width-default-alt', 'ti-layout-tab', 'ti-layout-tab-window', 'ti-layout-tab-v', 'ti-layout-tab-min', 'ti-layout-slider', 'ti-layout-slider-alt', 'ti-layout-sidebar-right', 'ti-layout-sidebar-none', 'ti-layout-sidebar-left', 'ti-layout-placeholder', 'ti-layout-menu', 'ti-layout-menu-v', 'ti-layout-menu-separated', 'ti-layout-menu-full', 'ti-layout-media-right', 'ti-layout-media-right-alt', 'ti-layout-media-overlay', 'ti-layout-media-overlay-alt', 'ti-layout-media-overlay-alt-2', 'ti-layout-media-left', 'ti-layout-media-left-alt', 'ti-layout-media-center', 'ti-layout-media-center-alt', 'ti-layout-list-thumb', 'ti-layout-list-thumb-alt', 'ti-layout-list-post', 'ti-layout-list-large-image', 'ti-layout-line-solid', 'ti-layout-grid4', 'ti-layout-grid3', 'ti-layout-grid2', 'ti-layout-grid2-thumb', 'ti-layout-cta-right', 'ti-layout-cta-left', 'ti-layout-cta-center', 'ti-layout-cta-btn-right', 'ti-layout-cta-btn-left', 'ti-layout-column4', 'ti-layout-column3', 'ti-layout-column2', 'ti-layout-accordion-separated', 'ti-layout-accordion-merged', 'ti-layout-accordion-list', 'ti-widgetized', 'ti-widget', 'ti-widget-alt', 'ti-view-list', 'ti-view-list-alt', 'ti-view-grid', 'ti-upload', 'ti-download', 'ti-loop', 'ti-layout-sidebar-2', 'ti-layout-grid4-alt', 'ti-layout-grid3-alt', 'ti-layout-grid2-alt', 'ti-layout-column4-alt', 'ti-layout-column3-alt', 'ti-layout-column2-alt', 'ti-flickr', 'ti-flickr-alt', 'ti-instagram', 'ti-google', 'ti-github', 'ti-facebook', 'ti-dropbox', 'ti-dropbox-alt', 'ti-dribbble', 'ti-apple', 'ti-android', 'ti-yahoo', 'ti-trello', 'ti-stack-overflow', 'ti-soundcloud', 'ti-sharethis', 'ti-sharethis-alt', 'ti-reddit', 'ti-microsoft', 'ti-microsoft-alt', 'ti-linux', 'ti-jsfiddle', 'ti-joomla', 'ti-html5', 'ti-css3', 'ti-drupal', 'ti-wordpress', 'ti-tumblr', 'ti-tumblr-alt', 'ti-skype', 'ti-youtube', 'ti-vimeo', 'ti-vimeo-alt', 'ti-twitter', 'ti-twitter-alt', 'ti-linkedin', 'ti-pinterest', 'ti-pinterest-alt', 'ti-themify-logo', 'ti-themify-favicon', 'ti-themify-favicon-alt' );

		return apply_filters( 'litho_themify_icons', $litho_ti_icons );// phpcs:ignore
	}
}

if ( ! function_exists( 'litho_simple_icons' ) ) {
	/**
	 * Return Simple Line Icons
	 */
	function litho_simple_icons() {

		$litho_sl_icons = array( 'icon-simple-line-action-redo', 'icon-simple-line-action-undo', 'icon-simple-line-anchor', 'icon-simple-line-arrow-down', 'icon-simple-line-arrow-left', 'icon-simple-line-arrow-right', 'icon-simple-line-arrow-up', 'icon-simple-line-badge', 'icon-simple-line-bag', 'icon-simple-line-ban', 'icon-simple-line-bar-chart', 'icon-simple-line-basket', 'icon-simple-line-basket-loaded', 'icon-simple-line-bell', 'icon-simple-line-book-open', 'icon-simple-line-briefcase', 'icon-simple-line-bubble', 'icon-simple-line-bubbles', 'icon-simple-line-bulb', 'icon-simple-line-calculator', 'icon-simple-line-calendar', 'icon-simple-line-call-end', 'icon-simple-line-call-in', 'icon-simple-line-call-out', 'icon-simple-line-camcorder', 'icon-simple-line-camera', 'icon-simple-line-check', 'icon-simple-line-chemistry', 'icon-simple-line-clock', 'icon-simple-line-close', 'icon-simple-line-cloud-download', 'icon-simple-line-cloud-upload', 'icon-simple-line-compass', 'icon-simple-line-control-end', 'icon-simple-line-control-forward', 'icon-simple-line-control-pause', 'icon-simple-line-control-play', 'icon-simple-line-control-rewind', 'icon-simple-line-control-start', 'icon-simple-line-credit-card', 'icon-simple-line-crop', 'icon-simple-line-cup', 'icon-simple-line-cursor', 'icon-simple-line-cursor-move', 'icon-simple-line-diamond', 'icon-simple-line-direction', 'icon-simple-line-directions', 'icon-simple-line-disc', 'icon-simple-line-dislike', 'icon-simple-line-doc', 'icon-simple-line-docs', 'icon-simple-line-drawer', 'icon-simple-line-drop', 'icon-simple-line-earphones', 'icon-simple-line-earphones-alt', 'icon-simple-line-emoticon-smile', 'icon-simple-line-energy', 'icon-simple-line-envelope', 'icon-simple-line-envelope-letter', 'icon-simple-line-envelope-open', 'icon-simple-line-equalizer', 'icon-simple-line-eye', 'icon-simple-line-eyeglasses', 'icon-simple-line-feed', 'icon-simple-line-film', 'icon-simple-line-fire', 'icon-simple-line-flag', 'icon-simple-line-folder', 'icon-simple-line-folder-alt', 'icon-simple-line-frame', 'icon-simple-line-game-controller', 'icon-simple-line-ghost', 'icon-simple-line-globe', 'icon-simple-line-globe-alt', 'icon-simple-line-graduation', 'icon-simple-line-graph', 'icon-simple-line-grid', 'icon-simple-line-handbag', 'icon-simple-line-heart', 'icon-simple-line-home', 'icon-simple-line-hourglass', 'icon-simple-line-info', 'icon-simple-line-key', 'icon-simple-line-layers', 'icon-simple-line-like', 'icon-simple-line-link', 'icon-simple-line-list', 'icon-simple-line-lock', 'icon-simple-line-lock-open', 'icon-simple-line-login', 'icon-simple-line-logout', 'icon-simple-line-loop', 'icon-simple-line-magic-wand', 'icon-simple-line-magnet', 'icon-simple-line-magnifier', 'icon-simple-line-magnifier-add', 'icon-simple-line-magnifier-remove', 'icon-simple-line-map', 'icon-simple-line-microphone', 'icon-simple-line-mouse', 'icon-simple-line-moustache', 'icon-simple-line-music-tone', 'icon-simple-line-music-tone-alt', 'icon-simple-line-note', 'icon-simple-line-notebook', 'icon-simple-line-paper-clip', 'icon-simple-line-paper-plane', 'icon-simple-line-pencil', 'icon-simple-line-picture', 'icon-simple-line-pie-chart', 'icon-simple-line-pin', 'icon-simple-line-plane', 'icon-simple-line-playlist', 'icon-simple-line-plus', 'icon-simple-line-pointer', 'icon-simple-line-power', 'icon-simple-line-present', 'icon-simple-line-printer', 'icon-simple-line-puzzle', 'icon-simple-line-question', 'icon-simple-line-refresh', 'icon-simple-line-reload', 'icon-simple-line-rocket', 'icon-simple-line-screen-desktop', 'icon-simple-line-screen-smartphone', 'icon-simple-line-screen-tablet', 'icon-simple-line-settings', 'icon-simple-line-share', 'icon-simple-line-share-alt', 'icon-simple-line-shield', 'icon-simple-line-shuffle', 'icon-simple-line-size-actual', 'icon-simple-line-size-fullscreen', 'icon-simple-line-social-dribbble', 'icon-simple-line-social-dropbox', 'icon-simple-line-social-facebook', 'icon-simple-line-social-tumblr', 'icon-simple-line-social-twitter', 'icon-simple-line-social-youtube', 'icon-simple-line-speech', 'icon-simple-line-speedometer', 'icon-simple-line-star', 'icon-simple-line-support', 'icon-simple-line-symbol-female', 'icon-simple-line-symbol-male', 'icon-simple-line-tag', 'icon-simple-line-target', 'icon-simple-line-trash', 'icon-simple-line-trophy', 'icon-simple-line-umbrella', 'icon-simple-line-user', 'icon-simple-line-user-female', 'icon-simple-line-user-follow', 'icon-simple-line-user-following', 'icon-simple-line-user-unfollow', 'icon-simple-line-users', 'icon-simple-line-vector', 'icon-simple-line-volume-1', 'icon-simple-line-volume-2', 'icon-simple-line-volume-off', 'icon-simple-line-wallet', 'icon-simple-line-wrench' );

		return apply_filters( 'litho_simple_icons', $litho_sl_icons );// phpcs:ignore
	}
}
