<?php
// phpcs:ignoreFile

class MSLMS_Migration {
	public static $instance = null;

	public static function get_instance() {
		return is_null( self::$instance ) ? self::$instance = new self() : self::$instance;
	}

	public function __construct() {

		add_action( 'wp_ajax_nopriv_MSLMS_ZOOM_migration_action', array( $this, 'MSLMS_ZOOM_migration' ) );
		add_action( 'wp_ajax_MSLMS_ZOOM_migration_action', array( $this, 'MSLMS_ZOOM_migration' ) );

		add_action( 'admin_enqueue_scripts', array( $this, 'migration_enqueue_scripts' ), 100 );
		add_action( 'admin_footer', array( $this, 'load_template' ) );

	}

	public function MSLMS_ZOOM_migration() {
		$nonce_verified = wp_verify_nonce( $_POST['nonce'], 'MSLMS_ZOOM_migration_ajax' );

		$accountID    = $_POST['accountID'] ?? '';
		$clientID     = $_POST['clientID'] ?? '';
		$clientSecret = $_POST['clientSecret'] ?? '';
		$settings     = get_option( 'stm_zoom_settings', array() );

		if ( $nonce_verified ) {
			$result = \Zoom\Interfaces\S2SOAuth::get_instance()->generateAccessToken( $accountID, $clientID, $clientSecret );
			if ( ! is_wp_error( $result ) ) {
				$settings['auth_account_id']    = $accountID;
				$settings['auth_client_id']     = $clientID;
				$settings['auth_client_secret'] = $clientSecret;
				update_option( 'stm_zoom_settings', $settings );

				wp_send_json_success( array( 'message' => 'That\'s it, we\'re all done. Thank you for continuing to use eRoom with Zoom API.' ) );
			} else {
				if ( is_wp_error( $result ) ) {
					wp_send_json_error( array( 'message' => $result->get_error_message() . ' Please double-check your credentials' ), 403 );
				} else {
					wp_send_json_error( array( 'message' => $result->get_error_message() . ' Please double-check your credentials' ), $result->get_error_code() );
				}
			}
		}
	}

	public function load_template() {
		load_template( MSLMS_ZOOM_PATH . '/admin_templates/migration/migration.php' );
	}

	public function migration_enqueue_scripts() {
		wp_enqueue_style( 'stm-zoom-migration', MSLMS_ZOOM_URL . 'assets/css/admin/migration.css', false, MSLMS_ZOOM_VERSION );
		wp_enqueue_script( 'stm-zoom-migration', MSLMS_ZOOM_URL . 'assets/js/admin/migration.js', false, MSLMS_ZOOM_VERSION );
		wp_enqueue_style( 'stm_migration_admin', MSLMS_ZOOM_URL . 'assets/css/admin/migration.css', false, MSLMS_ZOOM_VERSION );
		wp_localize_script(
			'stm-zoom-migration',
			'MSLMS_ZOOM_migration_demo_ajax_variable',
			array(
				'url'   => admin_url( 'admin-ajax.php' ),
				'nonce' => wp_create_nonce( 'MSLMS_ZOOM_migration_ajax' ),
			)
		);
	}
}
