<?php
// phpcs:ignoreFile
/**
 * Test JWT signature generation
 * Run this file directly to test the JWT generation
 */

// Include WordPress
require_once('../../../../../../wp-config.php');

// Include our JWT function
require_once('jwt-signature.php');

// Test data
$app_key = 'jYoc6s7USJSE4pB6VgLqDw';
$app_secret = 'EYak8M7ostM6RQdXa0ytMu6pdmWKkU0w';
$meeting_number = '87669974904';
$role = 0;

echo "Testing JWT signature generation...\n";
echo "App Key: $app_key\n";
echo "Meeting Number: $meeting_number\n";
echo "Role: $role\n\n";

try {
    $signature = mslms_generate_zoom_jwt_signature($app_key, $app_secret, $meeting_number, $role);
    echo "Generated JWT Signature:\n";
    echo $signature . "\n\n";
    
    // Decode and verify the JWT structure
    $parts = explode('.', $signature);
    if (count($parts) === 3) {
        $header = json_decode(base64_decode(str_replace(['-', '_'], ['+', '/'], $parts[0])), true);
        $payload = json_decode(base64_decode(str_replace(['-', '_'], ['+', '/'], $parts[1])), true);
        
        echo "JWT Header:\n";
        print_r($header);
        echo "\nJWT Payload:\n";
        print_r($payload);
        
        // Verify required fields
        $required_fields = ['appKey', 'sdkKey', 'mn', 'role', 'iat', 'exp', 'tokenExp'];
        $missing_fields = [];
        
        foreach ($required_fields as $field) {
            if (!isset($payload[$field])) {
                $missing_fields[] = $field;
            }
        }
        
        if (empty($missing_fields)) {
            echo "\n✅ All required fields present!\n";
        } else {
            echo "\n❌ Missing required fields: " . implode(', ', $missing_fields) . "\n";
        }
    } else {
        echo "❌ Invalid JWT format\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}

