<?php
// phpcs:ignoreFile
/**
 * MasterStudy LMS Zoom Conference Addon
 * 
 * This addon integrates eRoom Zoom functionality into MasterStudy LMS
 * with MasterStudy namespace and mslms_ prefixes.
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Define MasterStudy constants
define( 'MSLMS_ZOOM_CONFERENCE_VERSION', '1.0.0' );
define( 'MSLMS_ZOOM_CONFERENCE_PATH', STM_LMS_PRO_ADDONS . '/zoom_conference' );
define( 'MSLMS_ZOOM_CONFERENCE_URL', STM_LMS_PRO_URL . 'addons/zoom_conference/' );

// Include eRoom core functionality
require_once MSLMS_ZOOM_CONFERENCE_PATH . '/mszoom-core.php';

// Include zoom-conference classes
require_once MSLMS_ZOOM_CONFERENCE_PATH . '/zoom-conference/init.php';

// Include JWT signature generation for SDK 4.0.7+
require_once MSLMS_ZOOM_CONFERENCE_PATH . '/includes/jwt-signature.php';

// Include MasterStudy integration
require_once MSLMS_ZOOM_CONFERENCE_PATH . '/zoom_plugins/zoom.php';

// Add zoom settings link to MasterStudy Zoom Conference settings
add_action( 'admin_init', 'mslms_add_zoom_settings_link' );

/**
 * Add zoom settings link to MasterStudy Zoom Conference settings page
 */
function mslms_add_zoom_settings_link() {
	// Add filter to inject eRoom Zoom Settings link into MasterStudy Zoom Conference settings
	add_filter( 'stm_zoom_settings', 'mslms_add_eroom_settings_link' );
}

/**
 * Add eRoom Zoom Settings link to MasterStudy Zoom Conference settings
 */
function mslms_add_eroom_settings_link( $settings ) {
	// Add a custom field that displays the eRoom settings link
	$settings['eroom_settings_link'] = array(
		'type' => 'custom_html',
		'label' => esc_html__( 'eRoom Zoom Settings', 'masterstudy-lms-learning-management-system-pro' ),
		'html' => sprintf(
			'<div style="padding: 20px; background: #f1f1f1; border-radius: 5px; margin: 20px 0;">
				<h3>%s</h3>
				<p>%s</p>
				<a href="%s" class="button button-primary">%s</a>
			</div>',
			esc_html__( 'eRoom Zoom Meetings & Webinars', 'masterstudy-lms-learning-management-system-pro' ),
			esc_html__( 'Access advanced Zoom meeting management features including meetings, users, statistics, and detailed settings.', 'masterstudy-lms-learning-management-system-pro' ),
			esc_url( admin_url( 'admin.php?page=stm-zoom' ) ),
			esc_html__( 'Open eRoom Zoom Settings', 'masterstudy-lms-learning-management-system-pro' )
		),
	);

	return $settings;
}

// Enqueue eRoom assets
add_action( 'wp_enqueue_scripts', 'mslms_zoom_conference_enqueue_assets' );
add_action( 'admin_enqueue_scripts', 'mslms_zoom_conference_admin_assets' );

/**
 * Enqueue frontend assets
 */
function mslms_zoom_conference_enqueue_assets() {
	// Enqueue eRoom frontend assets
	wp_enqueue_style(
		'mslms-zoom-frontend',
		MSLMS_ZOOM_CONFERENCE_URL . '/assets/css/frontend/main.css',
		array(),
		MSLMS_ZOOM_CONFERENCE_VERSION
	);

	wp_enqueue_script(
		'mslms-zoom-frontend',
		MSLMS_ZOOM_CONFERENCE_URL . '/assets/js/frontend/main.js',
		array( 'jquery' ),
		MSLMS_ZOOM_CONFERENCE_VERSION,
		true
	);

	// Enqueue countdown script
	wp_enqueue_script(
		'mslms-zoom-countdown',
		MSLMS_ZOOM_CONFERENCE_URL . '/assets/js/frontend/jquery.countdown.js',
		array( 'jquery' ),
		MSLMS_ZOOM_CONFERENCE_VERSION,
		true
	);

	// Zoom Web SDK files are only loaded when needed (in meeting_view.php template)
}

/**
 * Enqueue admin assets
 */
function mslms_zoom_conference_admin_assets() {
	// Enqueue eRoom admin assets
	wp_enqueue_style(
		'mslms-zoom-admin',
		MSLMS_ZOOM_CONFERENCE_URL . '/assets/css/admin/main.css',
		array(),
		MSLMS_ZOOM_CONFERENCE_VERSION
	);

	wp_enqueue_script(
		'mslms-zoom-admin',
		MSLMS_ZOOM_CONFERENCE_URL . '/assets/js/admin/main.js',
		array( 'jquery' ),
		MSLMS_ZOOM_CONFERENCE_VERSION,
		true
	);

	wp_enqueue_script(
		'mslms-zoom-meetings-webinars',
		MSLMS_ZOOM_CONFERENCE_URL . '/assets/js/admin/meetings_webinars.js',
		array( 'jquery' ),
		MSLMS_ZOOM_CONFERENCE_VERSION,
		true
	);
}

// Add MasterStudy namespace to eRoom functions
add_action( 'init', 'mslms_zoom_conference_add_namespace', 1 );

/**
 * Add MasterStudy namespace to eRoom functionality
 */
function mslms_zoom_conference_add_namespace() {
	// This function will be used to add MasterStudy namespace prefixes
	// to eRoom functions and classes as needed
}