<?php
// phpcs:ignoreFile
/**
 * Main file
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} //Exit if accessed directly

// Define eRoom constants using MasterStudy paths (only if not already defined)
if ( ! defined( 'MSLMS_ZOOM_VERSION' ) ) {
	define( 'MSLMS_ZOOM_VERSION', '1.4.30' );
}
if ( ! defined( 'MSLMS_ZOOM_DB_VERSION' ) ) {
	define( 'MSLMS_ZOOM_DB_VERSION', '1.2.9' );
}
if ( ! defined( 'MSLMS_ZOOM_FILE' ) ) {
	define( 'MSLMS_ZOOM_FILE', MSLMS_ZOOM_CONFERENCE_PATH . '/mszoom-core.php' );
}
if ( ! defined( 'MSLMS_ZOOM_DIR' ) ) {
	define( 'MSLMS_ZOOM_DIR', MSLMS_ZOOM_CONFERENCE_PATH );
}
if ( ! defined( 'MSLMS_ZOOM_PATH' ) ) {
	define( 'MSLMS_ZOOM_PATH', MSLMS_ZOOM_CONFERENCE_PATH );
}
if ( ! defined( 'MSLMS_ZOOM_URL' ) ) {
	define( 'MSLMS_ZOOM_URL', MSLMS_ZOOM_CONFERENCE_URL );
}
if ( ! defined( 'MSLMS_EROOM_WP_TESTED_UP' ) ) {
	define( 'MSLMS_EROOM_WP_TESTED_UP', '6.4' );
}

// STM_ZOOM constants removed - using only MSLMS_ZOOM constants

// Mailchimp integration removed to prevent conflicts with original eRoom plugin

if ( ! is_textdomain_loaded( 'masterstudy-lms-learning-management-system-pro' ) ) {
	load_plugin_textdomain(
		'masterstudy-lms-learning-management-system-pro',
		false,
		'eroom-zoom-meetings-webinar/languages'
	);
}

// Load Composer autoloader only if not already loaded
if ( ! class_exists( 'ComposerAutoloaderInitfb7cb05c9391e50d89e45161cad75b3c' ) ) {
	// Use main plugin's autoloader instead of zoom-app vendor
	require_once dirname( MSLMS_ZOOM_PATH, 2 ) . '/vendor/autoload.php';
}
require_once MSLMS_ZOOM_PATH . '/includes/helpers.php';
require_once MSLMS_ZOOM_PATH . '/zoom-conference/init.php';
require_once MSLMS_ZOOM_PATH . '/vc/main.php';

if ( did_action( 'elementor/loaded' ) ) {
	require MSLMS_ZOOM_PATH . '/elementor/StmZoomElementor.php';
}

if ( is_admin() ) {

	require_once MSLMS_ZOOM_PATH . '/includes/item-announcements.php';
	require_once MSLMS_ZOOM_PATH . '/includes/conflux.php';
	require_once MSLMS_ZOOM_PATH . '/includes/migration/migration.php';
	require_once MSLMS_ZOOM_PATH . '/admin_templates/notices/required_fields.php';
	require_once MSLMS_ZOOM_PATH . '/google-meet/StmERoomGoogleMeet.php';

		new MSLMS_StmERoomGoogleMeet();
}
