<?php
// phpcs:ignoreFile
add_action( 'vc_after_init', 'MSLMS_ZOOM_meeting' );

function MSLMS_ZOOM_meeting()
{
    vc_map( array(
        'name' => esc_html__( 'Zoom Meeting', 'masterstudy-lms-learning-management-system-pro' ),
        'base' => 'MSLMS_ZOOM_meeting',
        'icon' => 'fas fa-video',
        'html_template' => MSLMS_ZOOM_PATH . '/vc/templates/MSLMS_ZOOM_meeting.php',
        'category' => array(
            esc_html__( 'Content', 'masterstudy-lms-learning-management-system-pro' ),
        ),
        'params' => array(
            array(
                'type' => 'dropdown',
                'heading' => __( 'Meeting', 'masterstudy-lms-learning-management-system-pro' ),
                'param_name' => 'meeting_id',
                'value' => array_flip( mslms_get_meetings() )
            )
        )
    ) );

    vc_map( array(
        'name' => esc_html__( 'Zoom Webinar', 'masterstudy-lms-learning-management-system-pro' ),
        'base' => 'MSLMS_ZOOM_webinar',
        'icon' => 'fas fa-video',
        'html_template' => MSLMS_ZOOM_PATH . '/vc/templates/MSLMS_ZOOM_webinar.php',
        'category' => array(
            esc_html__( 'Content', 'masterstudy-lms-learning-management-system-pro' ),
        ),
        'params' => array(
            array(
                'type' => 'dropdown',
                'heading' => __( 'Webinar', 'masterstudy-lms-learning-management-system-pro' ),
                'param_name' => 'webinar_id',
                'value' => array_flip( mslms_get_webinars() )
            )
        )
    ) );

    $grid_params = array(
        array(
            'type' => 'textfield',
            'heading' => __( 'Count of meetings', 'masterstudy-lms-learning-management-system-pro' ),
            'param_name' => 'count',
            'value' => '3',
        ),
        array(
            'type' => 'dropdown',
            'heading' => __( 'Meetings per row', 'masterstudy-lms-learning-management-system-pro' ),
            'param_name' => 'per_row',
            'value' => array(
                '1' => '1',
                '2' => '2',
                '3' => '3',
                '4' => '4',
                '5' => '5',
            ),
            'std' => '3'
        )
    );

    if ( class_exists( 'StmZoomPro' ) ) {
        $grid_params[] =             array(
            'type' => 'dropdown',
            'heading' => __( 'Meeting type', 'masterstudy-lms-learning-management-system-pro' ),
            'param_name' => 'post_type',
            'value' => array(
                esc_html__('Products', 'masterstudy-lms-learning-management-system-pro') => 'product',
                esc_html__('Meetings', 'masterstudy-lms-learning-management-system-pro') => 'stm-zoom',
                esc_html__('Webinars', 'masterstudy-lms-learning-management-system-pro') => 'stm-zoom-webinar'
            ),
            'std' => 'stm-zoom'
        );
    }

    vc_map( array(
        'name' => esc_html__( 'Zoom Meetings/Webinars Grid', 'masterstudy-lms-learning-management-system-pro' ),
        'base' => 'MSLMS_ZOOM_meeting',
        'icon' => 'fas fa-video',
        'html_template' => MSLMS_ZOOM_PATH . '/vc/templates/MSLMS_ZOOM_meetings_grid.php',
        'category' => array(
            esc_html__( 'Content', 'masterstudy-lms-learning-management-system-pro' ),
        ),
        'params' => $grid_params
    ) );
}

if( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_MSLMS_ZOOM_Meeting extends WPBakeryShortCode
    {
    }
    class WPBakeryShortCode_MSLMS_ZOOM_Webinar extends WPBakeryShortCode
    {
    }
    class WPBakeryShortCode_MSLMS_ZOOM_Meetings_Grid extends WPBakeryShortCode
    {
    }
}