<?php

defined( 'ABSPATH' ) || exit;

// Define the master plugins JSON endpoint
define( 'MASTER_PLUGINS_JSON_URL', BUCKET_API_URL . '/wp-content/uploads/bucket-manager/master-plugins.json' );

// Define the base URL for plugin zip files
define( 'PLUGIN_ZIP_BASE_URL', BUCKET_API_URL . '/wp-content/uploads/bucket-manager/' );

function json_error_notice() {
   echo '<div class="notice notice-error is-dismissible">
       <p>' . esc_html( 'Unable to connect to KeyStone server. Failed to retrieve valid JSON data.', 'maxreach' ) . '</p>
   </div>';
}

function http_error_notice( $error_message = '' ) {
   echo '<div class="notice notice-error is-dismissible">
       <p>' . esc_html( 'Unable to connect to KeyStone server. ' . ( ! empty( $error_message ) ? $error_message : 'Failed to fetch data from the server.' ), 'maxreach' ) . '</p>
   </div>';
}

function get_plugin_versions() {
   // Get the JSON data from the master plugins endpoint
   $response = wp_remote_get( MASTER_PLUGINS_JSON_URL );
  
   // Check for a successful response
   if ( ! is_wp_error( $response ) && wp_remote_retrieve_response_code( $response ) === 200 ) {
       $json_contents = wp_remote_retrieve_body( $response );

       // Decode the JSON data
       $data = json_decode( $json_contents, true );

       // Check if JSON decoding was successful and data structure is as expected
       if ( $data !== null && is_array( $data ) ) {
           // Return the entire data array which contains plugin names and versions
           return $data;
       } else {
           add_action( 'admin_notices', 'json_error_notice' );
           return null;
       }
   } else {
       $error_message = is_wp_error( $response ) ? $response->get_error_message() : wp_remote_retrieve_response_message( $response );
       add_action( 'admin_notices', function() use ( $error_message ) {
           http_error_notice( $error_message );
       } );
       return null;
   }
}

function get_plugin_zip_url( $plugin_name, $version ) {
   // Build the plugin zip URL using the new structure
   return PLUGIN_ZIP_BASE_URL . '/' . $plugin_name . '/' . $plugin_name . '-' . $version . '.zip';
}

function build_plugin_array( $plugin_versions = null ) {
   $plugins = array();
   
   // WordPress Repository Plugins
   $wp_plugins = array(
       array(
           'name'         => esc_html__( 'Elementor', 'maxreach' ),
           'slug'         => 'elementor',
           'required'     => true,
           'external_url' => 'https://wordpress.org/plugins/elementor/',
       ),
       array(
           'name'         => esc_html__( 'Contact Form 7', 'maxreach' ),
           'slug'         => 'contact-form-7',
           'required'     => false,
       ),
       array(
           'name'         => esc_html__( 'ElementsKit', 'maxreach' ),
           'slug'         => 'elementskit-lite',
           'required'     => true,
       ),
       array(
           'name'         => esc_html__( 'Woocommerce', 'maxreach' ),
           'slug'         => 'woocommerce',
           'required'     => false,
       ),
   );
   
   // Add WordPress repository plugins
   $plugins = array_merge( $plugins, $wp_plugins );
   
   // Remote Plugins from JSON
   if ( $plugin_versions !== null && is_array( $plugin_versions ) ) {
       $remote_plugins = array(
           array(
               'name'     => esc_html__( 'Keystone Framework', 'maxreach' ),
               'slug'     => 'keystone-framework',
               'remote'   => true,
               'required' => false, // Make it optional to prevent failures
           ),
           
           /*
           array(
               'name'     => esc_html__( 'DesignBox', 'maxreach' ),
               'slug'     => 'designbox',
               'remote'   => true,
               'required' => false,
           ), */

           array(
               'name'     => esc_html__( 'ElementsKit Pro', 'maxreach' ),
               'slug'     => 'elementskit',
               'remote'   => true,
               'required' => false,
           ),
           
       );
       
       // Process remote plugins and add source URLs and versions
       foreach ( $remote_plugins as $plugin ) {
           $plugin_slug = $plugin['slug'];
           
           if ( isset( $plugin_versions[ $plugin_slug ] ) ) {
               $version = $plugin_versions[ $plugin_slug ];
               $plugin['version'] = $version;
               $plugin['source'] = get_plugin_zip_url( $plugin_slug, $version );
           }
           
           $plugins[] = $plugin;
       }
   }
   
   return $plugins;
}

if ( ! function_exists( 'keystone_register_plugins' ) ) {
   function keystone_register_plugins() {
      
       $plugin_versions = get_plugin_versions();
       $plugins = build_plugin_array( $plugin_versions );
      
       $config = array(
           'id'           => 'maxreach',
           'default_path' => '',
           'menu'         => 'install-required-plugins',
           'has_notices'  => true,
           'dismissable'  => true,
           'is_automatic' => false,
           'message'      => '',
           'strings'      => array(
               'page_title'                      => esc_html__( 'Install Required Plugins', 'maxreach' ),
               'menu_title'                      => esc_html__( 'Install Plugins', 'maxreach' ),
               'installing'                      => esc_html__( 'Installing Plugin: %s', 'maxreach' ),
               'oops'                            => esc_html__( 'Something went wrong with the plugin API.', 'maxreach' ),
               'notice_can_install_required'     => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'maxreach' ),
               'notice_can_install_recommended'  => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'maxreach' ),
               'notice_cannot_install'           => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'maxreach' ),
               'notice_can_activate_required'    => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'maxreach' ),
               'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'maxreach' ),
               'notice_cannot_activate'          => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'maxreach' ),
               'notice_ask_to_update'            => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'maxreach' ),
               'notice_cannot_update'            => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'maxreach' ),
               'install_link'                    => _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'maxreach' ),
               'activate_link'                   => _n_noop( 'Activate installed plugin', 'Activate installed plugins', 'maxreach' ),
               'return'                          => esc_html__( 'Return to Required Plugins Installer', 'maxreach' ),
               'plugin_activated'                => esc_html__( 'Plugin activated successfully.', 'maxreach' ),
               'complete'                        => esc_html__( 'All plugins installed and activated successfully. %s', 'maxreach' ),
               'nag_type'                        => 'updated'
           )
       );
      
       tgmpa( $plugins, $config );
   }
  
   add_action( 'tgmpa_register', 'keystone_register_plugins' );
}


if ( ! function_exists( 'keystone_deactivate_ocdi' ) ) {
   function keystone_deactivate_ocdi() {
       $plugin_file = WP_PLUGIN_DIR . '/one-click-demo-import/one-click-demo-import.php';
       if ( file_exists( $plugin_file ) ) {
           deactivate_plugins( 'one-click-demo-import/one-click-demo-import.php' );
       }
   }
}
add_action( 'admin_init', 'keystone_deactivate_ocdi' );



