<?php
 /**
  * Theme Hook Alliance hook stub list.
  *
  * @link https://github.com/zamoose/themehookalliance
  */

add_theme_support( 'keystone_hooks', array(
	'all',
	'html',
	'body',
	'head',
	'header',
	'content',
	'entry',
	'comments',
	'sidebars',
	'sidebar',
	'footer',
) );

/**
 * Determines, whether the specific hook type is actually supported.
 *
 * Plugin developers should always check for the support of a <strong>specific</strong>
 * hook type before hooking a callback function to a hook of this type.
 *
 * Example:
 * <code>
 * 		if ( current_theme_supports( 'keystone_hooks', 'header' ) )
 * 	  		add_action( 'keystone_head_top', 'prefix_header_top' );
 * </code>
 *
 * @param bool $bool true
 * @param array $args The hook type being checked
 * @param array $registered All registered hook types
 *
 * @return bool
 */
function keystone_current_theme_supports( $bool, $args, $registered ) {
	return in_array( $args[0], $registered[0] ) || in_array( 'all', $registered[0] );
}
add_filter( 'current_theme_supports-keystone_hooks', 'keystone_current_theme_supports', 10, 3 );

/**
 * HTML <html> hook
 * Special case, useful for <DOCTYPE>, etc.
 * $keystone_supports[] = 'html;
 */
function keystone_html_before() {
	do_action( 'keystone_html_before' );
}
/**
 * HTML <body> hooks
 * $keystone_supports[] = 'body';
 */
function keystone_body_top() {
	do_action( 'keystone_body_top' );
}

function keystone_body_bottom() {
	do_action( 'keystone_body_bottom' );
}

/**
 * HTML <head> hooks
 *
 * $keystone_supports[] = 'head';
 */
function keystone_head_top() {
	do_action( 'keystone_head_top' );
}

function keystone_head_bottom() {
	do_action( 'keystone_head_bottom' );
}

/**
 * Semantic <header> hooks
 *
 * $keystone_supports[] = 'header';
 */
function keystone_header_before() {
	do_action( 'keystone_header_before' );
}

function keystone_header_after() {
	do_action( 'keystone_header_after' );
}

function keystone_header_top() {
	do_action( 'keystone_header_top' );
}

function keystone_header_bottom() {
	do_action( 'keystone_header_bottom' );
}

function keystone_header() {
	do_action( 'keystone_header' );
}

function keystone_page_header_before() {
	do_action( 'keystone_page_header_before' );
}

function keystone_page_header_after() {
	do_action( 'keystone_page_header_after' );
}

function keystone_page_header_top() {
	do_action( 'keystone_page_header_top' );
}

function keystone_page_header_bottom() {
	do_action( 'keystone_page_header_bottom' );
}

function keystone_page_header_content() {
	do_action( 'keystone_page_header_content' );
}

/**
 * Semantic <content> hooks
 *
 * $keystone_supports[] = 'content';
 */
function keystone_content_before() {
	do_action( 'keystone_content_before' );
}

function keystone_content_after() {
	do_action( 'keystone_content_after' );
}

function keystone_content_top() {
	do_action( 'keystone_content_top' );
}

function keystone_content_bottom() {
	do_action( 'keystone_content_bottom' );
}

function keystone_content_primary_top() {
	do_action( 'keystone_content_primary_top' );
}

function keystone_content_primary_bottom() {
	do_action( 'keystone_content_primary_bottom' );
}

function keystone_content_while_before() {
	do_action( 'keystone_content_while_before' );
}

function keystone_content_while_after() {
	do_action( 'keystone_content_while_after' );
}

function keystone_content_page() {
	do_action( 'keystone_content_page' );
}

function keystone_content_single() {
	do_action( 'keystone_content_single' );
}

function keystone_content_loop() {
	do_action( 'keystone_content_loop' );
}

function keystone_content_404_page() {
	do_action( 'keystone_content_404_page' );
}

/**
 * Semantic <entry> hooks
 *
 * $keystone_supports[] = 'entry';
 */
function keystone_entry_before() {
	do_action( 'keystone_entry_before' );
}

function keystone_entry_after() {
	do_action( 'keystone_entry_after' );
}

function keystone_entry_content_before() {
	do_action( 'keystone_entry_content_before' );
}

function keystone_entry_content_after() {
	do_action( 'keystone_entry_content_after' );
}

function keystone_entry_top() {
	do_action( 'keystone_entry_top' );
}

function keystone_entry_bottom() {
	do_action( 'keystone_entry_bottom' );
}

function keystone_entry_wrapper_top() {
	do_action( 'keystone_entry_wrapper_top' );
}

function keystone_entry_wrapper_bottom() {
	do_action( 'keystone_entry_wrapper_bottom' );
}

function keystone_entry_content_card() {
	do_action( 'keystone_entry_content_card' );
}

function keystone_single_entry_content_top() {
	do_action( 'keystone_single_entry_content_top' );
}

function keystone_single_entry_content_bottom() {
	do_action( 'keystone_single_entry_content_bottom' );
}

/**
 * Post meta hooks
 */
function keystone_post_meta_top() {
	do_action( 'keystone_post_meta_top' );
}

function keystone_post_meta_bottom() {
	do_action( 'keystone_post_meta_bottom' );
}

/**
 * Comments block hooks
 *
 * $keystone_supports[] = 'comments';
 */
function keystone_comments_before() {
	do_action( 'keystone_comments_before' );
}

function keystone_comments_after() {
	do_action( 'keystone_comments_after' );
}

/**
 * Semantic <sidebar> hooks
 *
 * $keystone_supports[] = 'sidebar';
 */
function keystone_sidebars_before() {
	do_action( 'keystone_sidebars_before' );
}

function keystone_sidebars_after() {
	do_action( 'keystone_sidebars_after' );
}

/**
 * Related posts block hooks
 */

function keystone_related_content_before() {
	do_action( 'keystone_related_content_before' );
}

function keystone_related_content_after() {
	do_action( 'keystone_related_content_after' );
}

function keystone_related_content_top() {
	do_action( 'keystone_related_content_top' );
}

function keystone_related_content_bottom() {
	do_action( 'keystone_related_content_bottom' );
}
/**
 * Semantic <footer> hooks
 *
 * $keystone_supports[] = 'footer';
 */
function keystone_footer_before() {
	do_action( 'keystone_footer_before' );
}

function keystone_footer_after() {
	do_action( 'keystone_footer_after' );
}

function keystone_footer_top() {
	do_action( 'keystone_footer_top' );
}

function keystone_footer_bottom() {
	do_action( 'keystone_footer_bottom' );
}

function keystone_footer() {
	do_action( 'keystone_footer' );
}

/**
 *  Backwards compatibility for wp_body_open()
 */
if ( ! function_exists( 'wp_body_open' ) ) {
	function wp_body_open() {
		do_action( 'wp_body_open' );
	}
}
