<?php
add_filter( 'keystone_theme_options', function( $setup ) {

    $fields = array(
        'portfolio_settings_section_title' => array(
            'type' => 'group_title',
            'label' => esc_html__( 'Portfolio Settings', 'keystone-framework' ),
            'description' => sprintf(
				esc_html__( 'Note: After making changes to this section, you need to %1$sflush the rewrite rules%2$s.', 'keystone-framework' ),
				'<a href="https://help.keystonethemes.com/documentation/flush-rewrite-rules/" target="_blank">',
				'</a>'
			),
            'submenu' => esc_html__( 'Portfolio Settings', 'keystone-framework' ),
        ),
        'portfolio_cpt_switch' => array(
            'type' => 'radio',
            'label' => esc_html__( 'Portfolio Post Type', 'keystone-framework' ),
            'description' => esc_html__( 'Turn on to enable the portfolio post type.', 'keystone-framework' ),
			'options' => array(
                'enable' => esc_html__( 'Enable', 'keystone-framework' ),
                'disable' => esc_html__( 'Disable', 'keystone-framework' ),
            ),
            'value' => 'enable',
            'submenu' => esc_html__( 'Portfolio Settings', 'keystone-framework' ),
        ),
        'portfolio_cpt_slug' => array(
            'type' => 'text',
            'label' => esc_html__( 'Portfolio Slug', 'keystone-framework' ),
            'description' => esc_html__( 'Use this field to overwrite the portfolio slug.', 'keystone-framework' ),
            'dependency' => array(
                'key' => 'portfolio_cpt_switch',
                'value' => 'enable'
            ),
            'submenu' => esc_html__( 'Portfolio Settings', 'keystone-framework' ),
        ),
        'portfolio_cpt_category_slug' => array(
            'type' => 'text',
            'label' => esc_html__( 'Portfolio Category Slug', 'keystone-framework' ),
            'description' => esc_html__( 'Use this field to overwrite the portfolio category slug.', 'keystone-framework' ),
            'dependency' => array(
                'key' => 'portfolio_cpt_switch',
                'value' => 'enable'
            ),
            'submenu' => esc_html__( 'Portfolio Settings', 'keystone-framework' ),
        ),
        'portfolio_tab_label' => array(
            'type' => 'group_title',
            'label' => esc_html__( 'Single Portfolio', 'keystone-framework' ),
            'submenu' => esc_html__( 'Single Portfolio', 'keystone-framework' ),
        ),
        'portfolio_pagination_switch' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Previous/Next Pagination', 'keystone-framework' ),
            'description' => esc_html__( 'Turn on to display previous/next pagination.', 'keystone-framework' ),
            'value' => true,
            'submenu' => esc_html__( 'Single Portfolio', 'keystone-framework' ),
        ),
        'portfolio_related_switch' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Related Portfolio Items', 'keystone-framework' ),
            'description' => esc_html__( 'Turn on to display related portfolio items.', 'keystone-framework' ),
            'value' => true,
            'group' => 'started',
            'submenu' => esc_html__( 'Single Portfolio', 'keystone-framework' ),
        ),
        'portfolio_related_title' => array(
            'type' => 'text',
            'label' => esc_html__( 'Related Portfolio Section Title', 'keystone-framework' ),
            'description' => esc_html__( 'Enter a title for the Related Portfolio Items section.', 'keystone-framework' ),
            'dependency' => array(
                'key' => 'portfolio_related_switch',
                'value' => 'not_empty'
            ),
            'submenu' => esc_html__( 'Single Portfolio', 'keystone-framework' ),
        ),
        'portfolio_related_number' => array(
            'type' => 'range_slider',
            'label' => esc_html__( 'Number of Related Portfolio Items', 'keystone-framework' ),
            'description' => esc_html__( 'Select the number of related items.', 'keystone-framework' ),
            'min' => 2,
            'max' => 4,
            'step' => 1,
            'value' => 3,
            'dependency' => array(
                'key' => 'portfolio_related_switch',
                'value' => 'not_empty'
            ),
            'group' => 'ended',
            'submenu' => esc_html__( 'Single Portfolio', 'keystone-framework' ),
        ),
        'portfolio_comments_switch' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Comments Section', 'keystone-framework' ),
            'description' => esc_html__( 'Turn on to display comments.', 'keystone-framework' ),
            'value' => false,
            'submenu' => esc_html__( 'Single Portfolio', 'keystone-framework' ),
        ),
    );

    $customFields = array(
        'name' => esc_html__( 'Portfolio', 'keystone-framework' ),
        'icon' => 'lnricons-pictures',
        'fields' => $fields
    );

    $setup[ 'portfolio' ] = $customFields;

    return $setup;

}, 10, 1 );
